package org.simdjson;

class NumberParserTables {

    static final int[] NUMBER_OF_ADDITIONAL_DIGITS_AFTER_LEFT_SHIFT = {
            0x0000, 0x0800, 0x0801, 0x0803, 0x1006, 0x1009, 0x100D, 0x1812, 0x1817,
            0x181D, 0x2024, 0x202B, 0x2033, 0x203C, 0x2846, 0x2850, 0x285B, 0x3067,
            0x3073, 0x3080, 0x388E, 0x389C, 0x38AB, 0x38BB, 0x40CC, 0x40DD, 0x40EF,
            0x4902, 0x4915, 0x4929, 0x513E, 0x5153, 0x5169, 0x5180, 0x5998, 0x59B0,
            0x59C9, 0x61E3, 0x61FD, 0x6218, 0x6A34, 0x6A50, 0x6A6D, 0x6A8B, 0x72AA,
            0x72C9, 0x72E9, 0x7B0A, 0x7B2B, 0x7B4D, 0x8370, 0x8393, 0x83B7, 0x83DC,
            0x8C02, 0x8C28, 0x8C4F, 0x9477, 0x949F, 0x94C8, 0x9CF2, 0x051C, 0x051C,
            0x051C, 0x051C
    };

    static final byte[] POWER_OF_FIVE_DIGITS = {
            5, 2, 5, 1, 2, 5, 6, 2, 5, 3, 1, 2, 5, 1, 5, 6, 2, 5, 7, 8, 1, 2, 5,
            3, 9, 0, 6, 2, 5, 1, 9, 5, 3, 1, 2, 5, 9, 7, 6, 5, 6, 2, 5, 4, 8, 8,
            2, 8, 1, 2, 5, 2, 4, 4, 1, 4, 0, 6, 2, 5, 1, 2, 2, 0, 7, 0, 3, 1, 2,
            5, 6, 1, 0, 3, 5, 1, 5, 6, 2, 5, 3, 0, 5, 1, 7, 5, 7, 8, 1, 2, 5, 1,
            5, 2, 5, 8, 7, 8, 9, 0, 6, 2, 5, 7, 6, 2, 9, 3, 9, 4, 5, 3, 1, 2, 5,
            3, 8, 1, 4, 6, 9, 7, 2, 6, 5, 6, 2, 5, 1, 9, 0, 7, 3, 4, 8, 6, 3, 2,
            8, 1, 2, 5, 9, 5, 3, 6, 7, 4, 3, 1, 6, 4, 0, 6, 2, 5, 4, 7, 6, 8, 3,
            7, 1, 5, 8, 2, 0, 3, 1, 2, 5, 2, 3, 8, 4, 1, 8, 5, 7, 9, 1, 0, 1, 5,
            6, 2, 5, 1, 1, 9, 2, 0, 9, 2, 8, 9, 5, 5, 0, 7, 8, 1, 2, 5, 5, 9, 6,
            0, 4, 6, 4, 4, 7, 7, 5, 3, 9, 0, 6, 2, 5, 2, 9, 8, 0, 2, 3, 2, 2, 3,
            8, 7, 6, 9, 5, 3, 1, 2, 5, 1, 4, 9, 0, 1, 1, 6, 1, 1, 9, 3, 8, 4, 7,
            6, 5, 6, 2, 5, 7, 4, 5, 0, 5, 8, 0, 5, 9, 6, 9, 2, 3, 8, 2, 8, 1, 2,
            5, 3, 7, 2, 5, 2, 9, 0, 2, 9, 8, 4, 6, 1, 9, 1, 4, 0, 6, 2, 5, 1, 8,
            6, 2, 6, 4, 5, 1, 4, 9, 2, 3, 0, 9, 5, 7, 0, 3, 1, 2, 5, 9, 3, 1, 3,
            2, 2, 5, 7, 4, 6, 1, 5, 4, 7, 8, 5, 1, 5, 6, 2, 5, 4, 6, 5, 6, 6, 1,
            2, 8, 7, 3, 0, 7, 7, 3, 9, 2, 5, 7, 8, 1, 2, 5, 2, 3, 2, 8, 3, 0, 6,
            4, 3, 6, 5, 3, 8, 6, 9, 6, 2, 8, 9, 0, 6, 2, 5, 1, 1, 6, 4, 1, 5, 3,
            2, 1, 8, 2, 6, 9, 3, 4, 8, 1, 4, 4, 5, 3, 1, 2, 5, 5, 8, 2, 0, 7, 6,
            6, 0, 9, 1, 3, 4, 6, 7, 4, 0, 7, 2, 2, 6, 5, 6, 2, 5, 2, 9, 1, 0, 3,
            8, 3, 0, 4, 5, 6, 7, 3, 3, 7, 0, 3, 6, 1, 3, 2, 8, 1, 2, 5, 1, 4, 5,
            5, 1, 9, 1, 5, 2, 2, 8, 3, 6, 6, 8, 5, 1, 8, 0, 6, 6, 4, 0, 6, 2, 5,
            7, 2, 7, 5, 9, 5, 7, 6, 1, 4, 1, 8, 3, 4, 2, 5, 9, 0, 3, 3, 2, 0, 3,
            1, 2, 5, 3, 6, 3, 7, 9, 7, 8, 8, 0, 7, 0, 9, 1, 7, 1, 2, 9, 5, 1, 6,
            6, 0, 1, 5, 6, 2, 5, 1, 8, 1, 8, 9, 8, 9, 4, 0, 3, 5, 4, 5, 8, 5, 6,
            4, 7, 5, 8, 3, 0, 0, 7, 8, 1, 2, 5, 9, 0, 9, 4, 9, 4, 7, 0, 1, 7, 7,
            2, 9, 2, 8, 2, 3, 7, 9, 1, 5, 0, 3, 9, 0, 6, 2, 5, 4, 5, 4, 7, 4, 7,
            3, 5, 0, 8, 8, 6, 4, 6, 4, 1, 1, 8, 9, 5, 7, 5, 1, 9, 5, 3, 1, 2, 5,
            2, 2, 7, 3, 7, 3, 6, 7, 5, 4, 4, 3, 2, 3, 2, 0, 5, 9, 4, 7, 8, 7, 5,
            9, 7, 6, 5, 6, 2, 5, 1, 1, 3, 6, 8, 6, 8, 3, 7, 7, 2, 1, 6, 1, 6, 0,
            2, 9, 7, 3, 9, 3, 7, 9, 8, 8, 2, 8, 1, 2, 5, 5, 6, 8, 4, 3, 4, 1, 8,
            8, 6, 0, 8, 0, 8, 0, 1, 4, 8, 6, 9, 6, 8, 9, 9, 4, 1, 4, 0, 6, 2, 5,
            2, 8, 4, 2, 1, 7, 0, 9, 4, 3, 0, 4, 0, 4, 0, 0, 7, 4, 3, 4, 8, 4, 4,
            9, 7, 0, 7, 0, 3, 1, 2, 5, 1, 4, 2, 1, 0, 8, 5, 4, 7, 1, 5, 2, 0, 2,
            0, 0, 3, 7, 1, 7, 4, 2, 2, 4, 8, 5, 3, 5, 1, 5, 6, 2, 5, 7, 1, 0, 5,
            4, 2, 7, 3, 5, 7, 6, 0, 1, 0, 0, 1, 8, 5, 8, 7, 1, 1, 2, 4, 2, 6, 7,
            5, 7, 8, 1, 2, 5, 3, 5, 5, 2, 7, 1, 3, 6, 7, 8, 8, 0, 0, 5, 0, 0, 9,
            2, 9, 3, 5, 5, 6, 2, 1, 3, 3, 7, 8, 9, 0, 6, 2, 5, 1, 7, 7, 6, 3, 5,
            6, 8, 3, 9, 4, 0, 0, 2, 5, 0, 4, 6, 4, 6, 7, 7, 8, 1, 0, 6, 6, 8, 9,
            4, 5, 3, 1, 2, 5, 8, 8, 8, 1, 7, 8, 4, 1, 9, 7, 0, 0, 1, 2, 5, 2, 3,
            2, 3, 3, 8, 9, 0, 5, 3, 3, 4, 4, 7, 2, 6, 5, 6, 2, 5, 4, 4, 4, 0, 8,
            9, 2, 0, 9, 8, 5, 0, 0, 6, 2, 6, 1, 6, 1, 6, 9, 4, 5, 2, 6, 6, 7, 2,
            3, 6, 3, 2, 8, 1, 2, 5, 2, 2, 2, 0, 4, 4, 6, 0, 4, 9, 2, 5, 0, 3, 1,
            3, 0, 8, 0, 8, 4, 7, 2, 6, 3, 3, 3, 6, 1, 8, 1, 6, 4, 0, 6, 2, 5, 1,
            1, 1, 0, 2, 2, 3, 0, 2, 4, 6, 2, 5, 1, 5, 6, 5, 4, 0, 4, 2, 3, 6, 3,
            1, 6, 6, 8, 0, 9, 0, 8, 2, 0, 3, 1, 2, 5, 5, 5, 5, 1, 1, 1, 5, 1, 2,
            3, 1, 2, 5, 7, 8, 2, 7, 0, 2, 1, 1, 8, 1, 5, 8, 3, 4, 0, 4, 5, 4, 1,
            0, 1, 5, 6, 2, 5, 2, 7, 7, 5, 5, 5, 7, 5, 6, 1, 5, 6, 2, 8, 9, 1, 3,
            5, 1, 0, 5, 9, 0, 7, 9, 1, 7, 0, 2, 2, 7, 0, 5, 0, 7, 8, 1, 2, 5, 1,
            3, 8, 7, 7, 7, 8, 7, 8, 0, 7, 8, 1, 4, 4, 5, 6, 7, 5, 5, 2, 9, 5, 3,
            9, 5, 8, 5, 1, 1, 3, 5, 2, 5, 3, 9, 0, 6, 2, 5, 6, 9, 3, 8, 8, 9, 3,
            9, 0, 3, 9, 0, 7, 2, 2, 8, 3, 7, 7, 6, 4, 7, 6, 9, 7, 9, 2, 5, 5, 6,
            7, 6, 2, 6, 9, 5, 3, 1, 2, 5, 3, 4, 6, 9, 4, 4, 6, 9, 5, 1, 9, 5, 3,
            6, 1, 4, 1, 8, 8, 8, 2, 3, 8, 4, 8, 9, 6, 2, 7, 8, 3, 8, 1, 3, 4, 7,
            6, 5, 6, 2, 5, 1, 7, 3, 4, 7, 2, 3, 4, 7, 5, 9, 7, 6, 8, 0, 7, 0, 9,
            4, 4, 1, 1, 9, 2, 4, 4, 8, 1, 3, 9, 1, 9, 0, 6, 7, 3, 8, 2, 8, 1, 2,
            5, 8, 6, 7, 3, 6, 1, 7, 3, 7, 9, 8, 8, 4, 0, 3, 5, 4, 7, 2, 0, 5, 9,
            6, 2, 2, 4, 0, 6, 9, 5, 9, 5, 3, 3, 6, 9, 1, 4, 0, 6, 2, 5
    };

    static final int MIN_POWER_OF_FIVE = -342;

    static final long[] POWERS_OF_FIVE = {
            0xeef453d6923bd65aL, 0x113faa2906a13b3fL,
            0x9558b4661b6565f8L, 0x4ac7ca59a424c507L,
            0xbaaee17fa23ebf76L, 0x5d79bcf00d2df649L,
            0xe95a99df8ace6f53L, 0xf4d82c2c107973dcL,
            0x91d8a02bb6c10594L, 0x79071b9b8a4be869L,
            0xb64ec836a47146f9L, 0x9748e2826cdee284L,
            0xe3e27a444d8d98b7L, 0xfd1b1b2308169b25L,
            0x8e6d8c6ab0787f72L, 0xfe30f0f5e50e20f7L,
            0xb208ef855c969f4fL, 0xbdbd2d335e51a935L,
            0xde8b2b66b3bc4723L, 0xad2c788035e61382L,
            0x8b16fb203055ac76L, 0x4c3bcb5021afcc31L,
            0xaddcb9e83c6b1793L, 0xdf4abe242a1bbf3dL,
            0xd953e8624b85dd78L, 0xd71d6dad34a2af0dL,
            0x87d4713d6f33aa6bL, 0x8672648c40e5ad68L,
            0xa9c98d8ccb009506L, 0x680efdaf511f18c2L,
            0xd43bf0effdc0ba48L, 0x212bd1b2566def2L,
            0x84a57695fe98746dL, 0x14bb630f7604b57L,
            0xa5ced43b7e3e9188L, 0x419ea3bd35385e2dL,
            0xcf42894a5dce35eaL, 0x52064cac828675b9L,
            0x818995ce7aa0e1b2L, 0x7343efebd1940993L,
            0xa1ebfb4219491a1fL, 0x1014ebe6c5f90bf8L,
            0xca66fa129f9b60a6L, 0xd41a26e077774ef6L,
            0xfd00b897478238d0L, 0x8920b098955522b4L,
            0x9e20735e8cb16382L, 0x55b46e5f5d5535b0L,
            0xc5a890362fddbc62L, 0xeb2189f734aa831dL,
            0xf712b443bbd52b7bL, 0xa5e9ec7501d523e4L,
            0x9a6bb0aa55653b2dL, 0x47b233c92125366eL,
            0xc1069cd4eabe89f8L, 0x999ec0bb696e840aL,
            0xf148440a256e2c76L, 0xc00670ea43ca250dL,
            0x96cd2a865764dbcaL, 0x380406926a5e5728L,
            0xbc807527ed3e12bcL, 0xc605083704f5ecf2L,
            0xeba09271e88d976bL, 0xf7864a44c633682eL,
            0x93445b8731587ea3L, 0x7ab3ee6afbe0211dL,
            0xb8157268fdae9e4cL, 0x5960ea05bad82964L,
            0xe61acf033d1a45dfL, 0x6fb92487298e33bdL,
            0x8fd0c16206306babL, 0xa5d3b6d479f8e056L,
            0xb3c4f1ba87bc8696L, 0x8f48a4899877186cL,
            0xe0b62e2929aba83cL, 0x331acdabfe94de87L,
            0x8c71dcd9ba0b4925L, 0x9ff0c08b7f1d0b14L,
            0xaf8e5410288e1b6fL, 0x7ecf0ae5ee44dd9L,
            0xdb71e91432b1a24aL, 0xc9e82cd9f69d6150L,
            0x892731ac9faf056eL, 0xbe311c083a225cd2L,
            0xab70fe17c79ac6caL, 0x6dbd630a48aaf406L,
            0xd64d3d9db981787dL, 0x92cbbccdad5b108L,
            0x85f0468293f0eb4eL, 0x25bbf56008c58ea5L,
            0xa76c582338ed2621L, 0xaf2af2b80af6f24eL,
            0xd1476e2c07286faaL, 0x1af5af660db4aee1L,
            0x82cca4db847945caL, 0x50d98d9fc890ed4dL,
            0xa37fce126597973cL, 0xe50ff107bab528a0L,
            0xcc5fc196fefd7d0cL, 0x1e53ed49a96272c8L,
            0xff77b1fcbebcdc4fL, 0x25e8e89c13bb0f7aL,
            0x9faacf3df73609b1L, 0x77b191618c54e9acL,
            0xc795830d75038c1dL, 0xd59df5b9ef6a2417L,
            0xf97ae3d0d2446f25L, 0x4b0573286b44ad1dL,
            0x9becce62836ac577L, 0x4ee367f9430aec32L,
            0xc2e801fb244576d5L, 0x229c41f793cda73fL,
            0xf3a20279ed56d48aL, 0x6b43527578c1110fL,
            0x9845418c345644d6L, 0x830a13896b78aaa9L,
            0xbe5691ef416bd60cL, 0x23cc986bc656d553L,
            0xedec366b11c6cb8fL, 0x2cbfbe86b7ec8aa8L,
            0x94b3a202eb1c3f39L, 0x7bf7d71432f3d6a9L,
            0xb9e08a83a5e34f07L, 0xdaf5ccd93fb0cc53L,
            0xe858ad248f5c22c9L, 0xd1b3400f8f9cff68L,
            0x91376c36d99995beL, 0x23100809b9c21fa1L,
            0xb58547448ffffb2dL, 0xabd40a0c2832a78aL,
            0xe2e69915b3fff9f9L, 0x16c90c8f323f516cL,
            0x8dd01fad907ffc3bL, 0xae3da7d97f6792e3L,
            0xb1442798f49ffb4aL, 0x99cd11cfdf41779cL,
            0xdd95317f31c7fa1dL, 0x40405643d711d583L,
            0x8a7d3eef7f1cfc52L, 0x482835ea666b2572L,
            0xad1c8eab5ee43b66L, 0xda3243650005eecfL,
            0xd863b256369d4a40L, 0x90bed43e40076a82L,
            0x873e4f75e2224e68L, 0x5a7744a6e804a291L,
            0xa90de3535aaae202L, 0x711515d0a205cb36L,
            0xd3515c2831559a83L, 0xd5a5b44ca873e03L,
            0x8412d9991ed58091L, 0xe858790afe9486c2L,
            0xa5178fff668ae0b6L, 0x626e974dbe39a872L,
            0xce5d73ff402d98e3L, 0xfb0a3d212dc8128fL,
            0x80fa687f881c7f8eL, 0x7ce66634bc9d0b99L,
            0xa139029f6a239f72L, 0x1c1fffc1ebc44e80L,
            0xc987434744ac874eL, 0xa327ffb266b56220L,
            0xfbe9141915d7a922L, 0x4bf1ff9f0062baa8L,
            0x9d71ac8fada6c9b5L, 0x6f773fc3603db4a9L,
            0xc4ce17b399107c22L, 0xcb550fb4384d21d3L,
            0xf6019da07f549b2bL, 0x7e2a53a146606a48L,
            0x99c102844f94e0fbL, 0x2eda7444cbfc426dL,
            0xc0314325637a1939L, 0xfa911155fefb5308L,
            0xf03d93eebc589f88L, 0x793555ab7eba27caL,
            0x96267c7535b763b5L, 0x4bc1558b2f3458deL,
            0xbbb01b9283253ca2L, 0x9eb1aaedfb016f16L,
            0xea9c227723ee8bcbL, 0x465e15a979c1cadcL,
            0x92a1958a7675175fL, 0xbfacd89ec191ec9L,
            0xb749faed14125d36L, 0xcef980ec671f667bL,
            0xe51c79a85916f484L, 0x82b7e12780e7401aL,
            0x8f31cc0937ae58d2L, 0xd1b2ecb8b0908810L,
            0xb2fe3f0b8599ef07L, 0x861fa7e6dcb4aa15L,
            0xdfbdcece67006ac9L, 0x67a791e093e1d49aL,
            0x8bd6a141006042bdL, 0xe0c8bb2c5c6d24e0L,
            0xaecc49914078536dL, 0x58fae9f773886e18L,
            0xda7f5bf590966848L, 0xaf39a475506a899eL,
            0x888f99797a5e012dL, 0x6d8406c952429603L,
            0xaab37fd7d8f58178L, 0xc8e5087ba6d33b83L,
            0xd5605fcdcf32e1d6L, 0xfb1e4a9a90880a64L,
            0x855c3be0a17fcd26L, 0x5cf2eea09a55067fL,
            0xa6b34ad8c9dfc06fL, 0xf42faa48c0ea481eL,
            0xd0601d8efc57b08bL, 0xf13b94daf124da26L,
            0x823c12795db6ce57L, 0x76c53d08d6b70858L,
            0xa2cb1717b52481edL, 0x54768c4b0c64ca6eL,
            0xcb7ddcdda26da268L, 0xa9942f5dcf7dfd09L,
            0xfe5d54150b090b02L, 0xd3f93b35435d7c4cL,
            0x9efa548d26e5a6e1L, 0xc47bc5014a1a6dafL,
            0xc6b8e9b0709f109aL, 0x359ab6419ca1091bL,
            0xf867241c8cc6d4c0L, 0xc30163d203c94b62L,
            0x9b407691d7fc44f8L, 0x79e0de63425dcf1dL,
            0xc21094364dfb5636L, 0x985915fc12f542e4L,
            0xf294b943e17a2bc4L, 0x3e6f5b7b17b2939dL,
            0x979cf3ca6cec5b5aL, 0xa705992ceecf9c42L,
            0xbd8430bd08277231L, 0x50c6ff782a838353L,
            0xece53cec4a314ebdL, 0xa4f8bf5635246428L,
            0x940f4613ae5ed136L, 0x871b7795e136be99L,
            0xb913179899f68584L, 0x28e2557b59846e3fL,
            0xe757dd7ec07426e5L, 0x331aeada2fe589cfL,
            0x9096ea6f3848984fL, 0x3ff0d2c85def7621L,
            0xb4bca50b065abe63L, 0xfed077a756b53a9L,
            0xe1ebce4dc7f16dfbL, 0xd3e8495912c62894L,
            0x8d3360f09cf6e4bdL, 0x64712dd7abbbd95cL,
            0xb080392cc4349decL, 0xbd8d794d96aacfb3L,
            0xdca04777f541c567L, 0xecf0d7a0fc5583a0L,
            0x89e42caaf9491b60L, 0xf41686c49db57244L,
            0xac5d37d5b79b6239L, 0x311c2875c522ced5L,
            0xd77485cb25823ac7L, 0x7d633293366b828bL,
            0x86a8d39ef77164bcL, 0xae5dff9c02033197L,
            0xa8530886b54dbdebL, 0xd9f57f830283fdfcL,
            0xd267caa862a12d66L, 0xd072df63c324fd7bL,
            0x8380dea93da4bc60L, 0x4247cb9e59f71e6dL,
            0xa46116538d0deb78L, 0x52d9be85f074e608L,
            0xcd795be870516656L, 0x67902e276c921f8bL,
            0x806bd9714632dff6L, 0xba1cd8a3db53b6L,
            0xa086cfcd97bf97f3L, 0x80e8a40eccd228a4L,
            0xc8a883c0fdaf7df0L, 0x6122cd128006b2cdL,
            0xfad2a4b13d1b5d6cL, 0x796b805720085f81L,
            0x9cc3a6eec6311a63L, 0xcbe3303674053bb0L,
            0xc3f490aa77bd60fcL, 0xbedbfc4411068a9cL,
            0xf4f1b4d515acb93bL, 0xee92fb5515482d44L,
            0x991711052d8bf3c5L, 0x751bdd152d4d1c4aL,
            0xbf5cd54678eef0b6L, 0xd262d45a78a0635dL,
            0xef340a98172aace4L, 0x86fb897116c87c34L,
            0x9580869f0e7aac0eL, 0xd45d35e6ae3d4da0L,
            0xbae0a846d2195712L, 0x8974836059cca109L,
            0xe998d258869facd7L, 0x2bd1a438703fc94bL,
            0x91ff83775423cc06L, 0x7b6306a34627ddcfL,
            0xb67f6455292cbf08L, 0x1a3bc84c17b1d542L,
            0xe41f3d6a7377eecaL, 0x20caba5f1d9e4a93L,
            0x8e938662882af53eL, 0x547eb47b7282ee9cL,
            0xb23867fb2a35b28dL, 0xe99e619a4f23aa43L,
            0xdec681f9f4c31f31L, 0x6405fa00e2ec94d4L,
            0x8b3c113c38f9f37eL, 0xde83bc408dd3dd04L,
            0xae0b158b4738705eL, 0x9624ab50b148d445L,
            0xd98ddaee19068c76L, 0x3badd624dd9b0957L,
            0x87f8a8d4cfa417c9L, 0xe54ca5d70a80e5d6L,
            0xa9f6d30a038d1dbcL, 0x5e9fcf4ccd211f4cL,
            0xd47487cc8470652bL, 0x7647c3200069671fL,
            0x84c8d4dfd2c63f3bL, 0x29ecd9f40041e073L,
            0xa5fb0a17c777cf09L, 0xf468107100525890L,
            0xcf79cc9db955c2ccL, 0x7182148d4066eeb4L,
            0x81ac1fe293d599bfL, 0xc6f14cd848405530L,
            0xa21727db38cb002fL, 0xb8ada00e5a506a7cL,
            0xca9cf1d206fdc03bL, 0xa6d90811f0e4851cL,
            0xfd442e4688bd304aL, 0x908f4a166d1da663L,
            0x9e4a9cec15763e2eL, 0x9a598e4e043287feL,
            0xc5dd44271ad3cdbaL, 0x40eff1e1853f29fdL,
            0xf7549530e188c128L, 0xd12bee59e68ef47cL,
            0x9a94dd3e8cf578b9L, 0x82bb74f8301958ceL,
            0xc13a148e3032d6e7L, 0xe36a52363c1faf01L,
            0xf18899b1bc3f8ca1L, 0xdc44e6c3cb279ac1L,
            0x96f5600f15a7b7e5L, 0x29ab103a5ef8c0b9L,
            0xbcb2b812db11a5deL, 0x7415d448f6b6f0e7L,
            0xebdf661791d60f56L, 0x111b495b3464ad21L,
            0x936b9fcebb25c995L, 0xcab10dd900beec34L,
            0xb84687c269ef3bfbL, 0x3d5d514f40eea742L,
            0xe65829b3046b0afaL, 0xcb4a5a3112a5112L,
            0x8ff71a0fe2c2e6dcL, 0x47f0e785eaba72abL,
            0xb3f4e093db73a093L, 0x59ed216765690f56L,
            0xe0f218b8d25088b8L, 0x306869c13ec3532cL,
            0x8c974f7383725573L, 0x1e414218c73a13fbL,
            0xafbd2350644eeacfL, 0xe5d1929ef90898faL,
            0xdbac6c247d62a583L, 0xdf45f746b74abf39L,
            0x894bc396ce5da772L, 0x6b8bba8c328eb783L,
            0xab9eb47c81f5114fL, 0x66ea92f3f326564L,
            0xd686619ba27255a2L, 0xc80a537b0efefebdL,
            0x8613fd0145877585L, 0xbd06742ce95f5f36L,
            0xa798fc4196e952e7L, 0x2c48113823b73704L,
            0xd17f3b51fca3a7a0L, 0xf75a15862ca504c5L,
            0x82ef85133de648c4L, 0x9a984d73dbe722fbL,
            0xa3ab66580d5fdaf5L, 0xc13e60d0d2e0ebbaL,
            0xcc963fee10b7d1b3L, 0x318df905079926a8L,
            0xffbbcfe994e5c61fL, 0xfdf17746497f7052L,
            0x9fd561f1fd0f9bd3L, 0xfeb6ea8bedefa633L,
            0xc7caba6e7c5382c8L, 0xfe64a52ee96b8fc0L,
            0xf9bd690a1b68637bL, 0x3dfdce7aa3c673b0L,
            0x9c1661a651213e2dL, 0x6bea10ca65c084eL,
            0xc31bfa0fe5698db8L, 0x486e494fcff30a62L,
            0xf3e2f893dec3f126L, 0x5a89dba3c3efccfaL,
            0x986ddb5c6b3a76b7L, 0xf89629465a75e01cL,
            0xbe89523386091465L, 0xf6bbb397f1135823L,
            0xee2ba6c0678b597fL, 0x746aa07ded582e2cL,
            0x94db483840b717efL, 0xa8c2a44eb4571cdcL,
            0xba121a4650e4ddebL, 0x92f34d62616ce413L,
            0xe896a0d7e51e1566L, 0x77b020baf9c81d17L,
            0x915e2486ef32cd60L, 0xace1474dc1d122eL,
            0xb5b5ada8aaff80b8L, 0xd819992132456baL,
            0xe3231912d5bf60e6L, 0x10e1fff697ed6c69L,
            0x8df5efabc5979c8fL, 0xca8d3ffa1ef463c1L,
            0xb1736b96b6fd83b3L, 0xbd308ff8a6b17cb2L,
            0xddd0467c64bce4a0L, 0xac7cb3f6d05ddbdeL,
            0x8aa22c0dbef60ee4L, 0x6bcdf07a423aa96bL,
            0xad4ab7112eb3929dL, 0x86c16c98d2c953c6L,
            0xd89d64d57a607744L, 0xe871c7bf077ba8b7L,
            0x87625f056c7c4a8bL, 0x11471cd764ad4972L,
            0xa93af6c6c79b5d2dL, 0xd598e40d3dd89bcfL,
            0xd389b47879823479L, 0x4aff1d108d4ec2c3L,
            0x843610cb4bf160cbL, 0xcedf722a585139baL,
            0xa54394fe1eedb8feL, 0xc2974eb4ee658828L,
            0xce947a3da6a9273eL, 0x733d226229feea32L,
            0x811ccc668829b887L, 0x806357d5a3f525fL,
            0xa163ff802a3426a8L, 0xca07c2dcb0cf26f7L,
            0xc9bcff6034c13052L, 0xfc89b393dd02f0b5L,
            0xfc2c3f3841f17c67L, 0xbbac2078d443ace2L,
            0x9d9ba7832936edc0L, 0xd54b944b84aa4c0dL,
            0xc5029163f384a931L, 0xa9e795e65d4df11L,
            0xf64335bcf065d37dL, 0x4d4617b5ff4a16d5L,
            0x99ea0196163fa42eL, 0x504bced1bf8e4e45L,
            0xc06481fb9bcf8d39L, 0xe45ec2862f71e1d6L,
            0xf07da27a82c37088L, 0x5d767327bb4e5a4cL,
            0x964e858c91ba2655L, 0x3a6a07f8d510f86fL,
            0xbbe226efb628afeaL, 0x890489f70a55368bL,
            0xeadab0aba3b2dbe5L, 0x2b45ac74ccea842eL,
            0x92c8ae6b464fc96fL, 0x3b0b8bc90012929dL,
            0xb77ada0617e3bbcbL, 0x9ce6ebb40173744L,
            0xe55990879ddcaabdL, 0xcc420a6a101d0515L,
            0x8f57fa54c2a9eab6L, 0x9fa946824a12232dL,
            0xb32df8e9f3546564L, 0x47939822dc96abf9L,
            0xdff9772470297ebdL, 0x59787e2b93bc56f7L,
            0x8bfbea76c619ef36L, 0x57eb4edb3c55b65aL,
            0xaefae51477a06b03L, 0xede622920b6b23f1L,
            0xdab99e59958885c4L, 0xe95fab368e45ecedL,
            0x88b402f7fd75539bL, 0x11dbcb0218ebb414L,
            0xaae103b5fcd2a881L, 0xd652bdc29f26a119L,
            0xd59944a37c0752a2L, 0x4be76d3346f0495fL,
            0x857fcae62d8493a5L, 0x6f70a4400c562ddbL,
            0xa6dfbd9fb8e5b88eL, 0xcb4ccd500f6bb952L,
            0xd097ad07a71f26b2L, 0x7e2000a41346a7a7L,
            0x825ecc24c873782fL, 0x8ed400668c0c28c8L,
            0xa2f67f2dfa90563bL, 0x728900802f0f32faL,
            0xcbb41ef979346bcaL, 0x4f2b40a03ad2ffb9L,
            0xfea126b7d78186bcL, 0xe2f610c84987bfa8L,
            0x9f24b832e6b0f436L, 0xdd9ca7d2df4d7c9L,
            0xc6ede63fa05d3143L, 0x91503d1c79720dbbL,
            0xf8a95fcf88747d94L, 0x75a44c6397ce912aL,
            0x9b69dbe1b548ce7cL, 0xc986afbe3ee11abaL,
            0xc24452da229b021bL, 0xfbe85badce996168L,
            0xf2d56790ab41c2a2L, 0xfae27299423fb9c3L,
            0x97c560ba6b0919a5L, 0xdccd879fc967d41aL,
            0xbdb6b8e905cb600fL, 0x5400e987bbc1c920L,
            0xed246723473e3813L, 0x290123e9aab23b68L,
            0x9436c0760c86e30bL, 0xf9a0b6720aaf6521L,
            0xb94470938fa89bceL, 0xf808e40e8d5b3e69L,
            0xe7958cb87392c2c2L, 0xb60b1d1230b20e04L,
            0x90bd77f3483bb9b9L, 0xb1c6f22b5e6f48c2L,
            0xb4ecd5f01a4aa828L, 0x1e38aeb6360b1af3L,
            0xe2280b6c20dd5232L, 0x25c6da63c38de1b0L,
            0x8d590723948a535fL, 0x579c487e5a38ad0eL,
            0xb0af48ec79ace837L, 0x2d835a9df0c6d851L,
            0xdcdb1b2798182244L, 0xf8e431456cf88e65L,
            0x8a08f0f8bf0f156bL, 0x1b8e9ecb641b58ffL,
            0xac8b2d36eed2dac5L, 0xe272467e3d222f3fL,
            0xd7adf884aa879177L, 0x5b0ed81dcc6abb0fL,
            0x86ccbb52ea94baeaL, 0x98e947129fc2b4e9L,
            0xa87fea27a539e9a5L, 0x3f2398d747b36224L,
            0xd29fe4b18e88640eL, 0x8eec7f0d19a03aadL,
            0x83a3eeeef9153e89L, 0x1953cf68300424acL,
            0xa48ceaaab75a8e2bL, 0x5fa8c3423c052dd7L,
            0xcdb02555653131b6L, 0x3792f412cb06794dL,
            0x808e17555f3ebf11L, 0xe2bbd88bbee40bd0L,
            0xa0b19d2ab70e6ed6L, 0x5b6aceaeae9d0ec4L,
            0xc8de047564d20a8bL, 0xf245825a5a445275L,
            0xfb158592be068d2eL, 0xeed6e2f0f0d56712L,
            0x9ced737bb6c4183dL, 0x55464dd69685606bL,
            0xc428d05aa4751e4cL, 0xaa97e14c3c26b886L,
            0xf53304714d9265dfL, 0xd53dd99f4b3066a8L,
            0x993fe2c6d07b7fabL, 0xe546a8038efe4029L,
            0xbf8fdb78849a5f96L, 0xde98520472bdd033L,
            0xef73d256a5c0f77cL, 0x963e66858f6d4440L,
            0x95a8637627989aadL, 0xdde7001379a44aa8L,
            0xbb127c53b17ec159L, 0x5560c018580d5d52L,
            0xe9d71b689dde71afL, 0xaab8f01e6e10b4a6L,
            0x9226712162ab070dL, 0xcab3961304ca70e8L,
            0xb6b00d69bb55c8d1L, 0x3d607b97c5fd0d22L,
            0xe45c10c42a2b3b05L, 0x8cb89a7db77c506aL,
            0x8eb98a7a9a5b04e3L, 0x77f3608e92adb242L,
            0xb267ed1940f1c61cL, 0x55f038b237591ed3L,
            0xdf01e85f912e37a3L, 0x6b6c46dec52f6688L,
            0x8b61313bbabce2c6L, 0x2323ac4b3b3da015L,
            0xae397d8aa96c1b77L, 0xabec975e0a0d081aL,
            0xd9c7dced53c72255L, 0x96e7bd358c904a21L,
            0x881cea14545c7575L, 0x7e50d64177da2e54L,
            0xaa242499697392d2L, 0xdde50bd1d5d0b9e9L,
            0xd4ad2dbfc3d07787L, 0x955e4ec64b44e864L,
            0x84ec3c97da624ab4L, 0xbd5af13bef0b113eL,
            0xa6274bbdd0fadd61L, 0xecb1ad8aeacdd58eL,
            0xcfb11ead453994baL, 0x67de18eda5814af2L,
            0x81ceb32c4b43fcf4L, 0x80eacf948770ced7L,
            0xa2425ff75e14fc31L, 0xa1258379a94d028dL,
            0xcad2f7f5359a3b3eL, 0x96ee45813a04330L,
            0xfd87b5f28300ca0dL, 0x8bca9d6e188853fcL,
            0x9e74d1b791e07e48L, 0x775ea264cf55347eL,
            0xc612062576589ddaL, 0x95364afe032a81a0L,
            0xf79687aed3eec551L, 0x3a83ddbd83f52210L,
            0x9abe14cd44753b52L, 0xc4926a9672793580L,
            0xc16d9a0095928a27L, 0x75b7053c0f178400L,
            0xf1c90080baf72cb1L, 0x5324c68b12dd6800L,
            0x971da05074da7beeL, 0xd3f6fc16ebca8000L,
            0xbce5086492111aeaL, 0x88f4bb1ca6bd0000L,
            0xec1e4a7db69561a5L, 0x2b31e9e3d0700000L,
            0x9392ee8e921d5d07L, 0x3aff322e62600000L,
            0xb877aa3236a4b449L, 0x9befeb9fad487c3L,
            0xe69594bec44de15bL, 0x4c2ebe687989a9b4L,
            0x901d7cf73ab0acd9L, 0xf9d37014bf60a11L,
            0xb424dc35095cd80fL, 0x538484c19ef38c95L,
            0xe12e13424bb40e13L, 0x2865a5f206b06fbaL,
            0x8cbccc096f5088cbL, 0xf93f87b7442e45d4L,
            0xafebff0bcb24aafeL, 0xf78f69a51539d749L,
            0xdbe6fecebdedd5beL, 0xb573440e5a884d1cL,
            0x89705f4136b4a597L, 0x31680a88f8953031L,
            0xabcc77118461cefcL, 0xfdc20d2b36ba7c3eL,
            0xd6bf94d5e57a42bcL, 0x3d32907604691b4dL,
            0x8637bd05af6c69b5L, 0xa63f9a49c2c1b110L,
            0xa7c5ac471b478423L, 0xfcf80dc33721d54L,
            0xd1b71758e219652bL, 0xd3c36113404ea4a9L,
            0x83126e978d4fdf3bL, 0x645a1cac083126eaL,
            0xa3d70a3d70a3d70aL, 0x3d70a3d70a3d70a4L,
            0xccccccccccccccccL, 0xcccccccccccccccdL,
            0x8000000000000000L, 0x0L,
            0xa000000000000000L, 0x0L,
            0xc800000000000000L, 0x0L,
            0xfa00000000000000L, 0x0L,
            0x9c40000000000000L, 0x0L,
            0xc350000000000000L, 0x0L,
            0xf424000000000000L, 0x0L,
            0x9896800000000000L, 0x0L,
            0xbebc200000000000L, 0x0L,
            0xee6b280000000000L, 0x0L,
            0x9502f90000000000L, 0x0L,
            0xba43b74000000000L, 0x0L,
            0xe8d4a51000000000L, 0x0L,
            0x9184e72a00000000L, 0x0L,
            0xb5e620f480000000L, 0x0L,
            0xe35fa931a0000000L, 0x0L,
            0x8e1bc9bf04000000L, 0x0L,
            0xb1a2bc2ec5000000L, 0x0L,
            0xde0b6b3a76400000L, 0x0L,
            0x8ac7230489e80000L, 0x0L,
            0xad78ebc5ac620000L, 0x0L,
            0xd8d726b7177a8000L, 0x0L,
            0x878678326eac9000L, 0x0L,
            0xa968163f0a57b400L, 0x0L,
            0xd3c21bcecceda100L, 0x0L,
            0x84595161401484a0L, 0x0L,
            0xa56fa5b99019a5c8L, 0x0L,
            0xcecb8f27f4200f3aL, 0x0L,
            0x813f3978f8940984L, 0x4000000000000000L,
            0xa18f07d736b90be5L, 0x5000000000000000L,
            0xc9f2c9cd04674edeL, 0xa400000000000000L,
            0xfc6f7c4045812296L, 0x4d00000000000000L,
            0x9dc5ada82b70b59dL, 0xf020000000000000L,
            0xc5371912364ce305L, 0x6c28000000000000L,
            0xf684df56c3e01bc6L, 0xc732000000000000L,
            0x9a130b963a6c115cL, 0x3c7f400000000000L,
            0xc097ce7bc90715b3L, 0x4b9f100000000000L,
            0xf0bdc21abb48db20L, 0x1e86d40000000000L,
            0x96769950b50d88f4L, 0x1314448000000000L,
            0xbc143fa4e250eb31L, 0x17d955a000000000L,
            0xeb194f8e1ae525fdL, 0x5dcfab0800000000L,
            0x92efd1b8d0cf37beL, 0x5aa1cae500000000L,
            0xb7abc627050305adL, 0xf14a3d9e40000000L,
            0xe596b7b0c643c719L, 0x6d9ccd05d0000000L,
            0x8f7e32ce7bea5c6fL, 0xe4820023a2000000L,
            0xb35dbf821ae4f38bL, 0xdda2802c8a800000L,
            0xe0352f62a19e306eL, 0xd50b2037ad200000L,
            0x8c213d9da502de45L, 0x4526f422cc340000L,
            0xaf298d050e4395d6L, 0x9670b12b7f410000L,
            0xdaf3f04651d47b4cL, 0x3c0cdd765f114000L,
            0x88d8762bf324cd0fL, 0xa5880a69fb6ac800L,
            0xab0e93b6efee0053L, 0x8eea0d047a457a00L,
            0xd5d238a4abe98068L, 0x72a4904598d6d880L,
            0x85a36366eb71f041L, 0x47a6da2b7f864750L,
            0xa70c3c40a64e6c51L, 0x999090b65f67d924L,
            0xd0cf4b50cfe20765L, 0xfff4b4e3f741cf6dL,
            0x82818f1281ed449fL, 0xbff8f10e7a8921a4L,
            0xa321f2d7226895c7L, 0xaff72d52192b6a0dL,
            0xcbea6f8ceb02bb39L, 0x9bf4f8a69f764490L,
            0xfee50b7025c36a08L, 0x2f236d04753d5b4L,
            0x9f4f2726179a2245L, 0x1d762422c946590L,
            0xc722f0ef9d80aad6L, 0x424d3ad2b7b97ef5L,
            0xf8ebad2b84e0d58bL, 0xd2e0898765a7deb2L,
            0x9b934c3b330c8577L, 0x63cc55f49f88eb2fL,
            0xc2781f49ffcfa6d5L, 0x3cbf6b71c76b25fbL,
            0xf316271c7fc3908aL, 0x8bef464e3945ef7aL,
            0x97edd871cfda3a56L, 0x97758bf0e3cbb5acL,
            0xbde94e8e43d0c8ecL, 0x3d52eeed1cbea317L,
            0xed63a231d4c4fb27L, 0x4ca7aaa863ee4bddL,
            0x945e455f24fb1cf8L, 0x8fe8caa93e74ef6aL,
            0xb975d6b6ee39e436L, 0xb3e2fd538e122b44L,
            0xe7d34c64a9c85d44L, 0x60dbbca87196b616L,
            0x90e40fbeea1d3a4aL, 0xbc8955e946fe31cdL,
            0xb51d13aea4a488ddL, 0x6babab6398bdbe41L,
            0xe264589a4dcdab14L, 0xc696963c7eed2dd1L,
            0x8d7eb76070a08aecL, 0xfc1e1de5cf543ca2L,
            0xb0de65388cc8ada8L, 0x3b25a55f43294bcbL,
            0xdd15fe86affad912L, 0x49ef0eb713f39ebeL,
            0x8a2dbf142dfcc7abL, 0x6e3569326c784337L,
            0xacb92ed9397bf996L, 0x49c2c37f07965404L,
            0xd7e77a8f87daf7fbL, 0xdc33745ec97be906L,
            0x86f0ac99b4e8dafdL, 0x69a028bb3ded71a3L,
            0xa8acd7c0222311bcL, 0xc40832ea0d68ce0cL,
            0xd2d80db02aabd62bL, 0xf50a3fa490c30190L,
            0x83c7088e1aab65dbL, 0x792667c6da79e0faL,
            0xa4b8cab1a1563f52L, 0x577001b891185938L,
            0xcde6fd5e09abcf26L, 0xed4c0226b55e6f86L,
            0x80b05e5ac60b6178L, 0x544f8158315b05b4L,
            0xa0dc75f1778e39d6L, 0x696361ae3db1c721L,
            0xc913936dd571c84cL, 0x3bc3a19cd1e38e9L,
            0xfb5878494ace3a5fL, 0x4ab48a04065c723L,
            0x9d174b2dcec0e47bL, 0x62eb0d64283f9c76L,
            0xc45d1df942711d9aL, 0x3ba5d0bd324f8394L,
            0xf5746577930d6500L, 0xca8f44ec7ee36479L,
            0x9968bf6abbe85f20L, 0x7e998b13cf4e1ecbL,
            0xbfc2ef456ae276e8L, 0x9e3fedd8c321a67eL,
            0xefb3ab16c59b14a2L, 0xc5cfe94ef3ea101eL,
            0x95d04aee3b80ece5L, 0xbba1f1d158724a12L,
            0xbb445da9ca61281fL, 0x2a8a6e45ae8edc97L,
            0xea1575143cf97226L, 0xf52d09d71a3293bdL,
            0x924d692ca61be758L, 0x593c2626705f9c56L,
            0xb6e0c377cfa2e12eL, 0x6f8b2fb00c77836cL,
            0xe498f455c38b997aL, 0xb6dfb9c0f956447L,
            0x8edf98b59a373fecL, 0x4724bd4189bd5eacL,
            0xb2977ee300c50fe7L, 0x58edec91ec2cb657L,
            0xdf3d5e9bc0f653e1L, 0x2f2967b66737e3edL,
            0x8b865b215899f46cL, 0xbd79e0d20082ee74L,
            0xae67f1e9aec07187L, 0xecd8590680a3aa11L,
            0xda01ee641a708de9L, 0xe80e6f4820cc9495L,
            0x884134fe908658b2L, 0x3109058d147fdcddL,
            0xaa51823e34a7eedeL, 0xbd4b46f0599fd415L,
            0xd4e5e2cdc1d1ea96L, 0x6c9e18ac7007c91aL,
            0x850fadc09923329eL, 0x3e2cf6bc604ddb0L,
            0xa6539930bf6bff45L, 0x84db8346b786151cL,
            0xcfe87f7cef46ff16L, 0xe612641865679a63L,
            0x81f14fae158c5f6eL, 0x4fcb7e8f3f60c07eL,
            0xa26da3999aef7749L, 0xe3be5e330f38f09dL,
            0xcb090c8001ab551cL, 0x5cadf5bfd3072cc5L,
            0xfdcb4fa002162a63L, 0x73d9732fc7c8f7f6L,
            0x9e9f11c4014dda7eL, 0x2867e7fddcdd9afaL,
            0xc646d63501a1511dL, 0xb281e1fd541501b8L,
            0xf7d88bc24209a565L, 0x1f225a7ca91a4226L,
            0x9ae757596946075fL, 0x3375788de9b06958L,
            0xc1a12d2fc3978937L, 0x52d6b1641c83aeL,
            0xf209787bb47d6b84L, 0xc0678c5dbd23a49aL,
            0x9745eb4d50ce6332L, 0xf840b7ba963646e0L,
            0xbd176620a501fbffL, 0xb650e5a93bc3d898L,
            0xec5d3fa8ce427affL, 0xa3e51f138ab4cebeL,
            0x93ba47c980e98cdfL, 0xc66f336c36b10137L,
            0xb8a8d9bbe123f017L, 0xb80b0047445d4184L,
            0xe6d3102ad96cec1dL, 0xa60dc059157491e5L,
            0x9043ea1ac7e41392L, 0x87c89837ad68db2fL,
            0xb454e4a179dd1877L, 0x29babe4598c311fbL,
            0xe16a1dc9d8545e94L, 0xf4296dd6fef3d67aL,
            0x8ce2529e2734bb1dL, 0x1899e4a65f58660cL,
            0xb01ae745b101e9e4L, 0x5ec05dcff72e7f8fL,
            0xdc21a1171d42645dL, 0x76707543f4fa1f73L,
            0x899504ae72497ebaL, 0x6a06494a791c53a8L,
            0xabfa45da0edbde69L, 0x487db9d17636892L,
            0xd6f8d7509292d603L, 0x45a9d2845d3c42b6L,
            0x865b86925b9bc5c2L, 0xb8a2392ba45a9b2L,
            0xa7f26836f282b732L, 0x8e6cac7768d7141eL,
            0xd1ef0244af2364ffL, 0x3207d795430cd926L,
            0x8335616aed761f1fL, 0x7f44e6bd49e807b8L,
            0xa402b9c5a8d3a6e7L, 0x5f16206c9c6209a6L,
            0xcd036837130890a1L, 0x36dba887c37a8c0fL,
            0x802221226be55a64L, 0xc2494954da2c9789L,
            0xa02aa96b06deb0fdL, 0xf2db9baa10b7bd6cL,
            0xc83553c5c8965d3dL, 0x6f92829494e5acc7L,
            0xfa42a8b73abbf48cL, 0xcb772339ba1f17f9L,
            0x9c69a97284b578d7L, 0xff2a760414536efbL,
            0xc38413cf25e2d70dL, 0xfef5138519684abaL,
            0xf46518c2ef5b8cd1L, 0x7eb258665fc25d69L,
            0x98bf2f79d5993802L, 0xef2f773ffbd97a61L,
            0xbeeefb584aff8603L, 0xaafb550ffacfd8faL,
            0xeeaaba2e5dbf6784L, 0x95ba2a53f983cf38L,
            0x952ab45cfa97a0b2L, 0xdd945a747bf26183L,
            0xba756174393d88dfL, 0x94f971119aeef9e4L,
            0xe912b9d1478ceb17L, 0x7a37cd5601aab85dL,
            0x91abb422ccb812eeL, 0xac62e055c10ab33aL,
            0xb616a12b7fe617aaL, 0x577b986b314d6009L,
            0xe39c49765fdf9d94L, 0xed5a7e85fda0b80bL,
            0x8e41ade9fbebc27dL, 0x14588f13be847307L,
            0xb1d219647ae6b31cL, 0x596eb2d8ae258fc8L,
            0xde469fbd99a05fe3L, 0x6fca5f8ed9aef3bbL,
            0x8aec23d680043beeL, 0x25de7bb9480d5854L,
            0xada72ccc20054ae9L, 0xaf561aa79a10ae6aL,
            0xd910f7ff28069da4L, 0x1b2ba1518094da04L,
            0x87aa9aff79042286L, 0x90fb44d2f05d0842L,
            0xa99541bf57452b28L, 0x353a1607ac744a53L,
            0xd3fa922f2d1675f2L, 0x42889b8997915ce8L,
            0x847c9b5d7c2e09b7L, 0x69956135febada11L,
            0xa59bc234db398c25L, 0x43fab9837e699095L,
            0xcf02b2c21207ef2eL, 0x94f967e45e03f4bbL,
            0x8161afb94b44f57dL, 0x1d1be0eebac278f5L,
            0xa1ba1ba79e1632dcL, 0x6462d92a69731732L,
            0xca28a291859bbf93L, 0x7d7b8f7503cfdcfeL,
            0xfcb2cb35e702af78L, 0x5cda735244c3d43eL,
            0x9defbf01b061adabL, 0x3a0888136afa64a7L,
            0xc56baec21c7a1916L, 0x88aaa1845b8fdd0L,
            0xf6c69a72a3989f5bL, 0x8aad549e57273d45L,
            0x9a3c2087a63f6399L, 0x36ac54e2f678864bL,
            0xc0cb28a98fcf3c7fL, 0x84576a1bb416a7ddL,
            0xf0fdf2d3f3c30b9fL, 0x656d44a2a11c51d5L,
            0x969eb7c47859e743L, 0x9f644ae5a4b1b325L,
            0xbc4665b596706114L, 0x873d5d9f0dde1feeL,
            0xeb57ff22fc0c7959L, 0xa90cb506d155a7eaL,
            0x9316ff75dd87cbd8L, 0x9a7f12442d588f2L,
            0xb7dcbf5354e9beceL, 0xc11ed6d538aeb2fL,
            0xe5d3ef282a242e81L, 0x8f1668c8a86da5faL,
            0x8fa475791a569d10L, 0xf96e017d694487bcL,
            0xb38d92d760ec4455L, 0x37c981dcc395a9acL,
            0xe070f78d3927556aL, 0x85bbe253f47b1417L,
            0x8c469ab843b89562L, 0x93956d7478ccec8eL,
            0xaf58416654a6babbL, 0x387ac8d1970027b2L,
            0xdb2e51bfe9d0696aL, 0x6997b05fcc0319eL,
            0x88fcf317f22241e2L, 0x441fece3bdf81f03L,
            0xab3c2fddeeaad25aL, 0xd527e81cad7626c3L,
            0xd60b3bd56a5586f1L, 0x8a71e223d8d3b074L,
            0x85c7056562757456L, 0xf6872d5667844e49L,
            0xa738c6bebb12d16cL, 0xb428f8ac016561dbL,
            0xd106f86e69d785c7L, 0xe13336d701beba52L,
            0x82a45b450226b39cL, 0xecc0024661173473L,
            0xa34d721642b06084L, 0x27f002d7f95d0190L,
            0xcc20ce9bd35c78a5L, 0x31ec038df7b441f4L,
            0xff290242c83396ceL, 0x7e67047175a15271L,
            0x9f79a169bd203e41L, 0xf0062c6e984d386L,
            0xc75809c42c684dd1L, 0x52c07b78a3e60868L,
            0xf92e0c3537826145L, 0xa7709a56ccdf8a82L,
            0x9bbcc7a142b17ccbL, 0x88a66076400bb691L,
            0xc2abf989935ddbfeL, 0x6acff893d00ea435L,
            0xf356f7ebf83552feL, 0x583f6b8c4124d43L,
            0x98165af37b2153deL, 0xc3727a337a8b704aL,
            0xbe1bf1b059e9a8d6L, 0x744f18c0592e4c5cL,
            0xeda2ee1c7064130cL, 0x1162def06f79df73L,
            0x9485d4d1c63e8be7L, 0x8addcb5645ac2ba8L,
            0xb9a74a0637ce2ee1L, 0x6d953e2bd7173692L,
            0xe8111c87c5c1ba99L, 0xc8fa8db6ccdd0437L,
            0x910ab1d4db9914a0L, 0x1d9c9892400a22a2L,
            0xb54d5e4a127f59c8L, 0x2503beb6d00cab4bL,
            0xe2a0b5dc971f303aL, 0x2e44ae64840fd61dL,
            0x8da471a9de737e24L, 0x5ceaecfed289e5d2L,
            0xb10d8e1456105dadL, 0x7425a83e872c5f47L,
            0xdd50f1996b947518L, 0xd12f124e28f77719L,
            0x8a5296ffe33cc92fL, 0x82bd6b70d99aaa6fL,
            0xace73cbfdc0bfb7bL, 0x636cc64d1001550bL,
            0xd8210befd30efa5aL, 0x3c47f7e05401aa4eL,
            0x8714a775e3e95c78L, 0x65acfaec34810a71L,
            0xa8d9d1535ce3b396L, 0x7f1839a741a14d0dL,
            0xd31045a8341ca07cL, 0x1ede48111209a050L,
            0x83ea2b892091e44dL, 0x934aed0aab460432L,
            0xa4e4b66b68b65d60L, 0xf81da84d5617853fL,
            0xce1de40642e3f4b9L, 0x36251260ab9d668eL,
            0x80d2ae83e9ce78f3L, 0xc1d72b7c6b426019L,
            0xa1075a24e4421730L, 0xb24cf65b8612f81fL,
            0xc94930ae1d529cfcL, 0xdee033f26797b627L,
            0xfb9b7cd9a4a7443cL, 0x169840ef017da3b1L,
            0x9d412e0806e88aa5L, 0x8e1f289560ee864eL,
            0xc491798a08a2ad4eL, 0xf1a6f2bab92a27e2L,
            0xf5b5d7ec8acb58a2L, 0xae10af696774b1dbL,
            0x9991a6f3d6bf1765L, 0xacca6da1e0a8ef29L,
            0xbff610b0cc6edd3fL, 0x17fd090a58d32af3L,
            0xeff394dcff8a948eL, 0xddfc4b4cef07f5b0L,
            0x95f83d0a1fb69cd9L, 0x4abdaf101564f98eL,
            0xbb764c4ca7a4440fL, 0x9d6d1ad41abe37f1L,
            0xea53df5fd18d5513L, 0x84c86189216dc5edL,
            0x92746b9be2f8552cL, 0x32fd3cf5b4e49bb4L,
            0xb7118682dbb66a77L, 0x3fbc8c33221dc2a1L,
            0xe4d5e82392a40515L, 0xfabaf3feaa5334aL,
            0x8f05b1163ba6832dL, 0x29cb4d87f2a7400eL,
            0xb2c71d5bca9023f8L, 0x743e20e9ef511012L,
            0xdf78e4b2bd342cf6L, 0x914da9246b255416L,
            0x8bab8eefb6409c1aL, 0x1ad089b6c2f7548eL,
            0xae9672aba3d0c320L, 0xa184ac2473b529b1L,
            0xda3c0f568cc4f3e8L, 0xc9e5d72d90a2741eL,
            0x8865899617fb1871L, 0x7e2fa67c7a658892L,
            0xaa7eebfb9df9de8dL, 0xddbb901b98feeab7L,
            0xd51ea6fa85785631L, 0x552a74227f3ea565L,
            0x8533285c936b35deL, 0xd53a88958f87275fL,
            0xa67ff273b8460356L, 0x8a892abaf368f137L,
            0xd01fef10a657842cL, 0x2d2b7569b0432d85L,
            0x8213f56a67f6b29bL, 0x9c3b29620e29fc73L,
            0xa298f2c501f45f42L, 0x8349f3ba91b47b8fL,
            0xcb3f2f7642717713L, 0x241c70a936219a73L,
            0xfe0efb53d30dd4d7L, 0xed238cd383aa0110L,
            0x9ec95d1463e8a506L, 0xf4363804324a40aaL,
            0xc67bb4597ce2ce48L, 0xb143c6053edcd0d5L,
            0xf81aa16fdc1b81daL, 0xdd94b7868e94050aL,
            0x9b10a4e5e9913128L, 0xca7cf2b4191c8326L,
            0xc1d4ce1f63f57d72L, 0xfd1c2f611f63a3f0L,
            0xf24a01a73cf2dccfL, 0xbc633b39673c8cecL,
            0x976e41088617ca01L, 0xd5be0503e085d813L,
            0xbd49d14aa79dbc82L, 0x4b2d8644d8a74e18L,
            0xec9c459d51852ba2L, 0xddf8e7d60ed1219eL,
            0x93e1ab8252f33b45L, 0xcabb90e5c942b503L,
            0xb8da1662e7b00a17L, 0x3d6a751f3b936243L,
            0xe7109bfba19c0c9dL, 0xcc512670a783ad4L,
            0x906a617d450187e2L, 0x27fb2b80668b24c5L,
            0xb484f9dc9641e9daL, 0xb1f9f660802dedf6L,
            0xe1a63853bbd26451L, 0x5e7873f8a0396973L,
            0x8d07e33455637eb2L, 0xdb0b487b6423e1e8L,
            0xb049dc016abc5e5fL, 0x91ce1a9a3d2cda62L,
            0xdc5c5301c56b75f7L, 0x7641a140cc7810fbL,
            0x89b9b3e11b6329baL, 0xa9e904c87fcb0a9dL,
            0xac2820d9623bf429L, 0x546345fa9fbdcd44L,
            0xd732290fbacaf133L, 0xa97c177947ad4095L,
            0x867f59a9d4bed6c0L, 0x49ed8eabcccc485dL,
            0xa81f301449ee8c70L, 0x5c68f256bfff5a74L,
            0xd226fc195c6a2f8cL, 0x73832eec6fff3111L,
            0x83585d8fd9c25db7L, 0xc831fd53c5ff7eabL,
            0xa42e74f3d032f525L, 0xba3e7ca8b77f5e55L,
            0xcd3a1230c43fb26fL, 0x28ce1bd2e55f35ebL,
            0x80444b5e7aa7cf85L, 0x7980d163cf5b81b3L,
            0xa0555e361951c366L, 0xd7e105bcc332621fL,
            0xc86ab5c39fa63440L, 0x8dd9472bf3fefaa7L,
            0xfa856334878fc150L, 0xb14f98f6f0feb951L,
            0x9c935e00d4b9d8d2L, 0x6ed1bf9a569f33d3L,
            0xc3b8358109e84f07L, 0xa862f80ec4700c8L,
            0xf4a642e14c6262c8L, 0xcd27bb612758c0faL,
            0x98e7e9cccfbd7dbdL, 0x8038d51cb897789cL,
            0xbf21e44003acdd2cL, 0xe0470a63e6bd56c3L,
            0xeeea5d5004981478L, 0x1858ccfce06cac74L,
            0x95527a5202df0ccbL, 0xf37801e0c43ebc8L,
            0xbaa718e68396cffdL, 0xd30560258f54e6baL,
            0xe950df20247c83fdL, 0x47c6b82ef32a2069L,
            0x91d28b7416cdd27eL, 0x4cdc331d57fa5441L,
            0xb6472e511c81471dL, 0xe0133fe4adf8e952L,
            0xe3d8f9e563a198e5L, 0x58180fddd97723a6L,
            0x8e679c2f5e44ff8fL, 0x570f09eaa7ea7648L
    };
}
