/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import java.util.Arrays;
import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.VectorSpecies;
import org.simdjson.IntegerUtils;
import org.simdjson.JsonCharUtils;
import org.simdjson.JsonParsingException;
import org.simdjson.JsonValue;
import org.simdjson.NumberParser;
import org.simdjson.Tape;

class TapeBuilder {
    private static final byte SPACE = 32;
    private static final byte BACKSLASH = 92;
    private static final byte QUOTE = 34;
    private static final int BYTES_PROCESSED = 32;
    private static final byte[] ESCAPE_MAP = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 34, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 92, 0, 0, 0, 0, 0, 8, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 13, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final Tape tape;
    private final byte[] stringBuffer;
    private final OpenContainer[] openContainers;
    private final int padding;
    private final NumberParser numberParser;
    private int stringBufferIdx;

    TapeBuilder(int capacity, int depth, int padding) {
        this.tape = new Tape(capacity);
        this.openContainers = new OpenContainer[depth];
        this.padding = padding;
        for (int i = 0; i < this.openContainers.length; ++i) {
            this.openContainers[i] = new OpenContainer();
        }
        this.stringBuffer = new byte[capacity];
        this.numberParser = new NumberParser(this.tape);
    }

    void visitDocumentStart() {
        this.startContainer(0);
    }

    void visitDocumentEnd() {
        this.tape.append(0L, 'r');
        this.tape.write(0, this.tape.getCurrentIdx(), 'r');
    }

    void visitEmptyObject() {
        this.emptyContainer('{', '}');
    }

    void visitEmptyArray() {
        this.emptyContainer('[', ']');
    }

    void visitRootPrimitive(byte[] buffer, int idx, int len) {
        switch (buffer[idx]) {
            case 34: {
                this.visitString(buffer, idx);
                break;
            }
            case 116: {
                this.visitRootTrueAtom(buffer, idx);
                break;
            }
            case 102: {
                this.visitRootFalseAtom(buffer, idx);
                break;
            }
            case 110: {
                this.visitRootNullAtom(buffer, idx);
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.visitRootNumber(buffer, idx, len);
                break;
            }
            default: {
                throw new JsonParsingException("Unrecognized primitive. Expected: string, number, 'true', 'false' or 'null'.");
            }
        }
    }

    void visitPrimitive(byte[] buffer, int idx) {
        switch (buffer[idx]) {
            case 34: {
                this.visitString(buffer, idx);
                break;
            }
            case 116: {
                this.visitTrueAtom(buffer, idx);
                break;
            }
            case 102: {
                this.visitFalseAtom(buffer, idx);
                break;
            }
            case 110: {
                this.visitNullAtom(buffer, idx);
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.visitNumber(buffer, idx);
                break;
            }
            default: {
                throw new JsonParsingException("Unrecognized primitive. Expected: string, number, 'true', 'false' or 'null'.");
            }
        }
    }

    void visitObjectStart(int depth) {
        this.startContainer(depth);
    }

    void incrementCount(int depth) {
        ++this.openContainers[depth].count;
    }

    void visitObjectEnd(int depth) {
        this.endContainer('{', '}', depth);
    }

    void visitArrayStart(int depth) {
        this.startContainer(depth);
    }

    void visitArrayEnd(int depth) {
        this.endContainer('[', ']', depth);
    }

    private void visitTrueAtom(byte[] buffer, int idx) {
        boolean valid;
        boolean bl = valid = this.isTrue(buffer, idx) && JsonCharUtils.isStructuralOrWhitespace(buffer[idx + 4]);
        if (!valid) {
            throw new JsonParsingException("Invalid value starting at " + idx + ". Expected 'true'.");
        }
        this.tape.append(0L, 't');
    }

    private void visitRootTrueAtom(byte[] buffer, int idx) {
        if (!this.isTrue(buffer, idx)) {
            throw new JsonParsingException("Invalid value starting at " + idx + ". Expected 'true'.");
        }
        this.tape.append(0L, 't');
    }

    private boolean isTrue(byte[] buffer, int idx) {
        return buffer[idx] == 116 && buffer[idx + 1] == 114 && buffer[idx + 2] == 117 && buffer[idx + 3] == 101;
    }

    private void visitFalseAtom(byte[] buffer, int idx) {
        boolean valid;
        boolean bl = valid = this.isFalse(buffer, idx) && JsonCharUtils.isStructuralOrWhitespace(buffer[idx + 5]);
        if (!valid) {
            throw new JsonParsingException("Invalid value starting at " + idx + ". Expected 'false'.");
        }
        this.tape.append(0L, 'f');
    }

    private void visitRootFalseAtom(byte[] buffer, int idx) {
        if (!this.isFalse(buffer, idx)) {
            throw new JsonParsingException("Invalid value starting at " + idx + ". Expected 'false'.");
        }
        this.tape.append(0L, 'f');
    }

    private boolean isFalse(byte[] buffer, int idx) {
        return buffer[idx] == 102 && buffer[idx + 1] == 97 && buffer[idx + 2] == 108 && buffer[idx + 3] == 115 && buffer[idx + 4] == 101;
    }

    private void visitNullAtom(byte[] buffer, int idx) {
        boolean valid;
        boolean bl = valid = this.isNull(buffer, idx) && JsonCharUtils.isStructuralOrWhitespace(buffer[idx + 4]);
        if (!valid) {
            throw new JsonParsingException("Invalid value starting at " + idx + ". Expected 'null'.");
        }
        this.tape.append(0L, 'n');
    }

    private void visitRootNullAtom(byte[] buffer, int idx) {
        if (!this.isNull(buffer, idx)) {
            throw new JsonParsingException("Invalid value starting at " + idx + ". Expected 'null'.");
        }
        this.tape.append(0L, 'n');
    }

    private boolean isNull(byte[] buffer, int idx) {
        return buffer[idx] == 110 && buffer[idx + 1] == 117 && buffer[idx + 2] == 108 && buffer[idx + 3] == 108;
    }

    void visitKey(byte[] buffer, int idx) {
        this.visitString(buffer, idx);
    }

    private void visitString(byte[] buffer, int idx) {
        long quoteBits;
        this.tape.append(this.stringBufferIdx, '\"');
        int src = idx + 1;
        int dst = this.stringBufferIdx + 4;
        while (true) {
            ByteVector srcVec = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])buffer, (int)src);
            srcVec.intoArray(this.stringBuffer, dst);
            long backslashBits = srcVec.eq((byte)92).toLong();
            quoteBits = srcVec.eq((byte)34).toLong();
            if (this.hasQuoteFirst(backslashBits, quoteBits)) break;
            if (this.hasBackslash(backslashBits, quoteBits)) {
                int backslashDist = Long.numberOfTrailingZeros(backslashBits);
                byte escapeChar = buffer[src + backslashDist + 1];
                if (escapeChar == 117) {
                    throw new UnsupportedOperationException("Support for unicode characters is not implemented yet.");
                }
                this.stringBuffer[dst + backslashDist] = this.escape(escapeChar);
                src += backslashDist + 2;
                dst += backslashDist + 1;
                continue;
            }
            src += 32;
            dst += 32;
        }
        int len = (dst += Long.numberOfTrailingZeros(quoteBits)) - this.stringBufferIdx - 4;
        IntegerUtils.toBytes(len, this.stringBuffer, this.stringBufferIdx);
        this.stringBufferIdx = dst;
    }

    private byte escape(byte escapeChar) {
        if (escapeChar < 0) {
            throw new JsonParsingException("Escaped unexpected character: " + (char)escapeChar);
        }
        byte escapeResult = ESCAPE_MAP[escapeChar];
        if (escapeResult == 0) {
            throw new JsonParsingException("Escaped unexpected character: " + (char)escapeChar);
        }
        return escapeResult;
    }

    private boolean hasQuoteFirst(long backslashBits, long quoteBits) {
        return (backslashBits - 1L & quoteBits) != 0L;
    }

    private boolean hasBackslash(long backslashBits, long quoteBits) {
        return (quoteBits - 1L & backslashBits) != 0L;
    }

    private void visitNumber(byte[] buffer, int idx) {
        this.numberParser.parseNumber(buffer, idx);
    }

    private void visitRootNumber(byte[] buffer, int idx, int len) {
        int remainingLen = len - idx;
        byte[] copy = new byte[remainingLen + this.padding];
        System.arraycopy(buffer, idx, copy, 0, remainingLen);
        Arrays.fill(copy, remainingLen, remainingLen + this.padding, (byte)32);
        this.numberParser.parseNumber(copy, 0);
    }

    private void startContainer(int depth) {
        this.openContainers[depth].tapeIndex = this.tape.getCurrentIdx();
        this.openContainers[depth].count = 0;
        this.tape.skip();
    }

    private void endContainer(char start, char end, int depth) {
        int startTapeIndex = this.openContainers[depth].tapeIndex;
        this.tape.append(startTapeIndex, end);
        int count = this.openContainers[depth].count;
        count = Math.min(count, 0xFFFFFF);
        this.tape.write(startTapeIndex, (long)this.tape.getCurrentIdx() | (long)count << 32, start);
    }

    private void emptyContainer(char start, char end) {
        this.tape.append(this.tape.getCurrentIdx() + 2, start);
        this.tape.append(this.tape.getCurrentIdx(), end);
    }

    void reset() {
        this.tape.reset();
        this.stringBufferIdx = 0;
    }

    JsonValue createJsonValue(byte[] buffer) {
        return new JsonValue(this.tape, 1, this.stringBuffer, buffer);
    }

    private static class OpenContainer {
        int tapeIndex;
        int count;

        private OpenContainer() {
        }
    }
}

