/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;
import org.simdjson.BitIndexes;
import org.simdjson.CharactersClassifier;
import org.simdjson.JsonCharacterBlock;
import org.simdjson.JsonParsingException;
import org.simdjson.JsonStringBlock;
import org.simdjson.JsonStringScanner;

class StructuralIndexer {
    private final JsonStringScanner stringScanner = new JsonStringScanner();
    private final CharactersClassifier classifier = new CharactersClassifier();
    private final BitIndexes bitIndexes;
    private long prevStructurals = 0L;
    private long unescapedCharsError = 0L;
    private long prevScalar = 0L;

    StructuralIndexer(BitIndexes bitIndexes) {
        this.bitIndexes = bitIndexes;
    }

    void step(byte[] buffer, int offset, int blockIndex) {
        ByteVector chunk0 = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])buffer, (int)offset);
        ByteVector chunk1 = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])buffer, (int)(offset + 32));
        JsonStringBlock strings = this.stringScanner.next(chunk0, chunk1);
        JsonCharacterBlock characters = this.classifier.classify(chunk0, chunk1);
        long scalar = characters.scalar();
        long nonQuoteScalar = scalar & (strings.quote() ^ 0xFFFFFFFFFFFFFFFFL);
        long followsNonQuoteScalar = nonQuoteScalar << 1 | this.prevScalar;
        this.prevScalar = nonQuoteScalar >>> 63;
        long unescaped = this.lteq(chunk0, chunk1, (byte)31);
        long potentialScalarStart = scalar & (followsNonQuoteScalar ^ 0xFFFFFFFFFFFFFFFFL);
        long potentialStructuralStart = characters.op() | potentialScalarStart;
        this.bitIndexes.write(blockIndex, this.prevStructurals);
        this.prevStructurals = potentialStructuralStart & (strings.stringTail() ^ 0xFFFFFFFFFFFFFFFFL);
        this.unescapedCharsError |= strings.nonQuoteInsideString(unescaped);
    }

    private long lteq(ByteVector chunk0, ByteVector chunk1, byte scalar) {
        long rLo = chunk0.compare(VectorOperators.UNSIGNED_LE, scalar).toLong();
        long rHi = chunk1.compare(VectorOperators.UNSIGNED_LE, scalar).toLong();
        return rLo | rHi << 32;
    }

    void finish(int blockIndex) {
        this.bitIndexes.write(blockIndex, this.prevStructurals);
        this.stringScanner.finish();
        if (this.unescapedCharsError != 0L) {
            throw new JsonParsingException("Unescaped characters. Within strings, there are characters that should be escaped.");
        }
    }

    void reset() {
        this.stringScanner.reset();
        this.prevStructurals = 0L;
        this.unescapedCharsError = 0L;
        this.prevScalar = 0L;
    }
}

