/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import org.simdjson.IntegerUtils;
import org.simdjson.Tape;

public class JsonValue {
    private final Tape tape;
    private final byte[] buffer;
    private final int tapeIdx;
    private final byte[] stringBuffer;

    JsonValue(Tape tape, int tapeIdx, byte[] stringBuffer, byte[] buffer) {
        this.tape = tape;
        this.tapeIdx = tapeIdx;
        this.stringBuffer = stringBuffer;
        this.buffer = buffer;
    }

    public boolean isArray() {
        return this.tape.getType(this.tapeIdx) == '[';
    }

    public boolean isObject() {
        return this.tape.getType(this.tapeIdx) == '{';
    }

    public boolean isLong() {
        return this.tape.getType(this.tapeIdx) == 'l';
    }

    public boolean isDouble() {
        return this.tape.getType(this.tapeIdx) == 'd';
    }

    public boolean isBoolean() {
        char type = this.tape.getType(this.tapeIdx);
        return type == 't' || type == 'f';
    }

    public boolean isNull() {
        return this.tape.getType(this.tapeIdx) == 'n';
    }

    public boolean isString() {
        return this.tape.getType(this.tapeIdx) == '\"';
    }

    public Iterator<JsonValue> arrayIterator() {
        return new ArrayIterator(this.tapeIdx);
    }

    public Iterator<Map.Entry<CharSequence, JsonValue>> objectIterator() {
        return new ObjectIterator(this.tapeIdx);
    }

    public long asLong() {
        return this.tape.getInt64Value(this.tapeIdx);
    }

    public double asDouble() {
        return this.tape.getDouble(this.tapeIdx);
    }

    public boolean asBoolean() {
        return this.tape.getType(this.tapeIdx) == 't';
    }

    public CharSequence asCharSequence() {
        return this.asCharSequence(this.tapeIdx);
    }

    private CharSequence asCharSequence(int idx) {
        int stringBufferIdx = (int)this.tape.getValue(idx);
        int len = IntegerUtils.toInt(this.stringBuffer, stringBufferIdx);
        return new StringView(stringBufferIdx + 4, len);
    }

    public JsonValue get(String name) {
        Iterator<Map.Entry<CharSequence, JsonValue>> it = this.objectIterator();
        while (it.hasNext()) {
            Map.Entry<CharSequence, JsonValue> entry = it.next();
            CharSequence key = entry.getKey();
            if (CharSequence.compare(key, name) != 0) continue;
            return entry.getValue();
        }
        return null;
    }

    public String asString() {
        return this.asCharSequence().toString();
    }

    public int getSize() {
        return this.tape.getScopeCount(this.tapeIdx);
    }

    public String toString() {
        switch (this.tape.getType(this.tapeIdx)) {
            case 'l': {
                return String.valueOf(this.asLong());
            }
            case 'd': {
                return String.valueOf(this.asDouble());
            }
            case 'f': 
            case 't': {
                return String.valueOf(this.asBoolean());
            }
            case '\"': {
                return this.asCharSequence().toString();
            }
            case 'n': {
                return "null";
            }
            case '{': {
                return "<object>";
            }
            case '[': {
                return "<array>";
            }
        }
        return "unknown";
    }

    private class ArrayIterator
    implements Iterator<JsonValue> {
        private final int endIdx;
        private int idx;

        ArrayIterator(int startIdx) {
            this.idx = startIdx + 1;
            this.endIdx = JsonValue.this.tape.getMatchingBraceIndex(startIdx) - 1;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.endIdx;
        }

        @Override
        public JsonValue next() {
            JsonValue value = new JsonValue(JsonValue.this.tape, this.idx, JsonValue.this.stringBuffer, JsonValue.this.buffer);
            this.idx = JsonValue.this.tape.computeNextIndex(this.idx);
            return value;
        }
    }

    private class ObjectIterator
    implements Iterator<Map.Entry<CharSequence, JsonValue>> {
        private final int endIdx;
        private int idx;

        ObjectIterator(int startIdx) {
            this.idx = startIdx + 1;
            this.endIdx = JsonValue.this.tape.getMatchingBraceIndex(startIdx) - 1;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.endIdx;
        }

        @Override
        public Map.Entry<CharSequence, JsonValue> next() {
            CharSequence key = JsonValue.this.asCharSequence(this.idx);
            this.idx = JsonValue.this.tape.computeNextIndex(this.idx);
            JsonValue value = new JsonValue(JsonValue.this.tape, this.idx, JsonValue.this.stringBuffer, JsonValue.this.buffer);
            this.idx = JsonValue.this.tape.computeNextIndex(this.idx);
            return new ObjectField(key, value);
        }
    }

    private class StringView
    implements CharSequence {
        private final int startIdx;
        private final int len;

        StringView(int startIdx, int len) {
            this.startIdx = startIdx;
            this.len = len;
        }

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public char charAt(int index) {
            return (char)JsonValue.this.stringBuffer[this.startIdx + index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new StringView(this.startIdx + start, this.startIdx + end);
        }

        @Override
        public String toString() {
            return new String(JsonValue.this.stringBuffer, this.startIdx, this.len, StandardCharsets.UTF_8);
        }
    }

    private static class ObjectField
    implements Map.Entry<CharSequence, JsonValue> {
        private final CharSequence key;
        private final JsonValue value;

        ObjectField(CharSequence key, JsonValue value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public JsonValue getValue() {
            return this.value;
        }

        @Override
        public JsonValue setValue(JsonValue value) {
            throw new UnsupportedOperationException("Object fields are immutable");
        }
    }
}

