/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorShuffle;
import jdk.incubator.vector.VectorSpecies;
import org.simdjson.JsonCharacterBlock;

class CharactersClassifier {
    private static final byte LOW_NIBBLE_MASK = 15;
    private static final ByteVector WHITESPACE_TABLE = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])new byte[]{32, 100, 100, 100, 17, 100, 113, 2, 100, 9, 10, 112, 100, 13, 100, 100, 32, 100, 100, 100, 17, 100, 113, 2, 100, 9, 10, 112, 100, 13, 100, 100}, (int)0);
    private static final ByteVector OP_TABLE = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 58, 123, 44, 125, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 58, 123, 44, 125, 0, 0}, (int)0);

    CharactersClassifier() {
    }

    JsonCharacterBlock classify(ByteVector chunk0, ByteVector chunk1) {
        VectorShuffle chunk0Low = this.extractLowNibble(chunk0).toShuffle();
        VectorShuffle chunk1Low = this.extractLowNibble(chunk1).toShuffle();
        long whitespace = this.eq(chunk0, WHITESPACE_TABLE.rearrange(chunk0Low), chunk1, WHITESPACE_TABLE.rearrange(chunk1Low));
        ByteVector curlified0 = this.curlify(chunk0);
        ByteVector curlified1 = this.curlify(chunk1);
        long op = this.eq(curlified0, OP_TABLE.rearrange(chunk0Low), curlified1, OP_TABLE.rearrange(chunk1Low));
        return new JsonCharacterBlock(whitespace, op);
    }

    private ByteVector extractLowNibble(ByteVector vector) {
        return vector.and((byte)15);
    }

    private ByteVector curlify(ByteVector vector) {
        return vector.or((byte)32);
    }

    private long eq(ByteVector chunk0, ByteVector mask0, ByteVector chunk1, ByteVector mask1) {
        long rLo = chunk0.eq((Vector)mask0).toLong();
        long rHi = chunk1.eq((Vector)mask1).toLong();
        return rLo | rHi << 32;
    }
}

