/*
 * Decompiled with CFR 0.152.
 */
package com.inetpsa.seed.plugin.components;

import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;

@Component(role=VersionResolver.class)
public class VersionResolver {
    @Requirement
    private RepositorySystem repositorySystem;

    public String getHighestVersion(MavenProject mavenProject, String groupId, String artifactId, boolean allowSnapshots) {
        VersionRangeResult rangeResult;
        RepositorySystemSession session = mavenProject.getProjectBuildingRequest().getRepositorySession();
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact((Artifact)new DefaultArtifact(groupId, artifactId, null, "[0,)"));
        rangeRequest.setRepositories(mavenProject.getRemoteProjectRepositories());
        try {
            rangeResult = this.repositorySystem.resolveVersionRange(session, rangeRequest);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to resolve version for %s:%s", groupId, artifactId), e);
        }
        Version highestVersion = null;
        for (Version version : rangeResult.getVersions()) {
            if (highestVersion == null) {
                highestVersion = version;
                continue;
            }
            if (!allowSnapshots && version.toString().endsWith("-SNAPSHOT") || version.compareTo((Object)highestVersion) <= 0) continue;
            highestVersion = version;
        }
        if (highestVersion == null) {
            throw new RuntimeException(String.format("No version found for archetype %s:%s", groupId, artifactId));
        }
        return highestVersion.toString();
    }
}

