/*
 * Decompiled with CFR 0.152.
 */
package com.inetpsa.seed.plugin;

import com.inetpsa.seed.plugin.components.VersionResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="generate-project", requiresProject=false)
public class GenerateProjectMojo
extends AbstractMojo {
    public static List<String> possibleTypes = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add("web");
            this.add("batch");
            this.add("domain");
            this.add("function");
            this.add("rest");
        }
    });
    @Parameter(defaultValue="project", property="project", required=true, readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="session", property="session", required=true, readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager buildPluginManager;
    @Component
    private VersionResolver versionResolver;
    @Component
    private Prompter prompter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean allowSnapshots;
        String type = this.mavenSession.getUserProperties().getProperty("type");
        String version = this.mavenSession.getUserProperties().getProperty("version");
        String archetypeGroupId = this.mavenSession.getUserProperties().getProperty("archetypeGroupId");
        String archetypeArtifactId = this.mavenSession.getUserProperties().getProperty("archetypeArtifactId");
        String archetypeVersion = this.mavenSession.getUserProperties().getProperty("archetypeVersion");
        boolean bl = allowSnapshots = !this.mavenSession.getUserProperties().getProperty("allowSnapshots", "false").equals("false");
        if (StringUtils.isBlank((String)version)) {
            version = "1.0.0-SNAPSHOT";
        }
        if (StringUtils.isBlank((String)archetypeGroupId)) {
            archetypeGroupId = "org.seedstack";
        }
        if (StringUtils.isBlank((String)archetypeArtifactId)) {
            if (StringUtils.isBlank((String)type)) {
                try {
                    String answer = this.prompter.prompt("Enter the project type", possibleTypes);
                    if (answer == null || !possibleTypes.contains(answer)) {
                        return;
                    }
                    type = answer;
                }
                catch (PrompterException e) {
                    throw new MojoExecutionException("Project type is required", (Exception)((Object)e));
                }
            }
            archetypeArtifactId = String.format("%s-archetype", type);
        }
        if (StringUtils.isBlank((String)archetypeVersion)) {
            try {
                archetypeVersion = this.versionResolver.getHighestVersion(this.mavenProject, archetypeGroupId, archetypeArtifactId, allowSnapshots);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to determine latest version of archetype, please specify it manually through the archetypeVersion property", e);
            }
        }
        this.mavenSession.getExecutionProperties().setProperty("version", version);
        String groupId = this.mavenSession.getUserProperties().getProperty("groupId");
        String artifactId = this.mavenSession.getUserProperties().getProperty("artifactId");
        try {
            if (StringUtils.isBlank((String)groupId)) {
                groupId = this.prompter.prompt("Generated project group id");
            }
            if (StringUtils.isBlank((String)artifactId)) {
                artifactId = this.prompter.prompt("Generated project artifact id");
            }
        }
        catch (PrompterException e) {
            throw new MojoExecutionException("Generated project group id and artifact id are required", (Exception)((Object)e));
        }
        this.mavenSession.getExecutionProperties().put("groupId", groupId);
        this.mavenSession.getExecutionProperties().put("artifactId", artifactId);
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-archetype-plugin"), (String)MojoExecutor.version((String)"2.2")), (String)MojoExecutor.goal((String)"generate"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"interactiveMode"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"archetypeGroupId"), (String)archetypeGroupId), MojoExecutor.element((String)MojoExecutor.name((String)"archetypeArtifactId"), (String)archetypeArtifactId), MojoExecutor.element((String)MojoExecutor.name((String)"archetypeVersion"), (String)archetypeVersion)}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.buildPluginManager));
    }
}

