/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools.maven;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;
import org.scalatest.tools.maven.AbstractScalaTestMojo;
import org.scalatest.tools.maven.MojoUtils;

public class TestMojo
extends AbstractScalaTestMojo {
    File reportsDirectory;
    boolean skipTests;
    boolean testFailureIgnore;
    String filereports;
    String htmlreporters;
    String reporters;
    String junitxml;
    String stdout;
    String stderr;
    boolean redirectTestOutputToFile;
    String testOutputFileName;

    public void execute() throws MojoFailureException {
        this.getLog().info((CharSequence)("ScalaTest report directory: " + this.reportsDirectory));
        if (this.skipTests) {
            this.getLog().info((CharSequence)"Tests are skipped.");
        } else if (!this.runScalaTest(this.configuration()) && !this.testFailureIgnore) {
            throw new MojoFailureException("There are test failures");
        }
    }

    String[] configuration() {
        return MojoUtils.concat(this.sharedConfiguration(), this.stdout(), this.stderr(), this.filereports(), this.htmlreporters(), this.reporters(), this.junitxml());
    }

    private List<String> stdout() {
        String stdoutProcessed = this.maybeRemoveAnsiCodes(this.stdout);
        return Collections.unmodifiableList(Collections.singletonList(stdoutProcessed == null ? "-o" : "-o" + stdoutProcessed));
    }

    private List<String> stderr() {
        return this.stderr == null ? Collections.emptyList() : Collections.unmodifiableList(Collections.singletonList("-e" + this.stderr));
    }

    private String maybeRemoveAnsiCodes(String streamParams) {
        return this.redirectTestOutputToFile ? this.maybeAppendLetter(streamParams, "W") : streamParams;
    }

    private String maybeAppendLetter(String string, String letter) {
        if (string == null) {
            return letter;
        }
        if (string.contains(letter)) {
            return string;
        }
        return string + letter;
    }

    private List<String> filereports() {
        return Collections.unmodifiableList(MojoUtils.reporterArg("-f", this.filereports, MojoUtils.fileRelativeTo(this.reportsDirectory)));
    }

    private List<String> htmlreporters() {
        ArrayList<String> r = new ArrayList<String>();
        for (String arg : MojoUtils.splitOnComma(this.htmlreporters)) {
            String[] split = arg.split("\\s+");
            if (split.length <= 0) continue;
            r.add("-h");
            r.add(split[0]);
            if (split.length <= 1) continue;
            r.add("-Y");
            r.add(split[1]);
        }
        return Collections.unmodifiableList(r);
    }

    private List<String> reporters() {
        return MojoUtils.reporterArg("-C", this.reporters, MojoUtils.passThrough);
    }

    private List<String> junitxml() {
        return MojoUtils.reporterArg("-u", this.junitxml, MojoUtils.dirRelativeTo(this.reportsDirectory));
    }

    @Override
    protected Writer getOutputWriter() throws MojoFailureException {
        return this.redirectTestOutputToFile ? this.newFileWriter() : super.getOutputWriter();
    }

    private Writer newFileWriter() throws MojoFailureException {
        File outputFile = new File(this.reportsDirectory, this.testOutputFileName);
        if (!this.reportsDirectory.exists() && !this.reportsDirectory.mkdirs()) {
            throw new MojoFailureException("Unable to create directory path: " + this.reportsDirectory);
        }
        try {
            return new FileWriter(outputFile);
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to access the output file: '" + outputFile + "'", (Throwable)e);
        }
    }
}

