/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

final class MojoUtils {
    static F passThrough = new F(){

        @Override
        public String f(String in) {
            return in;
        }
    };

    private MojoUtils() {
    }

    static F fileRelativeTo(final File relative) {
        return new F(){

            @Override
            public String f(String in) {
                File file = new File(relative, in);
                File parentDir = file.getParentFile();
                MojoUtils.createIfNotExists(parentDir);
                return file.getAbsolutePath();
            }
        };
    }

    static F dirRelativeTo(final File relative) {
        return new F(){

            @Override
            public String f(String in) {
                File dir = new File(relative, in);
                MojoUtils.createIfNotExists(dir);
                return dir.getAbsolutePath();
            }
        };
    }

    private static synchronized void createIfNotExists(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Cannot create directory " + dir);
        }
    }

    static List<String> compoundArg(String name, String ... strings) {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> params = new ArrayList<String>();
        for (String commaSeparated : strings) {
            params.addAll(MojoUtils.splitOnComma(commaSeparated));
        }
        if (params.size() > 0) {
            list.add(name);
            String prefix = "";
            String a = "";
            for (String param : params) {
                a = a + prefix;
                a = a + param;
                prefix = " ";
            }
            list.add(a);
        }
        return Collections.unmodifiableList(list);
    }

    static List<String> suiteArg(String name, String commaSeparated) {
        ArrayList<String> list = new ArrayList<String>();
        for (String param : MojoUtils.splitOnComma(commaSeparated)) {
            list.add(name);
            list.add(param);
        }
        return Collections.unmodifiableList(list);
    }

    static List<String> reporterArg(String name, String commaSeparated, F map) {
        ArrayList<String> r = new ArrayList<String>();
        for (String arg : MojoUtils.splitOnComma(commaSeparated)) {
            String[] split = arg.split("\\s");
            if (split.length == 1) {
                r.add(name);
                r.add(map.f(split[0]));
                continue;
            }
            r.add(name + split[0]);
            r.add(map.f(split[1]));
        }
        return Collections.unmodifiableList(r);
    }

    static List<String> splitOnComma(String cs) {
        String[] split;
        ArrayList<String> args = new ArrayList<String>();
        if (cs == null) {
            return Collections.unmodifiableList(args);
        }
        for (String arg : split = cs.split("(?<!\\\\),")) {
            args.add(arg.trim().replaceAll("\\\\,", ","));
        }
        return Collections.unmodifiableList(args);
    }

    static String[] concat(List<String> ... lists) {
        ArrayList<String> c = new ArrayList<String>();
        for (List<String> l : lists) {
            c.addAll(l);
        }
        return c.toArray(new String[c.size()]);
    }

    private static String getJavaHome() {
        String result = !StringUtils.isEmpty((CharSequence)System.getProperty("java.home")) ? System.getProperty("java.home") : (!StringUtils.isEmpty((CharSequence)System.getenv("JAVA_HOME")) ? System.getenv("JAVA_HOME") : null);
        return result;
    }

    static String getJvm() {
        String jh = MojoUtils.getJavaHome();
        String result = jh == null ? "java" : jh + File.separator + "bin" + File.separator + "java";
        return result;
    }

    static String stripNewLines(String argLine) {
        return argLine.replaceAll("[\r\n]{1,2}", " ");
    }

    static interface F {
        public String f(String var1);
    }
}

