/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.xsbt;

import dotty.tools.dotc.Compiler;
import dotty.tools.dotc.Driver;
import dotty.tools.dotc.ScalacCommand;
import dotty.tools.dotc.config.Properties;
import dotty.tools.dotc.config.ScalaSettings;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.Path;
import dotty.tools.io.PlainFile;
import dotty.tools.io.Streamable;
import dotty.tools.xsbt.DelegatingReporter;
import dotty.tools.xsbt.FallbackPathBasedFile;
import dotty.tools.xsbt.FallbackVirtualFile;
import dotty.tools.xsbt.IncrementalCallback;
import dotty.tools.xsbt.InterfaceCompileFailed;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import scala.collection.mutable.ListBuffer;
import xsbti.AnalysisCallback;
import xsbti.AnalysisCallback2;
import xsbti.Logger;
import xsbti.PathBasedFile;
import xsbti.Problem;
import xsbti.Reporter;
import xsbti.VirtualFile;
import xsbti.compile.Output;

public class CompilerBridgeDriver
extends Driver {
    private final String[] scalacOptions;
    private final String[] args;
    private static final String StopInfoError = "Compiler option supplied that disabled Zinc compilation.";

    public CompilerBridgeDriver(String[] stringArray, Output output) {
        this.scalacOptions = stringArray;
        if (!output.getSingleOutputAsPath().isPresent()) {
            throw new IllegalArgumentException("output should be a SingleOutput, was a " + output.getClass().getName());
        }
        this.args = new String[stringArray.length + 2];
        System.arraycopy(stringArray, 0, this.args, 0, stringArray.length);
        this.args[stringArray.length] = "-d";
        this.args[stringArray.length + 1] = ((java.nio.file.Path)output.getSingleOutputAsPath().get()).toAbsolutePath().toString();
    }

    public boolean sourcesRequired() {
        return false;
    }

    private static VirtualFile asVirtualFile(SourceFile sourceFile, DelegatingReporter delegatingReporter, HashMap<AbstractFile, VirtualFile> hashMap) {
        return hashMap.computeIfAbsent(sourceFile.file(), abstractFile -> {
            CompilerBridgeDriver.reportMissingFile(delegatingReporter, sourceFile);
            if (sourceFile.file().jpath() != null) {
                return new FallbackPathBasedFile(sourceFile);
            }
            return new FallbackVirtualFile(sourceFile);
        });
    }

    private static void reportMissingFile(DelegatingReporter delegatingReporter, SourceFile sourceFile) {
        String string = String.join((CharSequence)"", Collections.nCopies(sourceFile.path().length(), "^"));
        String string2 = sourceFile.path() + ": Missing Zinc virtual file\n" + string + "\n    Falling back to placeholder for the given source file (of class " + sourceFile.getClass().getName() + ")\n    This is likely a bug in incremental compilation for the Scala 3 compiler.\n    Please report it to the Scala 3 maintainers at https://github.com/lampepfl/dotty/issues.";
        delegatingReporter.reportBasicWarning(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run(VirtualFile[] virtualFileArray, AnalysisCallback analysisCallback, Logger logger, Reporter reporter) {
        AbstractFile abstractFile;
        Object object;
        VirtualFile[] virtualFileArray2 = new VirtualFile[virtualFileArray.length];
        System.arraycopy(virtualFileArray, 0, virtualFileArray2, 0, virtualFileArray.length);
        Arrays.sort(virtualFileArray2, (virtualFile, virtualFile2) -> virtualFile.id().compareTo(virtualFile2.id()));
        ListBuffer listBuffer = new ListBuffer();
        HashMap<AbstractFile, VirtualFile> hashMap = new HashMap<AbstractFile, VirtualFile>(virtualFileArray.length, 0.25f);
        for (int i = 0; i < virtualFileArray.length; ++i) {
            object = virtualFileArray2[i];
            abstractFile = CompilerBridgeDriver.asDottyFile(object);
            listBuffer.append((Object)abstractFile);
            hashMap.put(abstractFile, (VirtualFile)object);
        }
        DelegatingReporter delegatingReporter = new DelegatingReporter(reporter, sourceFile -> {
            VirtualFile virtualFile = (VirtualFile)hashMap.get(sourceFile.file());
            if (virtualFile != null) {
                return virtualFile.id();
            }
            return sourceFile.path();
        });
        object = new IncrementalCallback(analysisCallback, sourceFile -> CompilerBridgeDriver.asVirtualFile(sourceFile, delegatingReporter, hashMap));
        try {
            logger.debug(this::infoOnCachedCompiler);
            abstractFile = this.initCtx().fresh().setReporter((dotty.tools.dotc.reporting.Reporter)delegatingReporter).setIncCallback((dotty.tools.dotc.sbt.interfaces.IncrementalCallback)object);
            Contexts.Context context = (Contexts.Context)this.setup(this.args, (Contexts.Context)abstractFile).map(tuple2 -> (Contexts.Context)tuple2._2).getOrElse(() -> CompilerBridgeDriver.lambda$run$5((Contexts.Context)abstractFile));
            if (ScalacCommand.isHelpFlag((ScalaSettings)context.settings(), (Settings.SettingsState)context.settingsState())) {
                throw new InterfaceCompileFailed(this.args, new Problem[0], StopInfoError);
            }
            if (!reporter.hasErrors()) {
                logger.debug(this::prettyPrintCompilationArguments);
                Compiler compiler = this.newCompiler(context);
                this.doCompile(compiler, listBuffer.toList(), context);
                for (Problem problem : reporter.problems()) {
                    try {
                        AnalysisCallback2 analysisCallback2 = (AnalysisCallback2)analysisCallback;
                        analysisCallback2.problem2(problem.category(), problem.position(), problem.message(), problem.severity(), true, problem.rendered(), problem.diagnosticCode(), problem.diagnosticRelatedInformation(), problem.actions());
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        analysisCallback.problem(problem.category(), problem.position(), problem.message(), problem.severity(), true);
                    }
                }
            } else {
                reporter.printSummary();
            }
            if (reporter.hasErrors()) {
                logger.debug(() -> "Compilation failed");
                throw new InterfaceCompileFailed(this.args, reporter.problems(), "Compilation failed");
            }
        }
        finally {
            delegatingReporter.dropDelegate();
        }
    }

    private static AbstractFile asDottyFile(final VirtualFile virtualFile) {
        if (virtualFile instanceof PathBasedFile) {
            java.nio.file.Path path = ((PathBasedFile)virtualFile).toPath();
            return new PlainFile(new Path(path));
        }
        try {
            return new dotty.tools.io.VirtualFile(virtualFile.name(), virtualFile.id()){
                {
                    super(string, string2);
                    try (OutputStream outputStream = this.output();
                         final InputStream inputStream = virtualFile.input();){
                        Streamable.Bytes bytes = new Streamable.Bytes(){

                            public InputStream inputStream() {
                                return inputStream;
                            }
                        };
                        outputStream.write(bytes.toByteArray());
                    }
                }
            };
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid file " + virtualFile.name(), iOException);
        }
    }

    private String infoOnCachedCompiler() {
        String string = Integer.toHexString(((Object)((Object)this)).hashCode());
        String string2 = Properties.versionString();
        return String.format("[zinc] Running cached compiler %s for Scala Compiler %s", string, string2);
    }

    private String prettyPrintCompilationArguments() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[zinc] The Scala compiler is invoked with:");
        for (String string : this.scalacOptions) {
            stringBuilder.append("\n\t");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static /* synthetic */ Contexts.Context lambda$run$5(Contexts.Context context) {
        return context;
    }
}

