/*
 * Decompiled with CFR 0.152.
 */
package org.rosenvold.spring.convention;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.rosenvold.spring.convention.CandidateEvaluator;
import org.rosenvold.spring.convention.NameToClassResolver;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.BeanDefinitionDefaults;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.AnnotationScopeMetadataResolver;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConventionBeanFactory
extends DefaultListableBeanFactory {
    private final NameToClassResolver nameToClassResolver;
    private final CandidateEvaluator candidateEvaluator;
    private final Map<String, AnnotatedBeanDefinition> beanDefinitionMap = new ConcurrentHashMap<String, AnnotatedBeanDefinition>();
    private final Map<Class, RootBeanDefinition> mergedBeanDefinitions = new ConcurrentHashMap<Class, RootBeanDefinition>();
    private final Map<String, Class> cachedConventionResolutions = new ConcurrentHashMap<String, Class>();
    private final Map<Class, Object> resolvableDependenciesLocalCache = new HashMap<Class, Object>();
    private final Map<Class, String[]> byTypeMappingSingletonsEager = new ConcurrentHashMap<Class, String[]>();
    private final Map<Class, String[]> byTypeMappingNonSingletonsEager = new ConcurrentHashMap<Class, String[]>();
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
    private BeanDefinitionDefaults beanDefinitionDefaults = new BeanDefinitionDefaults();
    private final QualifierAnnotationAutowireCandidateResolver qualifierAnnotationAutowireCandidateResolver = new QualifierAnnotationAutowireCandidateResolver();
    private ScopeMetadataResolver scopeMetadataResolver = new AnnotationScopeMetadataResolver();
    private final String[] nothing = new String[0];
    private final ConcurrentHashMap<Class, String[]> typeCache = new ConcurrentHashMap();

    public ConventionBeanFactory(NameToClassResolver beanClassResolver, CandidateEvaluator candidateEvaluator) {
        this.nameToClassResolver = beanClassResolver;
        this.candidateEvaluator = candidateEvaluator;
    }

    private void clearTypeBasedCaches() {
        this.byTypeMappingSingletonsEager.clear();
        this.byTypeMappingNonSingletonsEager.clear();
    }

    public String[] getBeanNamesForType(Class type, boolean includeNonSingletons, boolean allowEagerInit) {
        if (type == null || !allowEagerInit) {
            return this.getBeanNamesForTypeImpl(type, includeNonSingletons, allowEagerInit);
        }
        Map<Class, String[]> cache = includeNonSingletons ? this.byTypeMappingNonSingletonsEager : this.byTypeMappingSingletonsEager;
        String[] resolvedBeanNames = cache.get(type);
        if (resolvedBeanNames != null) {
            return resolvedBeanNames;
        }
        resolvedBeanNames = this.getBeanNamesForTypeImpl(type, includeNonSingletons, allowEagerInit);
        cache.put(type, resolvedBeanNames);
        return resolvedBeanNames;
    }

    public synchronized String[] getBeanNamesForTypeImpl(Class type, boolean includeNonSingletons, boolean allowEagerInit) {
        Class cacheEntry = this.getCacheEntry(type);
        if (cacheEntry == null) {
            String[] beanNamesForType = super.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
            if (beanNamesForType.length > 0) {
                return beanNamesForType;
            }
            Class aClass = this.resolveImplClass(type.getName());
            if (aClass != null) {
                return new String[]{aClass.getName()};
            }
            return this.nothing;
        }
        if (this.isCacheMiss(cacheEntry)) {
            return this.nothing;
        }
        return new String[]{cacheEntry.getName()};
    }

    public synchronized <T> T getBean(Class<T> requiredType) throws BeansException {
        Class cacheEntry = this.getCacheEntry(requiredType);
        if (cacheEntry == null) {
            if (super.getBeanNamesForType(requiredType).length > 0) {
                return (T)super.getBean(requiredType);
            }
            Class aClass = this.resolveClass(requiredType);
            return (T)this.instantiate(aClass);
        }
        return (T)(this.isCacheMiss(cacheEntry) ? null : this.instantiate(cacheEntry));
    }

    public synchronized Object getBean(String name) throws BeansException {
        this.setupConventionBeanIfMissing(name);
        return super.getBean(name);
    }

    public synchronized <T> T getBean(String name, Class<T> tClass) throws BeansException {
        this.setupConventionBeanIfMissing(name);
        return (T)super.getBean(name, tClass);
    }

    private synchronized void registerByDirectNameToClassMapping(String name) {
        Class<?> type = this.getResolvedType(name);
        this.registerBeanByResolvedType(name, type);
    }

    public synchronized Object getBean(String name, Object ... objects) throws BeansException {
        this.setupConventionBeanIfMissing(name);
        return super.getBean(name, objects);
    }

    public synchronized boolean containsBean(String name) {
        this.setupConventionBeanIfMissing(name);
        return super.containsBean(name);
    }

    public synchronized boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        this.setupConventionBeanIfMissing(name);
        return super.isSingleton(name);
    }

    public synchronized boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        this.setupConventionBeanIfMissing(name);
        return super.isPrototype(name);
    }

    private synchronized String getAnnotatedScope(Class<?> type) {
        Scope annotation;
        if (type != null && (annotation = type.getAnnotation(Scope.class)) != null) {
            return annotation.value();
        }
        return "";
    }

    public synchronized boolean isTypeMatch(String name, Class aClass) throws NoSuchBeanDefinitionException {
        this.setupConventionBeanIfMissing(name);
        return super.isTypeMatch(name, aClass);
    }

    public synchronized Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return super.getType(name);
    }

    public synchronized String[] getAliases(String name) {
        this.setupConventionBeanIfMissing(name);
        return super.getAliases(name);
    }

    public synchronized boolean containsBeanDefinition(String beanName) {
        return super.containsBeanDefinition(beanName);
    }

    protected synchronized RootBeanDefinition getMergedLocalBeanDefinition(String beanName) throws BeansException {
        if (super.containsBeanDefinition(beanName)) {
            return super.getMergedLocalBeanDefinition(beanName);
        }
        Class<?> type = this.getResolvedType(beanName);
        if (type != null) {
            RootBeanDefinition rootBeanDefinition = this.mergedBeanDefinitions.get(type);
            if (rootBeanDefinition == null) {
                rootBeanDefinition = new RootBeanDefinition(type);
                rootBeanDefinition.overrideFrom(this.getBeanDefinition(beanName));
                rootBeanDefinition.setAutowireMode(2);
                rootBeanDefinition.setScope(this.getAnnotatedScope(type));
                this.mergedBeanDefinitions.put(type, rootBeanDefinition);
            }
            return rootBeanDefinition;
        }
        return null;
    }

    public synchronized BeanDefinition getBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        if (super.containsBeanDefinition(beanName)) {
            return super.getBeanDefinition(beanName);
        }
        Class<?> resolvedType = this.getResolvedType(beanName);
        return this.getOrCreateBeanDefinition(beanName, resolvedType);
    }

    protected Class predictBeanType(String beanName, RootBeanDefinition mbd, Class ... typesToMatch) {
        Class<?> resolvedType = this.getResolvedType(beanName);
        if (resolvedType != null) {
            return resolvedType;
        }
        return super.predictBeanType(beanName, mbd, typesToMatch);
    }

    private void setupConventionBeanIfMissing(String name) {
        if (!super.containsBeanDefinition(name)) {
            this.registerByDirectNameToClassMapping(name);
        }
    }

    private Class<?> getResolvedType(String s) throws NoSuchBeanDefinitionException {
        Class aClass = this.resolveImplClass(s);
        return aClass != null && this.candidateEvaluator.isBean(aClass) ? aClass : null;
    }

    private Class resolveImplClass(String beanName) {
        Class aClass = this.cachedConventionResolutions.get(beanName);
        if (aClass != null && !CacheMiss.class.equals((Object)aClass)) {
            return aClass;
        }
        aClass = this.nameToClassResolver.resolveBean(beanName, this.candidateEvaluator);
        this.cachedConventionResolutions.put(beanName, aClass != null ? aClass : CacheMiss.class);
        return aClass;
    }

    private Class getCacheEntry(Class key) {
        return this.cachedConventionResolutions.get(this.beanNameFromClass(key));
    }

    private boolean isCacheMiss(Class cacheResult) {
        return CacheMiss.class.equals((Object)cacheResult);
    }

    private Class resolveClass(Class beanClass) {
        return this.resolveImplClass(this.beanNameFromClass(beanClass));
    }

    private String beanNameFromClass(Class beanClass) {
        return beanClass.getName();
    }

    private Object instantiate(Class aClass) throws BeansException {
        return this.doGetBean(aClass.getName(), null, null, false);
    }

    private AnnotatedBeanDefinition getOrCreateBeanDefinition(String beanName, Class<?> resolvedType) {
        AnnotatedBeanDefinition beanDefinition = this.beanDefinitionMap.get(beanName);
        if (beanDefinition == null) {
            beanDefinition = this.createScannedBeanDefinition(resolvedType);
            this.beanDefinitionMap.put(beanName, beanDefinition);
        }
        return beanDefinition;
    }

    private ScannedGenericBeanDefinition createScannedBeanDefinition(Class<?> resolvedType) {
        ScannedGenericBeanDefinition rootBeanDefinition = this.getScannedBeanDefinition(resolvedType);
        rootBeanDefinition.applyDefaults(this.beanDefinitionDefaults);
        ConventionBeanFactory.processCommonDefinitionAnnotations((AnnotatedBeanDefinition)rootBeanDefinition);
        rootBeanDefinition.setScope(this.getAnnotatedScope(resolvedType));
        return rootBeanDefinition;
    }

    private ScannedGenericBeanDefinition getScannedBeanDefinition(Class clazz) {
        try {
            MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(clazz.getName());
            return new ScannedGenericBeanDefinition(metadataReader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void registerBeanByResolvedType(String beanName, Class<?> resolvedType) {
        if (resolvedType == null) {
            return;
        }
        AnnotatedBeanDefinition beanDefinition = this.getOrCreateBeanDefinition(beanName, resolvedType);
        BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, beanName);
        ScopeMetadata scopeMetadata = this.scopeMetadataResolver.resolveScopeMetadata((BeanDefinition)beanDefinition);
        ScopedProxyMode scopedProxyMode = scopeMetadata.getScopedProxyMode();
        if (!scopedProxyMode.equals((Object)ScopedProxyMode.NO)) {
            definitionHolder = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)this, (boolean)scopedProxyMode.equals((Object)ScopedProxyMode.TARGET_CLASS));
        }
        this.registerBeanDefinition(beanName, definitionHolder.getBeanDefinition());
    }

    static void processCommonDefinitionAnnotations(AnnotatedBeanDefinition abd) {
        String[] value;
        if (abd.getMetadata().isAnnotated(Primary.class.getName())) {
            abd.setPrimary(true);
        }
        if (abd.getMetadata().isAnnotated(Lazy.class.getName())) {
            value = (String[])abd.getMetadata().getAnnotationAttributes(Lazy.class.getName()).get("value");
            abd.setLazyInit(value.booleanValue());
        }
        if (abd.getMetadata().isAnnotated(DependsOn.class.getName())) {
            value = (String[])abd.getMetadata().getAnnotationAttributes(DependsOn.class.getName()).get("value");
            abd.setDependsOn(value);
        }
    }

    public AutowireCandidateResolver getAutowireCandidateResolver() {
        return this.qualifierAnnotationAutowireCandidateResolver;
    }

    protected Map<String, Object> findAutowireCandidates(String beanName, Class requiredType, DependencyDescriptor descriptor) {
        String[] candidateNames = this.getCandidateNames(requiredType, descriptor);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(candidateNames.length);
        for (Class autowiringType : this.resolvableDependenciesLocalCache.keySet()) {
            if (!autowiringType.isAssignableFrom(requiredType)) continue;
            Object autowiringValue = this.resolvableDependenciesLocalCache.get(autowiringType);
            if (!requiredType.isInstance(autowiringValue = ConventionBeanFactory.resolveAutowiringValue(autowiringValue, requiredType))) continue;
            result.put(ObjectUtils.identityToString((Object)autowiringValue), autowiringValue);
            break;
        }
        for (String candidateName : candidateNames) {
            if (candidateName.equals(beanName) || !this.isAutowireCandidate(candidateName, descriptor)) continue;
            result.put(candidateName, this.getBean(candidateName));
        }
        return result;
    }

    public void registerResolvableDependency(Class dependencyType, Object autowiredValue) {
        Assert.notNull((Object)dependencyType, (String)"Type must not be null");
        this.resolvableDependenciesLocalCache.put(dependencyType, autowiredValue);
        super.registerResolvableDependency(dependencyType, autowiredValue);
    }

    private String[] getCandidateNames(Class requiredType, DependencyDescriptor descriptor) {
        String[] strings = this.typeCache.get(requiredType);
        if (strings != null) {
            return strings;
        }
        strings = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this, (Class)requiredType, (boolean)true, (boolean)descriptor.isEager());
        this.typeCache.put(requiredType, strings);
        return strings;
    }

    public static Object resolveAutowiringValue(Object autowiringValue, Class requiredType) {
        if (autowiringValue instanceof ObjectFactory && !requiredType.isInstance(autowiringValue)) {
            ObjectFactory factory = (ObjectFactory)autowiringValue;
            if (autowiringValue instanceof Serializable && requiredType.isInterface()) {
                autowiringValue = Proxy.newProxyInstance(requiredType.getClassLoader(), new Class[]{requiredType}, (InvocationHandler)new ObjectFactoryDelegatingInvocationHandler(factory));
            } else {
                return factory.getObject();
            }
        }
        return autowiringValue;
    }

    protected void resetBeanDefinition(String beanName) {
        this.clearTypeBasedCaches();
        super.resetBeanDefinition(beanName);
    }

    private static class ObjectFactoryDelegatingInvocationHandler
    implements InvocationHandler,
    Serializable {
        private final ObjectFactory objectFactory;

        public ObjectFactoryDelegatingInvocationHandler(ObjectFactory objectFactory) {
            this.objectFactory = objectFactory;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                return proxy == args[0];
            }
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (methodName.equals("toString")) {
                return this.objectFactory.toString();
            }
            try {
                return method.invoke(this.objectFactory.getObject(), args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private static class CacheMiss {
        private CacheMiss() {
        }
    }
}

