/*
 * Decompiled with CFR 0.152.
 */
package org.rosenvold.spring.convention;

import org.rosenvold.spring.convention.CandidateEvaluator;
import org.rosenvold.spring.convention.ConventionBeanFactory;
import org.rosenvold.spring.convention.ConventionConfiguration;
import org.rosenvold.spring.convention.NameToClassResolver;
import org.rosenvold.spring.convention.beanclassresolvers.DefaultBeanClassResolver;
import org.rosenvold.spring.convention.candidateevaluators.DefaultCandidateEvaluator;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.support.AbstractContextLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConventionContextLoader
extends AbstractContextLoader {
    public Class<? extends CandidateEvaluator> candidateEvaluator = DefaultCandidateEvaluator.class;
    public Class<? extends NameToClassResolver> nameToClassResolver = DefaultBeanClassResolver.class;

    protected String getResourceSuffix() {
        return "-convention";
    }

    protected String[] modifyLocations(Class<?> clazz, String ... locations) {
        ConventionConfiguration annotation = clazz.getAnnotation(ConventionConfiguration.class);
        if (annotation != null) {
            this.candidateEvaluator = annotation.candidateEvaluator();
            this.nameToClassResolver = annotation.nameToClassResolver();
        }
        return locations;
    }

    public final ConfigurableApplicationContext loadContext(String ... locations) throws Exception {
        ConventionBeanFactory conventionBeanFactory = new ConventionBeanFactory(this.createNameToClassResolver(), this.createCandidateEvaluator());
        GenericApplicationContext context = new GenericApplicationContext((DefaultListableBeanFactory)conventionBeanFactory);
        this.prepareContext(context);
        this.customizeBeanFactory(context.getDefaultListableBeanFactory());
        this.createBeanDefinitionReader(context).loadBeanDefinitions(locations);
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)context);
        this.customizeContext(context);
        context.refresh();
        context.registerShutdownHook();
        return context;
    }

    private NameToClassResolver createNameToClassResolver() {
        try {
            return this.nameToClassResolver.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private CandidateEvaluator createCandidateEvaluator() {
        try {
            return this.candidateEvaluator.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected void prepareContext(GenericApplicationContext context) {
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
    }

    protected BeanDefinitionReader createBeanDefinitionReader(GenericApplicationContext context) {
        return new XmlBeanDefinitionReader((BeanDefinitionRegistry)context);
    }

    protected void customizeContext(GenericApplicationContext context) {
    }
}

