/*
 * Decompiled with CFR 0.152.
 */
package org.rosenvold.spring.convention.beanclassresolvers;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.rosenvold.spring.convention.CandidateEvaluator;
import org.rosenvold.spring.convention.InterfaceToImplementationMapper;
import org.rosenvold.spring.convention.NameToClassResolver;

public class GenericNameToClassResolver
implements NameToClassResolver {
    private final InterfaceToImplementationMapper[] mappers;
    Logger logger = Logger.getLogger(GenericNameToClassResolver.class.getName());

    public GenericNameToClassResolver(InterfaceToImplementationMapper ... mappers) {
        this.mappers = mappers;
    }

    public Class resolveBean(String name, CandidateEvaluator candidateEvaluator) {
        Class aClass = this.resolveClass(name);
        if (aClass != null && aClass.isInterface()) {
            int mapperCount = this.mappers.length;
            for (int i = 0; i < mapperCount; ++i) {
                Class prospect;
                String beanClass = this.mappers[i].getBeanClassName(aClass);
                if (beanClass == null || (prospect = this.resolveClass(beanClass)) == null || !candidateEvaluator.isBean(prospect)) continue;
                return prospect;
            }
            this.logger.log(Level.INFO, "No resolution for " + name);
            return null;
        }
        return aClass != null && candidateEvaluator.isBean(aClass) ? aClass : null;
    }

    private Class resolveClass(String beanName) {
        try {
            return Class.forName(beanName);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }
}

