/*
 * Decompiled with CFR 0.152.
 */
package org.rosenvold.spring.convention;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.rosenvold.spring.convention.CandidateEvaluator;
import org.rosenvold.spring.convention.NameToClassResolver;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConventionBeanFactory
extends DefaultListableBeanFactory {
    private final NameToClassResolver nameToClassResolver;
    private final CandidateEvaluator candidateEvaluator;
    private final Map<String, Class> cache = new ConcurrentHashMap<String, Class>();

    public ConventionBeanFactory(NameToClassResolver beanClassResolver, CandidateEvaluator candidateEvaluator) {
        this.nameToClassResolver = beanClassResolver;
        this.candidateEvaluator = candidateEvaluator;
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        if (this.isBeanInBaseClass(requiredType)) {
            return (T)super.getBean(requiredType);
        }
        Class aClass = this.resolveClass(requiredType);
        return (T)this.instantiate(aClass);
    }

    private <T> boolean isBeanInBaseClass(Class<T> requiredType) {
        return super.getBeanNamesForType(requiredType).length > 0;
    }

    public Object getBean(String name) throws BeansException {
        if (super.containsBeanDefinition(name)) {
            return super.getBean(name);
        }
        Class<?> type = this.getLocalType(name);
        return type != null ? this.instantiate(type) : null;
    }

    public <T> T getBean(String name, Class<T> tClass) throws BeansException {
        if (super.containsBeanDefinition(name)) {
            return (T)super.getBean(name, tClass);
        }
        Class<?> type = this.getLocalType(name);
        return (T)(type != null && this.isTypeMatch(name, tClass) ? this.instantiate(type) : null);
    }

    public Object getBean(String name, Object ... objects) throws BeansException {
        if (super.containsBeanDefinition(name)) {
            return super.getBean(name, objects);
        }
        throw new NoSuchBeanDefinitionException("Dont know");
    }

    public boolean containsBean(String name) {
        if (super.containsBeanDefinition(name)) {
            return true;
        }
        Class<?> type = this.getType(name);
        if (type == null) {
            return false;
        }
        Annotation[] annotations = type.getAnnotations();
        return annotations.length > 0;
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        if (super.containsBeanDefinition(name)) {
            return super.isSingleton(name);
        }
        return true;
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        if (super.containsBean(name)) {
            return super.isPrototype(name);
        }
        return false;
    }

    public boolean isTypeMatch(String name, Class aClass) throws NoSuchBeanDefinitionException {
        if (super.containsBeanDefinition(name)) {
            return super.isTypeMatch(name, aClass);
        }
        Class aClass1 = this.resolveImplClass(name);
        return aClass1 != null && aClass.isAssignableFrom(aClass1);
    }

    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        if (super.containsBeanDefinition(name)) {
            return super.getType(name);
        }
        Class aClass = this.resolveImplClass(name);
        if (aClass == null) {
            return null;
        }
        return aClass;
    }

    private Class<?> getLocalType(String s) throws NoSuchBeanDefinitionException {
        Class aClass = this.resolveImplClass(s);
        return aClass != null && this.candidateEvaluator.isBean(aClass) ? aClass : null;
    }

    public String[] getAliases(String name) {
        if (super.containsBean(name)) {
            return super.getAliases(name);
        }
        return new String[0];
    }

    public String[] getBeanNamesForType(Class type, boolean includeNonSingletons, boolean allowEagerInit) {
        String[] beanNamesForType = super.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
        if (beanNamesForType.length > 0) {
            return beanNamesForType;
        }
        Class aClass = this.resolveImplClass(type.getName());
        if (aClass != null) {
            return new String[]{aClass.getName()};
        }
        return new String[0];
    }

    public boolean containsBeanDefinition(String beanName) {
        Class<?> type = this.getLocalType(beanName);
        return type != null;
    }

    private Class resolveImplClass(String beanName) {
        Class aClass = this.cache.get(beanName);
        if (aClass != null && !CacheMiss.class.equals((Object)aClass)) {
            return aClass;
        }
        aClass = this.nameToClassResolver.resolveBean(beanName, this.candidateEvaluator);
        this.cache.put(beanName, aClass != null ? aClass : CacheMiss.class);
        return aClass;
    }

    private Class resolveClass(Class beanClass) {
        return this.resolveImplClass(this.beanNameFromClass(beanClass));
    }

    private String beanNameFromClass(Class beanClass) {
        return beanClass.getName();
    }

    private Object instantiate(Class aClass) throws BeansException {
        return this.doGetBean(aClass.getName(), null, null, false);
    }

    protected RootBeanDefinition getMergedLocalBeanDefinition(String beanName) throws BeansException {
        if (super.containsBeanDefinition(beanName)) {
            return super.getMergedLocalBeanDefinition(beanName);
        }
        Class<?> type = this.getType(beanName);
        if (type != null) {
            RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(type, true);
            rootBeanDefinition.setAutowireMode(2);
            return rootBeanDefinition;
        }
        return null;
    }

    public BeanDefinition getBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        if (super.containsBeanDefinition(beanName)) {
            return super.getBeanDefinition(beanName);
        }
        Class<?> type = this.getType(beanName);
        RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(type, true);
        rootBeanDefinition.setAutowireMode(2);
        return rootBeanDefinition;
    }

    private static class CacheMiss {
        private CacheMiss() {
        }
    }
}

