/*
 * Decompiled with CFR 0.152.
 */
package org.roboquant.jupyter;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.icepear.echarts.Option;
import org.icepear.echarts.Scatter;
import org.icepear.echarts.charts.scatter.ScatterSeries;
import org.icepear.echarts.components.coord.SplitArea;
import org.icepear.echarts.components.coord.cartesian.CategoryAxis;
import org.icepear.echarts.components.coord.cartesian.TimeAxis;
import org.icepear.echarts.components.coord.cartesian.ValueAxis;
import org.icepear.echarts.components.dataZoom.DataZoom;
import org.icepear.echarts.components.toolbox.Toolbox;
import org.icepear.echarts.components.toolbox.ToolboxDataZoomFeature;
import org.icepear.echarts.components.tooltip.Tooltip;
import org.icepear.echarts.components.visualMap.ContinousVisualMap;
import org.icepear.echarts.origin.component.dataZoom.DataZoomOption;
import org.icepear.echarts.origin.component.toolbox.ToolboxOption;
import org.icepear.echarts.origin.component.visualMap.VisualMapOption;
import org.icepear.echarts.origin.coord.SplitAreaOption;
import org.icepear.echarts.origin.coord.cartesian.AxisOption;
import org.icepear.echarts.origin.util.SeriesOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.roboquant.brokers.Trade;
import org.roboquant.common.Asset;
import org.roboquant.common.Currency;
import org.roboquant.jupyter.Chart;
import org.roboquant.jupyter.TradeChartKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002J\"\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00030\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0003H\u0002J \u0010\u0014\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00060\u00150\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/roboquant/jupyter/TradeChart;", "Lorg/roboquant/jupyter/Chart;", "trades", "", "Lorg/roboquant/brokers/Trade;", "aspect", "", "currency", "Lorg/roboquant/common/Currency;", "perAsset", "", "(Ljava/util/List;Ljava/lang/String;Lorg/roboquant/common/Currency;Z)V", "getOption", "Lorg/icepear/echarts/Option;", "getOptionNormal", "getOptionPerAsset", "toSeriesData2", "", "assets", "Lorg/roboquant/common/Asset;", "tradesToSeriesData", "Lkotlin/Triple;", "Ljava/time/Instant;", "Ljava/math/BigDecimal;", "roboquant-jupyter"})
@SourceDebugExtension(value={"SMAP\nTradeChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TradeChart.kt\norg/roboquant/jupyter/TradeChart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,181:1\n1#2:182\n1045#3:183\n1045#3:184\n1549#3:185\n1620#3,3:186\n1045#3:189\n1549#3:190\n1620#3,3:191\n37#4,2:194\n*S KotlinDebug\n*F\n+ 1 TradeChart.kt\norg/roboquant/jupyter/TradeChart\n*L\n84#1:183\n127#1:184\n137#1:185\n137#1:186,3\n137#1:189\n144#1:190\n144#1:191,3\n144#1:194,2\n*E\n"})
public final class TradeChart
extends Chart {
    @NotNull
    private final List<Trade> trades;
    @NotNull
    private final String aspect;
    @Nullable
    private final Currency currency;
    private final boolean perAsset;

    public TradeChart(@NotNull List<Trade> trades, @NotNull String aspect, @Nullable Currency currency, boolean perAsset) {
        Intrinsics.checkNotNullParameter(trades, (String)"trades");
        Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
        this.trades = trades;
        this.aspect = aspect;
        this.currency = currency;
        this.perAsset = perAsset;
        Object[] objectArray = new String[]{"pnl", "fee", "cost", "size"};
        List validAspects = CollectionsKt.listOf((Object[])objectArray);
        if (!validAspects.contains(this.aspect)) {
            boolean bl = false;
            String string = "Unsupported aspect " + this.aspect + ", valid values are " + validAspects;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ TradeChart(List list, String string, Currency currency, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "pnl";
        }
        if ((n & 4) != 0) {
            currency = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(list, string, currency, bl);
    }

    private final List<Triple<Instant, BigDecimal, String>> tradesToSeriesData() {
        if (this.trades.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Currency currency = this.currency;
        if (currency == null) {
            currency = ((Trade)CollectionsKt.first(this.trades)).getAsset().getCurrency();
        }
        Currency curr = currency;
        List d = new ArrayList();
        Iterable $this$sortedBy$iv = this.trades;
        boolean $i$f$sortedBy = false;
        for (Trade trade : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Trade it = (Trade)a;
                boolean bl = false;
                Comparable comparable = it.getTime();
                it = (Trade)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getTime());
            }
        })) {
            BigDecimal value = TradeChartKt.getValue(trade, this.aspect, curr);
            String tooltip = TradeChartKt.getTooltip(trade);
            d.add(new Triple((Object)trade.getTime(), (Object)value, (Object)tooltip));
        }
        return d;
    }

    private final Option getOptionNormal() {
        Object object;
        Object it;
        Object object2;
        List<Triple<Instant, BigDecimal, String>> data = this.tradesToSeriesData();
        Iterator iterator = ((Iterable)data).iterator();
        if (!iterator.hasNext()) {
            object2 = null;
        } else {
            it = (Triple)iterator.next();
            boolean bl = false;
            it = (BigDecimal)it.getSecond();
            while (iterator.hasNext()) {
                Object it2 = (Triple)iterator.next();
                $i$a$-maxOfOrNull-TradeChart$getOptionNormal$max$1 = false;
                if (it.compareTo(it2 = (Comparable)((BigDecimal)it2.getSecond())) >= 0) continue;
                it = it2;
            }
            object2 = it;
        }
        BigDecimal max = (BigDecimal)object2;
        it = ((Iterable)data).iterator();
        if (!it.hasNext()) {
            object = null;
        } else {
            Object it3 = (Triple)it.next();
            boolean bl = false;
            it3 = (BigDecimal)it3.getSecond();
            while (it.hasNext()) {
                Object it4 = (Triple)it.next();
                $i$a$-minOfOrNull-TradeChart$getOptionNormal$min$1 = false;
                if (it3.compareTo(it4 = (Comparable)((BigDecimal)it4.getSecond())) <= 0) continue;
                it3 = it4;
            }
            object = it3;
        }
        BigDecimal min = (BigDecimal)object;
        ScatterSeries series = new ScatterSeries().setData(data).setSymbolSize((Number)10);
        ContinousVisualMap vm = this.getVisualMap(min, max).setDimension((Number)1);
        Tooltip tooltip = new Tooltip().setFormatter(this.javascriptFunction("return p.value[2];"));
        Scatter scatter = new Scatter();
        Object object3 = this.getTitle();
        if (object3 == null) {
            object3 = "Trade " + this.aspect;
        }
        Scatter chart = (Scatter)((Scatter)((Scatter)((Scatter)((Scatter)((Scatter)scatter.setTitle((String)object3)).addXAxis((AxisOption)new TimeAxis())).addYAxis((AxisOption)new ValueAxis().setScale(Boolean.valueOf(true)))).addSeries((SeriesOption)series)).setVisualMap((VisualMapOption)vm)).setTooltip(tooltip);
        Option option = chart.getOption();
        option.setToolbox((ToolboxOption)this.getToolbox(false));
        option.setDataZoom((DataZoomOption)new DataZoom());
        Intrinsics.checkNotNull((Object)option);
        return option;
    }

    private final List<List<Object>> toSeriesData2(List<Asset> assets) {
        if (this.trades.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Currency currency = this.currency;
        if (currency == null) {
            currency = ((Trade)CollectionsKt.first(this.trades)).getAsset().getCurrency();
        }
        Currency curr = currency;
        List d = new ArrayList();
        Iterable $this$sortedBy$iv = this.trades;
        boolean $i$f$sortedBy = false;
        for (Trade trade : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Trade it = (Trade)a;
                boolean bl = false;
                Comparable comparable = it.getTime();
                it = (Trade)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getTime());
            }
        })) {
            BigDecimal value = TradeChartKt.getValue(trade, this.aspect, curr);
            int y = assets.indexOf(trade.getAsset());
            String tooltip = TradeChartKt.getTooltip(trade);
            Object[] objectArray = new Object[]{trade.getTime(), y, value, tooltip};
            d.add(CollectionsKt.listOf((Object[])objectArray));
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    private final Option getOptionPerAsset() {
        Object object;
        Object it;
        Object object2;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = this.trades;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it2;
            Trade trade = (Trade)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getAsset());
        }
        Iterable $this$sortedBy$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$sortedBy = false;
        List assets = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Asset it = (Asset)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getSymbol());
                it = (Asset)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSymbol())));
            }
        });
        List<List<Object>> d = this.toSeriesData2(assets);
        ScatterSeries series = new ScatterSeries().setSymbolSize((Number)10).setData(d);
        Iterable $this$map$iv2 = assets;
        boolean $i$f$map2 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            Asset asset = (Asset)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it3.getSymbol());
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] yAxisData = thisCollection$iv.toArray(new String[0]);
        Tooltip tooltip = new Tooltip().setFormatter(this.javascriptFunction("return p.value[3];"));
        int valueDim = 2;
        Iterator $i$f$mapTo22 = ((Iterable)d).iterator();
        if (!$i$f$mapTo22.hasNext()) {
            object2 = null;
        } else {
            it = (List)$i$f$mapTo22.next();
            boolean bl = false;
            Object e = it.get(valueDim);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type java.math.BigDecimal");
            it = (BigDecimal)e;
            while ($i$f$mapTo22.hasNext()) {
                Object it4 = (List)$i$f$mapTo22.next();
                $i$a$-minOfOrNull-TradeChart$getOptionPerAsset$min$1 = false;
                Object e2 = it4.get(valueDim);
                Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type java.math.BigDecimal");
                it4 = (BigDecimal)e2;
                if (it.compareTo(it4) <= 0) continue;
                it = it4;
            }
            object2 = it;
        }
        BigDecimal min = (BigDecimal)object2;
        it = ((Iterable)d).iterator();
        if (!it.hasNext()) {
            object = null;
        } else {
            Object it5 = (List)it.next();
            boolean bl = false;
            Object e = it5.get(valueDim);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type java.math.BigDecimal");
            it5 = (BigDecimal)e;
            while (it.hasNext()) {
                Object it6 = (List)it.next();
                $i$a$-maxOfOrNull-TradeChart$getOptionPerAsset$max$1 = false;
                Object e3 = it6.get(valueDim);
                Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type java.math.BigDecimal");
                it6 = (BigDecimal)e3;
                if (it5.compareTo(it6) >= 0) continue;
                it5 = it6;
            }
            object = it5;
        }
        BigDecimal max = (BigDecimal)object;
        ContinousVisualMap vm = this.getVisualMap(min, max).setDimension((Number)valueDim);
        Scatter scatter = new Scatter();
        Object object3 = this.getTitle();
        if (object3 == null) {
            object3 = "Trade Chart " + this.aspect;
        }
        Scatter chart = (Scatter)((Scatter)((Scatter)((Scatter)((Scatter)((Scatter)scatter.setTitle((String)object3)).addSeries((SeriesOption)series)).addYAxis((AxisOption)new CategoryAxis().setData(yAxisData).setSplitArea((SplitAreaOption)new SplitArea().setShow(Boolean.valueOf(true))))).addXAxis((AxisOption)new TimeAxis())).setTooltip(tooltip)).setVisualMap((VisualMapOption)vm);
        Option option = chart.getOption();
        Toolbox toolbox = this.getToolbox(false);
        Map feature = toolbox.getFeature();
        Intrinsics.checkNotNull((Object)feature);
        feature.put("dataZoom", new ToolboxDataZoomFeature());
        toolbox.setFeature(feature);
        option.setToolbox((ToolboxOption)toolbox);
        option.setDataZoom((DataZoomOption)new DataZoom());
        Intrinsics.checkNotNull((Object)option);
        return option;
    }

    @Override
    @NotNull
    public Option getOption() {
        return this.perAsset ? this.getOptionPerAsset() : this.getOptionNormal();
    }
}

