/*
 * Decompiled with CFR 0.152.
 */
package org.roboquant.jupyter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.icepear.echarts.Line;
import org.icepear.echarts.Option;
import org.icepear.echarts.charts.line.LineSeries;
import org.icepear.echarts.components.coord.cartesian.TimeAxis;
import org.icepear.echarts.components.coord.cartesian.ValueAxis;
import org.icepear.echarts.components.dataZoom.DataZoom;
import org.icepear.echarts.components.series.LineStyle;
import org.icepear.echarts.origin.component.dataZoom.DataZoomOption;
import org.icepear.echarts.origin.component.toolbox.ToolboxOption;
import org.icepear.echarts.origin.coord.cartesian.AxisOption;
import org.icepear.echarts.origin.util.LineStyleOption;
import org.icepear.echarts.origin.util.SeriesOption;
import org.jetbrains.annotations.NotNull;
import org.roboquant.common.Observation;
import org.roboquant.common.TimeSeries;
import org.roboquant.common.TimeSeriesKt;
import org.roboquant.jupyter.Chart;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB-\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00030\n\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00140\u0013*\u00020\u0003H\u0002R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/roboquant/jupyter/TimeSeriesChart;", "Lorg/roboquant/jupyter/Chart;", "timeSeries", "Lorg/roboquant/common/TimeSeries;", "useTime", "", "fractionDigits", "", "(Lorg/roboquant/common/TimeSeries;ZI)V", "data", "", "", "(Ljava/util/Map;ZI)V", "commonSuffix", "keys", "", "getOption", "Lorg/icepear/echarts/Option;", "toSeriesData", "", "Lkotlin/Pair;", "", "Ljava/math/BigDecimal;", "Companion", "roboquant-jupyter"})
@SourceDebugExtension(value={"SMAP\nTimeSeriesChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeSeriesChart.kt\norg/roboquant/jupyter/TimeSeriesChart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,157:1\n1726#2,3:158\n215#3,2:161\n*S KotlinDebug\n*F\n+ 1 TimeSeriesChart.kt\norg/roboquant/jupyter/TimeSeriesChart\n*L\n103#1:158,3\n122#1:161,2\n*E\n"})
public final class TimeSeriesChart
extends Chart {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, TimeSeries> data;
    private final boolean useTime;
    private final int fractionDigits;

    public TimeSeriesChart(@NotNull Map<String, TimeSeries> data, boolean useTime, int fractionDigits) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.data = data;
        this.useTime = useTime;
        this.fractionDigits = fractionDigits;
    }

    public /* synthetic */ TimeSeriesChart(Map map, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            n = 2;
        }
        this(map, bl, n);
    }

    public TimeSeriesChart(@NotNull TimeSeries timeSeries, boolean useTime, int fractionDigits) {
        Intrinsics.checkNotNullParameter((Object)timeSeries, (String)"timeSeries");
        this(MapsKt.mapOf((Pair)TuplesKt.to((Object)"", (Object)timeSeries)), useTime, fractionDigits);
    }

    public /* synthetic */ TimeSeriesChart(TimeSeries timeSeries, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            n = 2;
        }
        this(timeSeries, bl, n);
    }

    private final String commonSuffix(Set<String> keys) {
        if (keys.isEmpty()) {
            return "";
        }
        String[] stringArray = new String[]{"/"};
        List parts = StringsKt.split$default((CharSequence)((CharSequence)CollectionsKt.first((Iterable)keys)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        for (int i = CollectionsKt.getLastIndex((List)parts); 0 < i; --i) {
            boolean bl;
            String suffix;
            block5: {
                suffix = CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)parts, (int)i), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                Iterable $this$all$iv = keys;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (StringsKt.endsWith$default((String)it, (String)suffix, (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            return "/" + suffix;
        }
        return "";
    }

    @Override
    @NotNull
    public Option getOption() {
        TimeAxis xAxis = this.useTime ? new TimeAxis() : new ValueAxis();
        ValueAxis yAxis = new ValueAxis().setScale(Boolean.valueOf(true));
        Line chart = (Line)((Line)((Line)((Line)new Line().setTitle(this.getTitle())).addXAxis((AxisOption)xAxis)).addYAxis((AxisOption)yAxis)).setTooltip("axis");
        String suffix = this.commonSuffix(this.data.keySet());
        Map<String, TimeSeries> $this$forEach$iv = this.data;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, TimeSeries>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, TimeSeries> element$iv;
            Map.Entry<String, TimeSeries> entry = element$iv = iterator.next();
            boolean bl = false;
            String name = entry.getKey();
            TimeSeries entries = entry.getValue();
            Collection d = this.reduce((Collection)this.toSeriesData(entries));
            LineSeries lineSeries = new LineSeries().setData(d).setShowSymbol(Boolean.valueOf(false)).setName(StringsKt.removeSuffix((String)name, (CharSequence)suffix)).setLineStyle((LineStyleOption)new LineStyle().setWidth((Number)1));
            chart.addSeries((SeriesOption)lineSeries);
        }
        Option option = chart.getOption();
        option.setToolbox((ToolboxOption)Chart.getToolbox$default(this, false, 1, null));
        option.setDataZoom((DataZoomOption)new DataZoom());
        Intrinsics.checkNotNull((Object)option);
        return option;
    }

    private final List<Pair<Long, BigDecimal>> toSeriesData(TimeSeries $this$toSeriesData) {
        List d = new ArrayList();
        Iterator iterator = $this$toSeriesData.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int step = n++;
            Observation entry = (Observation)iterator.next();
            double value = entry.getValue();
            double d2 = value;
            if (!(!Double.isInfinite(d2) && !Double.isNaN(d2))) continue;
            BigDecimal y = new BigDecimal(value).setScale(this.fractionDigits, RoundingMode.HALF_DOWN);
            long x = this.useTime ? entry.getTime().toEpochMilli() : (long)step;
            d.add(new Pair((Object)x, (Object)y));
        }
        return d;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lorg/roboquant/jupyter/TimeSeriesChart$Companion;", "", "()V", "walkForward", "Lorg/roboquant/jupyter/TimeSeriesChart;", "metricsData", "", "", "Lorg/roboquant/common/TimeSeries;", "fractionDigits", "", "monteCarlo", "roboquant-jupyter"})
    @SourceDebugExtension(value={"SMAP\nTimeSeriesChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeSeriesChart.kt\norg/roboquant/jupyter/TimeSeriesChart$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n453#2:158\n403#2:159\n1238#3,4:160\n*S KotlinDebug\n*F\n+ 1 TimeSeriesChart.kt\norg/roboquant/jupyter/TimeSeriesChart$Companion\n*L\n79#1:158\n79#1:159\n79#1:160,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TimeSeriesChart walkForward(@NotNull Map<String, TimeSeries> metricsData, int fractionDigits, int monteCarlo) {
            void $this$mapValuesTo$iv$iv;
            Intrinsics.checkNotNullParameter(metricsData, (String)"metricsData");
            if (!(monteCarlo >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(fractionDigits >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Pair[] $this$mapValues$iv = metricsData;
            boolean $i$f$mapValues = false;
            Pair[] pairArray = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map2 = map;
                boolean bl2 = false;
                TimeSeries timeSeries = ((TimeSeries)it.getValue()).returns();
                map2.put(k, timeSeries);
            }
            TimeSeries d = TimeSeriesKt.flatten$default((Map)destination$iv$iv, (boolean)false, (int)1, null);
            TimeSeries data = null;
            data = d.runningFold(100.0);
            if (monteCarlo == 0) {
                return new TimeSeriesChart(MapsKt.mapOf((Pair)TuplesKt.to((Object)"", (Object)data)), false, 0, 6, null);
            }
            pairArray = new Pair[]{TuplesKt.to((Object)"orginal", (Object)data)};
            Map result = MapsKt.mutableMapOf((Pair[])pairArray);
            int n = 0;
            while (n < monteCarlo) {
                int it = n++;
                boolean bl = false;
                data = d.shuffle().runningFold(100.0);
                result.put("mc-" + it, data);
            }
            return new TimeSeriesChart(result, false, 0, 6, null);
        }

        public static /* synthetic */ TimeSeriesChart walkForward$default(Companion companion, Map map, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 2;
            }
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            return companion.walkForward(map, n, n2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

