/*
 * Decompiled with CFR 0.152.
 */
package org.roboquant.jupyter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.ClosedReceiveChannelException;
import org.icepear.echarts.Option;
import org.icepear.echarts.Treemap;
import org.icepear.echarts.charts.treemap.Breadcrumb;
import org.icepear.echarts.charts.treemap.TreemapSeries;
import org.icepear.echarts.charts.treemap.TreemapSeriesItemStyle;
import org.icepear.echarts.charts.treemap.TreemapSeriesLabel;
import org.icepear.echarts.components.tooltip.Tooltip;
import org.icepear.echarts.components.visualMap.ContinousVisualMap;
import org.icepear.echarts.origin.chart.treemap.BreadcrumbOption;
import org.icepear.echarts.origin.chart.treemap.TreemapSeriesItemStyleOption;
import org.icepear.echarts.origin.chart.treemap.TreemapSeriesLabelOption;
import org.icepear.echarts.origin.component.toolbox.ToolboxOption;
import org.icepear.echarts.origin.component.visualMap.VisualMapOption;
import org.icepear.echarts.origin.util.SeriesOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.roboquant.common.Amount;
import org.roboquant.common.Asset;
import org.roboquant.common.AssetFilter;
import org.roboquant.common.Currency;
import org.roboquant.common.Size;
import org.roboquant.common.Timeframe;
import org.roboquant.feeds.Action;
import org.roboquant.feeds.Event;
import org.roboquant.feeds.EventChannel;
import org.roboquant.feeds.Feed;
import org.roboquant.feeds.PriceAction;
import org.roboquant.jupyter.Chart;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u00110\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/roboquant/jupyter/PerformanceChart;", "Lorg/roboquant/jupyter/Chart;", "feed", "Lorg/roboquant/feeds/Feed;", "timeframe", "Lorg/roboquant/common/Timeframe;", "priceType", "", "compensateVolume", "", "currency", "Lorg/roboquant/common/Currency;", "assetFilter", "Lorg/roboquant/common/AssetFilter;", "(Lorg/roboquant/feeds/Feed;Lorg/roboquant/common/Timeframe;Ljava/lang/String;ZLorg/roboquant/common/Currency;Lorg/roboquant/common/AssetFilter;)V", "fromFeed", "", "", "", "getOption", "Lorg/icepear/echarts/Option;", "AssetReturns", "roboquant-jupyter"})
@SourceDebugExtension(value={"SMAP\nPerformanceChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerformanceChart.kt\norg/roboquant/jupyter/PerformanceChart\n+ 2 Feed.kt\norg/roboquant/feeds/FeedKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,132:1\n78#2,4:133\n105#2:137\n766#3:138\n857#3,2:139\n1855#3:141\n1856#3:149\n372#4,7:142\n125#5:150\n152#5,3:151\n*S KotlinDebug\n*F\n+ 1 PerformanceChart.kt\norg/roboquant/jupyter/PerformanceChart\n*L\n67#1:133,4\n67#1:137\n68#1:138\n68#1:139,2\n73#1:141\n73#1:149\n77#1:142,7\n85#1:150\n85#1:151,3\n*E\n"})
public final class PerformanceChart
extends Chart {
    @NotNull
    private final Feed feed;
    @NotNull
    private final Timeframe timeframe;
    @NotNull
    private final String priceType;
    private final boolean compensateVolume;
    @Nullable
    private final Currency currency;
    @NotNull
    private final AssetFilter assetFilter;

    public PerformanceChart(@NotNull Feed feed, @NotNull Timeframe timeframe, @NotNull String priceType, boolean compensateVolume, @Nullable Currency currency, @NotNull AssetFilter assetFilter) {
        Intrinsics.checkNotNullParameter((Object)feed, (String)"feed");
        Intrinsics.checkNotNullParameter((Object)timeframe, (String)"timeframe");
        Intrinsics.checkNotNullParameter((Object)priceType, (String)"priceType");
        Intrinsics.checkNotNullParameter((Object)assetFilter, (String)"assetFilter");
        this.feed = feed;
        this.timeframe = timeframe;
        this.priceType = priceType;
        this.compensateVolume = compensateVolume;
        this.currency = currency;
        this.assetFilter = assetFilter;
    }

    public /* synthetic */ PerformanceChart(Feed feed, Timeframe timeframe, String string, boolean bl, Currency currency, AssetFilter assetFilter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            timeframe = Timeframe.Companion.getINFINITE();
        }
        if ((n & 4) != 0) {
            string = "DEFAULT";
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            currency = null;
        }
        if ((n & 0x20) != 0) {
            assetFilter = AssetFilter.Companion.all();
        }
        this(feed, timeframe, string, bl, currency, assetFilter);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Map<String, Object>> fromFeed() {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filter_u24default$iv;
        Map result = new LinkedHashMap();
        Feed feed = this.feed;
        Timeframe timeframe$iv = this.timeframe;
        boolean $i$f$filter22 = false;
        List entries = (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<Pair<? extends Instant, ? extends PriceAction>>>, Object>(timeframe$iv, (Feed)$this$filter_u24default$iv, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Timeframe $timeframe;
            final /* synthetic */ Feed $this_filter;
            {
                this.$timeframe = $timeframe;
                this.$this_filter = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        channel = new EventChannel(0, this.$timeframe, 1, null);
                        result = new ArrayList<E>();
                        job = BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$this_filter, channel, null){
                            int label;
                            final /* synthetic */ Feed $this_filter;
                            final /* synthetic */ EventChannel $channel;
                            {
                                this.$this_filter = $receiver;
                                this.$channel = $channel;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        this.label = 1;
                                        v0 = this.$this_filter.play(this.$channel, (Continuation)this);
                                        if (v0 == var2_2) {
                                            var3_3 = var2_2;
                                            return var3_3;
                                        }
                                        ** GOTO lbl14
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl14:
                                        // 2 sources

                                        this.$channel.close();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        try {
                        }
                        catch (ClosedReceiveChannelException var7_8) {
                            channel.close();
                            if (job.isActive() == false) return result;
                            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                            return result;
                        }
                        catch (Throwable var7_9) {
                            channel.close();
                            if (job.isActive() == false) throw var7_9;
                            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                            throw var7_9;
                        }
lbl23:
                        // 2 sources

                        while (true) {
                            this.L$0 = channel;
                            this.L$1 = result;
                            this.L$2 = job;
                            this.label = 1;
                            v0 = channel.receive((Continuation)this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl39
                            break;
                        }
                    }
                    case 1: {
                        job = (Job)this.L$2;
                        result = (List)this.L$1;
                        channel = (EventChannel)this.L$0;
                        {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl39:
                            // 2 sources

                            o = (Event)v0;
                            $this$filterIsInstance$iv = o.getActions();
                            $i$f$filterIsInstance = false;
                            var10_12 = $this$filterIsInstance$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterIsInstanceTo = false;
                            for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                if (!(element$iv$iv /* !! */  instanceof PriceAction)) continue;
                                destination$iv$iv.add(element$iv$iv /* !! */ );
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            $i$f$filter = false;
                            destination$iv$iv = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            element$iv$iv /* !! */  = $this$filterTo$iv$iv.iterator();
                            while (element$iv$iv /* !! */ .hasNext()) {
                                var16_21 = element$iv$iv /* !! */  = element$iv$iv /* !! */ .next();
                                $i$a$-filter-FeedKt$filter$1 = false;
                                (Action)var16_21;
                                destination$iv$iv.add(element$iv$iv /* !! */ );
                            }
                            $this$map$iv = (List)destination$iv$iv;
                            $i$f$map = false;
                            $i$f$filter = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                element$iv$iv /* !! */  = (Action)item$iv$iv;
                                var18_23 = destination$iv$iv;
                                $i$a$-map-FeedKt$filter$2$newResults$1 = false;
                                var18_23.add(new Pair((Object)o.getTime(), (Object)it));
                            }
                            newResults = (List)destination$iv$iv;
                            result.addAll(newResults);
                            ** continue;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<Pair<Instant, PriceAction>>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        Iterable $this$filter$iv = entries;
        boolean $i$f$filter = false;
        Iterable $i$f$filter22 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!this.assetFilter.filter(((PriceAction)it.getSecond()).getAsset(), this.timeframe.getStart())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List finalEntries = (List)destination$iv$iv;
        if (finalEntries.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Currency currency = this.currency;
        if (currency == null) {
            currency = ((PriceAction)((Pair)CollectionsKt.first((List)finalEntries)).getSecond()).getAsset().getCurrency();
        }
        Currency curr = currency;
        Iterable $this$forEach$iv = finalEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Instant time = (Instant)pair.component1();
            PriceAction priceAction = (PriceAction)pair.component2();
            double d = priceAction.getVolume();
            if (!(!Double.isInfinite(d) && !Double.isNaN(d))) continue;
            Asset asset = priceAction.getAsset();
            double price = priceAction.getPrice(this.priceType);
            Map $this$getOrPut$iv = result;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(asset);
            if (value$iv == null) {
                boolean bl2 = false;
                AssetReturns answer$iv = new AssetReturns(price, 0.0, 0.0, 6, null);
                $this$getOrPut$iv.put(asset, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            AssetReturns record = (AssetReturns)object;
            record.setLastPrice(price);
            long tradingSize = this.compensateVolume ? Size.constructor-impl((double)priceAction.getVolume()) : Size.Companion.getONE-vehRhPc();
            Amount tradingValue = asset.value-u_zS35g(tradingSize, price);
            record.setVolume(record.getVolume() + tradingValue.convert(curr, time).getValue());
        }
        Map $this$map$iv = result;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry priceAction = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            BigDecimal bdVolume = new BigDecimal(((AssetReturns)it.getValue()).getVolume()).setScale(0, RoundingMode.HALF_DOWN);
            BigDecimal bdReturns = new BigDecimal(((AssetReturns)it.getValue()).returns()).setScale(2, RoundingMode.HALF_DOWN);
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)"name", (Object)((Asset)it.getKey()).getSymbol());
            Object[] objectArray = new BigDecimal[]{bdVolume, bdReturns};
            pairArray[1] = TuplesKt.to((Object)"value", (Object)CollectionsKt.listOf((Object[])objectArray));
            collection.add(MapsKt.mapOf((Pair[])pairArray));
        }
        return (List)destination$iv$iv2;
    }

    @Override
    @NotNull
    public Option getOption() {
        BigDecimal bigDecimal;
        String[] it;
        String[] stringArray;
        List<Map<String, Object>> data = this.fromFeed();
        Iterator iterator = ((Iterable)data).iterator();
        if (!iterator.hasNext()) {
            stringArray = null;
        } else {
            it = (Map)iterator.next();
            boolean bl = false;
            Object v = it.get("value");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            List x = (List)v;
            Object e = x.get(1);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type java.math.BigDecimal");
            it = (BigDecimal)e;
            while (iterator.hasNext()) {
                Object it2 = (Map)iterator.next();
                $i$a$-maxOfOrNull-PerformanceChart$getOption$max$1 = false;
                Object v2 = it2.get("value");
                Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
                List x2 = (List)v2;
                Object e2 = x2.get(1);
                Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type java.math.BigDecimal");
                it2 = (BigDecimal)e2;
                if (it.compareTo(it2) >= 0) continue;
                it = it2;
            }
            stringArray = it;
        }
        if ((bigDecimal = (BigDecimal)stringArray) == null) {
            bigDecimal = BigDecimal.ONE;
        }
        BigDecimal max = bigDecimal;
        TreemapSeries series = new TreemapSeries().setName("assets").setData(data).setBreadcrumb((BreadcrumbOption)new Breadcrumb().setShow(Boolean.valueOf(false))).setItemStyle((TreemapSeriesItemStyleOption)new TreemapSeriesItemStyle().setBorderColor("rgba(0,0,0,0)")).setLabel((TreemapSeriesLabelOption)new TreemapSeriesLabel().setFormatter("{b}\n{@[1]}%"));
        Tooltip tooltip = new Tooltip().setFormatter(this.javascriptFunction(StringsKt.replace$default((String)"return \n'symbol: '+p.name+\n'<br>trading amount: '+p.value[0].toPrecision(4)+ \n'<br>returns: '+p.value[1]  + '%';", (String)"\n", (String)"", (boolean)false, (int)4, null)));
        Intrinsics.checkNotNull((Object)max);
        BigDecimal bigDecimal2 = max.negate();
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"this.negate()");
        ContinousVisualMap vm = this.getVisualMap(bigDecimal2, max);
        it = new String[]{Chart.Companion.getPositiveColor(), Chart.Companion.getNegativeColor()};
        vm.setColor(it);
        Treemap treemap = (Treemap)new Treemap().addSeries((SeriesOption)series);
        String string = this.getTitle();
        if (string == null) {
            string = "Asset Performance";
        }
        Treemap chart = (Treemap)((Treemap)((Treemap)treemap.setTitle(string)).setTooltip(tooltip)).setVisualMap((VisualMapOption)vm);
        Option option = chart.getOption();
        option.setToolbox((ToolboxOption)this.getBasicToolbox());
        Intrinsics.checkNotNull((Object)option);
        return option;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\b\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/roboquant/jupyter/PerformanceChart$AssetReturns;", "", "initialPrice", "", "lastPrice", "volume", "(DDD)V", "getInitialPrice", "()D", "getLastPrice", "setLastPrice", "(D)V", "getVolume", "setVolume", "returns", "roboquant-jupyter"})
    private static final class AssetReturns {
        private final double initialPrice;
        private double lastPrice;
        private double volume;

        public AssetReturns(double initialPrice, double lastPrice, double volume) {
            this.initialPrice = initialPrice;
            this.lastPrice = lastPrice;
            this.volume = volume;
        }

        public /* synthetic */ AssetReturns(double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                d2 = d;
            }
            if ((n & 4) != 0) {
                d3 = 0.0;
            }
            this(d, d2, d3);
        }

        public final double getInitialPrice() {
            return this.initialPrice;
        }

        public final double getLastPrice() {
            return this.lastPrice;
        }

        public final void setLastPrice(double d) {
            this.lastPrice = d;
        }

        public final double getVolume() {
            return this.volume;
        }

        public final void setVolume(double d) {
            this.volume = d;
        }

        public final double returns() {
            return 100.0 * (this.lastPrice - this.initialPrice) / this.initialPrice;
        }
    }
}

