/*
 * Decompiled with CFR 0.152.
 */
package org.roboquant.jupyter;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.icepear.echarts.Option;
import org.icepear.echarts.Scatter;
import org.icepear.echarts.charts.scatter.ScatterSeries;
import org.icepear.echarts.components.coord.cartesian.TimeAxis;
import org.icepear.echarts.components.coord.cartesian.ValueAxis;
import org.icepear.echarts.components.dataZoom.DataZoom;
import org.icepear.echarts.components.tooltip.Tooltip;
import org.icepear.echarts.components.visualMap.ContinousVisualMap;
import org.icepear.echarts.origin.component.dataZoom.DataZoomOption;
import org.icepear.echarts.origin.component.toolbox.ToolboxOption;
import org.icepear.echarts.origin.component.visualMap.VisualMapOption;
import org.icepear.echarts.origin.coord.cartesian.AxisOption;
import org.icepear.echarts.origin.util.SeriesOption;
import org.jetbrains.annotations.NotNull;
import org.roboquant.common.Size;
import org.roboquant.jupyter.Chart;
import org.roboquant.orders.Order;
import org.roboquant.orders.OrderState;
import org.roboquant.orders.OrderStatus;
import org.roboquant.orders.SingleOrder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000f0\u0003H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/roboquant/jupyter/OrderChart;", "Lorg/roboquant/jupyter/Chart;", "orderStates", "", "Lorg/roboquant/orders/OrderState;", "(Ljava/util/List;)V", "getOption", "Lorg/icepear/echarts/Option;", "getTooltip", "", "order", "Lorg/roboquant/orders/SingleOrder;", "openedAt", "Ljava/time/Instant;", "ordersToSeriesData", "Lkotlin/Triple;", "Ljava/math/BigDecimal;", "roboquant-jupyter"})
@SourceDebugExtension(value={"SMAP\nOrderChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrderChart.kt\norg/roboquant/jupyter/OrderChart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n766#2:103\n857#2,2:104\n1045#2:106\n1#3:107\n*S KotlinDebug\n*F\n+ 1 OrderChart.kt\norg/roboquant/jupyter/OrderChart\n*L\n58#1:103\n58#1:104,2\n60#1:106\n*E\n"})
public final class OrderChart
extends Chart {
    @NotNull
    private final List<OrderState> orderStates;

    public OrderChart(@NotNull List<OrderState> orderStates) {
        Intrinsics.checkNotNullParameter(orderStates, (String)"orderStates");
        this.orderStates = orderStates;
    }

    private final String getTooltip(SingleOrder order, Instant openedAt) {
        SingleOrder $this$getTooltip_u24lambda_u240 = order;
        boolean bl = false;
        return StringsKt.trimMargin$default((String)("\n                |asset: " + $this$getTooltip_u24lambda_u240.getAsset().getSymbol() + "<br>\n                |currency: " + $this$getTooltip_u24lambda_u240.getAsset().getCurrency() + "<br>\n                |placed: " + openedAt + "<br>\n                |size: " + Size.toString-impl((long)order.getSize-vehRhPc()) + "<br> \n                |id: " + $this$getTooltip_u24lambda_u240.getId() + "<br> \n                |type: " + Reflection.getOrCreateKotlinClass(order.getClass()).getSimpleName() + "<br> \n                |tif: " + order.getTif()), null, (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Triple<Instant, BigDecimal, String>> ordersToSeriesData() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.orderStates;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OrderState it = (OrderState)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus() != OrderStatus.INITIAL)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List states = (List)destination$iv$iv;
        List d = new ArrayList();
        Iterable $this$sortedBy$iv = states;
        boolean $i$f$sortedBy = false;
        for (OrderState state : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                OrderState it = (OrderState)a;
                boolean bl = false;
                Comparable comparable = it.getOpenedAt();
                it = (OrderState)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getOpenedAt());
            }
        })) {
            Order order = state.getOrder();
            if (!(order instanceof SingleOrder)) continue;
            BigDecimal value = Size.toBigDecimal-impl((long)((SingleOrder)order).getSize-vehRhPc());
            String tooltip = this.getTooltip((SingleOrder)order, state.getOpenedAt());
            d.add(new Triple((Object)state.getOpenedAt(), (Object)value, (Object)tooltip));
        }
        return d;
    }

    @Override
    @NotNull
    public Option getOption() {
        Comparable comparable;
        Object it;
        Object object;
        List<Triple<Instant, BigDecimal, String>> data = this.ordersToSeriesData();
        ScatterSeries series = new ScatterSeries().setData(data).setSymbolSize((Number)10);
        Tooltip tooltip = new Tooltip().setFormatter(this.javascriptFunction("return p.value[2];"));
        Scatter scatter = new Scatter();
        String string = this.getTitle();
        if (string == null) {
            string = "Order size";
        }
        Scatter chart = (Scatter)((Scatter)((Scatter)((Scatter)((Scatter)scatter.setTitle(string)).addXAxis((AxisOption)new TimeAxis())).addYAxis((AxisOption)new ValueAxis().setScale(Boolean.valueOf(true)))).addSeries((SeriesOption)series)).setTooltip(tooltip);
        Iterator iterator = ((Iterable)data).iterator();
        if (!iterator.hasNext()) {
            object = null;
        } else {
            it = (Triple)iterator.next();
            boolean bl = false;
            it = (BigDecimal)it.getSecond();
            while (iterator.hasNext()) {
                Object it2 = (Triple)iterator.next();
                $i$a$-maxOfOrNull-OrderChart$getOption$max$1 = false;
                if (it.compareTo(it2 = (Comparable)((BigDecimal)it2.getSecond())) >= 0) continue;
                it = it2;
            }
            object = it;
        }
        BigDecimal max = (BigDecimal)object;
        it = ((Iterable)data).iterator();
        if (!it.hasNext()) {
            comparable = null;
        } else {
            Triple it3 = (Triple)it.next();
            boolean bl = false;
            Comparable comparable2 = (BigDecimal)it3.getSecond();
            while (it.hasNext()) {
                Triple it4 = (Triple)it.next();
                $i$a$-minOfOrNull-OrderChart$getOption$min$1 = false;
                Comparable comparable3 = (BigDecimal)it4.getSecond();
                if (comparable2.compareTo(comparable3) <= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        BigDecimal min = (BigDecimal)comparable;
        ContinousVisualMap vm = this.getVisualMap(min, max).setDimension((Number)1);
        chart.setVisualMap((VisualMapOption)vm);
        Option option = chart.getOption();
        option.setToolbox((ToolboxOption)this.getToolbox(false));
        option.setDataZoom((DataZoomOption)new DataZoom());
        Intrinsics.checkNotNull((Object)option);
        return option;
    }
}

