/*
 * Decompiled with CFR 0.152.
 */
package org.roboquant.jupyter;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.roboquant.Roboquant;
import org.roboquant.common.TimeSeries;
import org.roboquant.jupyter.Chart;
import org.roboquant.jupyter.HTMLOutput;
import org.roboquant.jupyter.MetricsReport;
import org.roboquant.jupyter.TimeSeriesChart;
import org.roboquant.loggers.MetricsLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\u00122\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u0012H\u0002J\b\u0010\u001e\u001a\u00020\u0012H\u0002J\u0015\u0010\u001f\u001a\u00020 *\u00020!2\u0006\u0010\"\u001a\u00020\u0012H\u0082\u0002R \u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/roboquant/jupyter/MetricsReport;", "Lorg/roboquant/jupyter/HTMLOutput;", "roboquant", "Lorg/roboquant/Roboquant;", "maxSamples", "", "(Lorg/roboquant/Roboquant;I)V", "charts", "", "Lkotlin/Function0;", "Lorg/roboquant/jupyter/TimeSeriesChart;", "getCharts", "()Ljava/util/List;", "logger", "Lorg/roboquant/loggers/MetricsLogger;", "getLogger", "()Lorg/roboquant/loggers/MetricsLogger;", "asHTML", "", "asHTMLPage", "chartsToHTML", "createCells", "name", "value", "", "getTableCell", "entry", "", "Lorg/roboquant/common/TimeSeries;", "loadStyle", "metricsToHTML", "plusAssign", "", "Ljava/lang/StringBuffer;", "s", "roboquant-jupyter"})
@SourceDebugExtension(value={"SMAP\nMetricsReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsReport.kt\norg/roboquant/jupyter/MetricsReport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1549#2:114\n1620#2,3:115\n1549#2:118\n1620#2,3:119\n*S KotlinDebug\n*F\n+ 1 MetricsReport.kt\norg/roboquant/jupyter/MetricsReport\n*L\n26#1:114\n26#1:115,3\n44#1:118\n44#1:119,3\n*E\n"})
public final class MetricsReport
extends HTMLOutput {
    @NotNull
    private final Roboquant roboquant;

    public MetricsReport(@NotNull Roboquant roboquant, int maxSamples) {
        Intrinsics.checkNotNullParameter((Object)roboquant, (String)"roboquant");
        this.roboquant = roboquant;
        Chart.Companion.setMaxSamples(maxSamples);
    }

    public /* synthetic */ MetricsReport(Roboquant roboquant, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 10000;
        }
        this(roboquant, n);
    }

    private final MetricsLogger getLogger() {
        return this.roboquant.getLogger();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Function0<TimeSeriesChart>> getCharts() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getLogger().getMetricNames();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Function0)new Function0<TimeSeriesChart>(this, (String)it){
                final /* synthetic */ MetricsReport this$0;
                final /* synthetic */ String $it;
                {
                    this.this$0 = $receiver;
                    this.$it = $it;
                    super(0);
                }

                @NotNull
                public final TimeSeriesChart invoke() {
                    return new TimeSeriesChart(MetricsReport.access$getRoboquant$p(this.this$0).getLogger().getMetric(this.$it), false, 0, 6, null);
                }
            });
        }
        return (List)destination$iv$iv;
    }

    private final String createCells(String name, Object value) {
        return "<td>" + name + "</td><td align=right>" + value + "</td>";
    }

    private final String getTableCell(Map.Entry<String, TimeSeries> entry) {
        char[] cArray = new char[]{'.'};
        List splitName = StringsKt.split$default((CharSequence)entry.getKey(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        String name = CollectionsKt.joinToString$default((Iterable)splitName.subList(1, splitName.size()), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        double value = 2.0;
        return this.createCells(name, value);
    }

    /*
     * WARNING - void declaration
     */
    private final String metricsToHTML() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getLogger().getMetricNames();
        boolean $i$f$map = false;
        Iterable iterable22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void it;
            String string = (String)t;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)this.getLogger().getMetric((String)it)));
        }
        List metricsMap = (List)destination$iv$iv;
        StringBuffer result = new StringBuffer();
        for (Iterable iterable22 : metricsMap) {
            String name = (String)iterable22.component1();
            Map metrics = (Map)iterable22.component2();
            this.plusAssign(result, "<div class='flex-item'><table frame=void rules=rows class='table'><caption>" + name + "</caption>");
            for (Map.Entry entry : metrics.entrySet()) {
                this.plusAssign(result, "<tr>");
                this.plusAssign(result, this.getTableCell(entry));
                this.plusAssign(result, "</tr>");
            }
            this.plusAssign(result, "</table></div>");
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String chartsToHTML() {
        return CollectionsKt.joinToString$default((Iterable)this.getCharts(), null, null, null, (int)0, null, (Function1)chartsToHTML.1.INSTANCE, (int)31, null);
    }

    @Override
    @NotNull
    public String asHTML() {
        return StringsKt.trimIndent((String)("\n             <div class=\"flex-container\">\n                 <h2>Metrics</h2>\n                 " + this.metricsToHTML() + "\n             </div>\n            <div class=\"flex-container\">\n                <h2>Charts</h2>\n                " + this.chartsToHTML() + "\n            </div>\n        "));
    }

    private final String loadStyle() {
        InputStream inputStream = this.getClass().getResourceAsStream("/css/report.css");
        Intrinsics.checkNotNull((Object)inputStream);
        InputStream stream = inputStream;
        byte[] byArray = stream.readAllBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        byte[] byArray2 = byArray;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(byArray2, charset2);
    }

    @Override
    @NotNull
    public String asHTMLPage() {
        return StringsKt.trimIndent((String)("\n            <!doctype html>\n            <html lang=\"en\">\n            <head>\n            <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n            <style>\n            " + this.loadStyle() + "\n            </style>\n            " + Chart.Companion.getScript() + "\n            </head>\n            <body>\n            " + this.asHTML() + "\n            </body>\n            </html>      \n        "));
    }

    private final void plusAssign(StringBuffer $this$plusAssign, String s) {
        Intrinsics.checkNotNullParameter((Object)$this$plusAssign, (String)"<this>");
        $this$plusAssign.append(s);
    }

    public static final /* synthetic */ Roboquant access$getRoboquant$p(MetricsReport $this) {
        return $this.roboquant;
    }
}

