/*
 * Decompiled with CFR 0.152.
 */
package org.roboquant.jupyter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.hipparchus.stat.descriptive.StreamingStatistics;
import org.hipparchus.stat.fitting.EmpiricalDistribution;
import org.icepear.echarts.Bar;
import org.icepear.echarts.Option;
import org.icepear.echarts.charts.bar.BarLabel;
import org.icepear.echarts.charts.bar.BarSeries;
import org.icepear.echarts.components.coord.cartesian.CategoryAxis;
import org.icepear.echarts.components.coord.cartesian.ValueAxis;
import org.icepear.echarts.components.dataZoom.DataZoom;
import org.icepear.echarts.components.tooltip.Tooltip;
import org.icepear.echarts.origin.chart.bar.BarLabelOption;
import org.icepear.echarts.origin.component.dataZoom.DataZoomOption;
import org.icepear.echarts.origin.component.toolbox.ToolboxOption;
import org.icepear.echarts.origin.coord.cartesian.AxisOption;
import org.icepear.echarts.origin.util.SeriesOption;
import org.jetbrains.annotations.NotNull;
import org.roboquant.common.ExtensionsKt;
import org.roboquant.common.TimeSeries;
import org.roboquant.common.TimeSeriesKt;
import org.roboquant.jupyter.Chart;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B9\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nB+\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u00110\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/roboquant/jupyter/HistogramChart;", "Lorg/roboquant/jupyter/Chart;", "metricData", "", "", "Lorg/roboquant/common/TimeSeries;", "binCount", "", "scale", "minBinSize", "(Ljava/util/Map;III)V", "timeSeries", "(Lorg/roboquant/common/TimeSeries;III)V", "getOption", "Lorg/icepear/echarts/Option;", "toSeriesData", "", "Lkotlin/Pair;", "", "roboquant-jupyter"})
@SourceDebugExtension(value={"SMAP\nHistogramChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HistogramChart.kt\norg/roboquant/jupyter/HistogramChart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,103:1\n1549#2:104\n1620#2,3:105\n1549#2:110\n1620#2,3:111\n37#3,2:108\n37#3,2:114\n*S KotlinDebug\n*F\n+ 1 HistogramChart.kt\norg/roboquant/jupyter/HistogramChart\n*L\n82#1:104\n82#1:105,3\n83#1:110\n83#1:111,3\n82#1:108,2\n83#1:114,2\n*E\n"})
public final class HistogramChart
extends Chart {
    @NotNull
    private final TimeSeries timeSeries;
    private final int binCount;
    private final int scale;
    private final int minBinSize;

    public HistogramChart(@NotNull TimeSeries timeSeries, int binCount, int scale, int minBinSize) {
        Intrinsics.checkNotNullParameter((Object)timeSeries, (String)"timeSeries");
        this.timeSeries = timeSeries;
        this.binCount = binCount;
        this.scale = scale;
        this.minBinSize = minBinSize;
    }

    public /* synthetic */ HistogramChart(TimeSeries timeSeries, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n = 20;
        }
        if ((n4 & 4) != 0) {
            n2 = 2;
        }
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        this(timeSeries, n, n2, n3);
    }

    public HistogramChart(@NotNull Map<String, TimeSeries> metricData, int binCount, int scale, int minBinSize) {
        Intrinsics.checkNotNullParameter(metricData, (String)"metricData");
        this(TimeSeriesKt.flatten(metricData, (boolean)true), binCount, scale, minBinSize);
    }

    public /* synthetic */ HistogramChart(Map map, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n = 20;
        }
        if ((n4 & 4) != 0) {
            n2 = 2;
        }
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        this(map, n, n2, n3);
    }

    private final List<Pair<String, Long>> toSeriesData() {
        EmpiricalDistribution f = new EmpiricalDistribution(this.binCount);
        double[] data = ExtensionsKt.clean((double[])this.timeSeries.toDoubleArray());
        if (data.length == 0) {
            return CollectionsKt.emptyList();
        }
        List result = new ArrayList();
        f.load(data);
        long binSize = 0L;
        int n = this.binCount;
        for (int i = 0; i < n; ++i) {
            boolean last;
            BigDecimal roundedValue = new BigDecimal(f.getUpperBounds()[i]).setScale(this.scale, RoundingMode.HALF_DOWN);
            boolean bl = last = i == this.binCount - 1;
            if ((binSize += ((StreamingStatistics)f.getBinStats().get(i)).getN()) < (long)this.minBinSize && (!last || binSize <= 0L)) continue;
            Pair e = new Pair((Object)String.valueOf(roundedValue), (Object)binSize);
            result.add(e);
            binSize = 0L;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Option getOption() {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List<Pair<String, Long>> d = this.toSeriesData();
        Iterable $this$map$iv = d;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)it.getSecond()).longValue());
        }
        Collection $this$toTypedArray$iv2 = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv2;
        Long[] data = thisCollection$iv.toArray(new Long[0]);
        Iterable $this$map$iv2 = d;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add((String)it.getFirst());
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray2 = false;
        void thisCollection$iv2 = $this$toTypedArray$iv;
        Object[] xData = thisCollection$iv2.toArray(new String[0]);
        BarSeries series = new BarSeries().setBarWidth("70%").setData((Number[])data).setLabel((BarLabelOption)new BarLabel().setShow(Boolean.valueOf(true)));
        Bar chart = (Bar)((Bar)((Bar)((Bar)((Bar)new Bar().setTitle(this.getTitle())).addYAxis((AxisOption)new ValueAxis().setScale(Boolean.valueOf(true)))).addXAxis((AxisOption)new CategoryAxis().setData(xData).setAxisTick((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"alignWithLabel", (Object)true))))).addSeries((SeriesOption)series)).setTooltip(new Tooltip().setTrigger("axis"));
        Option option = chart.getOption();
        option.setToolbox((ToolboxOption)Chart.getToolbox$default(this, false, 1, null));
        option.setDataZoom((DataZoomOption)new DataZoom());
        Intrinsics.checkNotNull((Object)option);
        return option;
    }
}

