/*
 * Decompiled with CFR 0.152.
 */
package org.roboquant.jupyter;

import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.icepear.echarts.Option;
import org.icepear.echarts.components.toolbox.Toolbox;
import org.icepear.echarts.components.toolbox.ToolboxDataViewFeature;
import org.icepear.echarts.components.toolbox.ToolboxDataZoomFeature;
import org.icepear.echarts.components.toolbox.ToolboxMagicTypeFeature;
import org.icepear.echarts.components.toolbox.ToolboxRestoreFeature;
import org.icepear.echarts.components.toolbox.ToolboxSaveAsImageFeature;
import org.icepear.echarts.components.visualMap.ContinousVisualMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.roboquant.common.Amount;
import org.roboquant.jupyter.AmountAdapter;
import org.roboquant.jupyter.ChartKt;
import org.roboquant.jupyter.HTMLOutput;
import org.roboquant.jupyter.InstantAdapter;
import org.roboquant.jupyter.PairAdapter;
import org.roboquant.jupyter.TripleAdapter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0004\b&\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\fH\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0004J\b\u0010\u0015\u001a\u00020\u0016H&J\u0012\u0010\u0017\u001a\u00020\u00142\b\b\u0002\u0010\u0018\u001a\u00020\u0004H\u0004J\u001c\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0004J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fH\u0004J\"\u0010 \u001a\b\u0012\u0004\u0012\u0002H\"0!\"\u0004\b\u0000\u0010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0!H\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lorg/roboquant/jupyter/Chart;", "Lorg/roboquant/jupyter/HTMLOutput;", "()V", "containsJavaScript", "", "height", "", "getHeight", "()I", "setHeight", "(I)V", "title", "", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "asHTML", "asHTMLPage", "getBasicToolbox", "Lorg/icepear/echarts/components/toolbox/Toolbox;", "getOption", "Lorg/icepear/echarts/Option;", "getToolbox", "includeMagicType", "getVisualMap", "Lorg/icepear/echarts/components/visualMap/ContinousVisualMap;", "min", "", "max", "javascriptFunction", "function", "reduce", "", "T", "data", "Companion", "roboquant-jupyter"})
@SourceDebugExtension(value={"SMAP\nChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Chart.kt\norg/roboquant/jupyter/Chart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n777#2:346\n788#2:347\n1864#2,2:348\n789#2,2:350\n1866#2:352\n791#2:353\n*S KotlinDebug\n*F\n+ 1 Chart.kt\norg/roboquant/jupyter/Chart\n*L\n201#1:346\n201#1:347\n201#1:348,2\n201#1:350,2\n201#1:352\n201#1:353\n*E\n"})
public abstract class Chart
extends HTMLOutput {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean containsJavaScript;
    private int height = 500;
    @Nullable
    private String title;
    @NotNull
    private static final String commit = "bdd685c1b4ab63b94b82a5ed2fc664c4b6450460";
    @NotNull
    public static final String scriptUrl = "https://cdn.jsdelivr.net/gh/neurallayer/roboquant-jupyter-js@bdd685c1b4ab63b94b82a5ed2fc664c4b6450460/echarts.min.js?version=bdd685c1b4ab63b94b82a5ed2fc664c4b6450460";
    private static int counter;
    private static int maxSamples;
    @NotNull
    private static String positiveColor;
    @NotNull
    private static String negativeColor;
    @NotNull
    private static String neutralColor;
    @NotNull
    private static final GsonBuilder gsonBuilder;

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@Nullable String string) {
        this.title = string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final <T> Collection<T> reduce(@NotNull Collection<? extends T> data) {
        Collection collection;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        if (data.size() > maxSamples) {
            void $this$filterIndexedTo$iv$iv;
            int skip = MathKt.roundToInt((double)(0.5 + (double)(data.size() / maxSamples)));
            Iterable $this$filterIndexed$iv = data;
            boolean $i$f$filterIndexed = false;
            Iterable iterable = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl = false;
                int index = index$iv$iv;
                boolean bl2 = false;
                if (!(index % skip == 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = data;
        }
        return collection;
    }

    @Override
    @NotNull
    public String asHTML() {
        String fragment = ((Object)StringsKt.trimStart((CharSequence)ChartKt.renderJson(this.getOption()))).toString();
        int n = counter;
        counter = n + 1;
        String id = "roboquant-" + n;
        String convertor = this.containsJavaScript ? "option.tooltip.formatter = new Function('p', option.tooltip.formatter);" : "";
        return StringsKt.trimIndent((String)(" \n        <div style=\"width:100%;height:" + this.height + "px;\" class=\"rqcharts\" id=\"" + id + "\">\n            <script type=\"text/javascript\">\n                (function () {\n                    let parentElem = document.currentScript.parentElement;\n                    if (parentElem.tagName === \"HEAD\") {\n                        parentElem = document.getElementById(\"" + id + "\");\n                    }\n                    console.log(\"registered new chart\");\n                    let option = " + fragment + ";" + convertor + "\n                    window.call_echarts(\n                        function () {\n                            console.log(\"rendering chart\");\n                            window.renderEChart(parentElem, option);\n                        }\n                    );\n                })()\n            </script>\n        </div>\n        "));
    }

    @Override
    @NotNull
    public String asHTMLPage() {
        String fragment = this.asHTML();
        String script = Companion.getScript();
        return StringsKt.trimIndent((String)("\n        <html lang=\"en\">\n            <head>\n                <title>roboquant chart</title>\n                " + script + "\n                <style media='screen'>\n                    html { margin: 0; padding: 0; min-height: " + this.height + "px;}\n                    body { margin: 0; padding: 10px; min-height: " + this.height + "px;}\n                </style>\n            </head>\n            <body>\n                " + fragment + "\n            </body>\n        </html>\n        "));
    }

    @NotNull
    protected final Toolbox getToolbox(boolean includeMagicType) {
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"saveAsImage", (Object)new ToolboxSaveAsImageFeature());
        pairArray[1] = TuplesKt.to((Object)"dataView", (Object)new ToolboxDataViewFeature().setReadOnly(Boolean.valueOf(true)));
        pairArray[2] = TuplesKt.to((Object)"dataZoom", (Object)new ToolboxDataZoomFeature().setYAxisIndex((Object)"none"));
        Object[] objectArray = new String[]{"line", "bar"};
        pairArray[3] = TuplesKt.to((Object)"magicType", (Object)new ToolboxMagicTypeFeature().setType(objectArray));
        pairArray[4] = TuplesKt.to((Object)"restore", (Object)new ToolboxRestoreFeature());
        Map features = MapsKt.mutableMapOf((Pair[])pairArray);
        if (!includeMagicType) {
            features.remove("magicType");
        }
        Toolbox toolbox = new Toolbox().setFeature(features);
        Intrinsics.checkNotNullExpressionValue((Object)toolbox, (String)"setFeature(...)");
        return toolbox;
    }

    public static /* synthetic */ Toolbox getToolbox$default(Chart chart, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getToolbox");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return chart.getToolbox(bl);
    }

    @NotNull
    protected final Toolbox getBasicToolbox() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"saveAsImage", (Object)new ToolboxSaveAsImageFeature()), TuplesKt.to((Object)"restore", (Object)new ToolboxRestoreFeature()), TuplesKt.to((Object)"dataView", (Object)new ToolboxDataViewFeature().setReadOnly(Boolean.valueOf(true)))};
        Map features = MapsKt.mutableMapOf((Pair[])pairArray);
        Toolbox toolbox = new Toolbox().setFeature(features);
        Intrinsics.checkNotNullExpressionValue((Object)toolbox, (String)"setFeature(...)");
        return toolbox;
    }

    @NotNull
    protected final ContinousVisualMap getVisualMap(@Nullable Number min, @Nullable Number max) {
        ContinousVisualMap continousVisualMap = new ContinousVisualMap();
        Number number = min;
        if (number == null) {
            number = -1;
        }
        ContinousVisualMap continousVisualMap2 = continousVisualMap.setMin(number);
        Number number2 = max;
        if (number2 == null) {
            number2 = 1;
        }
        String[] stringArray = new String[]{positiveColor, neutralColor, negativeColor};
        ContinousVisualMap continousVisualMap3 = continousVisualMap2.setMax(number2).setCalculable(Boolean.valueOf(true)).setOrient("horizontal").setTop("top").setLeft("center").setColor(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)continousVisualMap3, (String)"setColor(...)");
        return continousVisualMap3;
    }

    @NotNull
    protected final String javascriptFunction(@NotNull String function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this.containsJavaScript = true;
        return function;
    }

    @NotNull
    public abstract Option getOption();

    static {
        maxSamples = Integer.MAX_VALUE;
        positiveColor = "#0C0";
        negativeColor = "#C00";
        neutralColor = "#CC0";
        gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter((Type)((Object)Pair.class), (Object)new PairAdapter());
        gsonBuilder.registerTypeAdapter((Type)((Object)Triple.class), (Object)new TripleAdapter());
        gsonBuilder.registerTypeAdapter((Type)((Object)Instant.class), (Object)new InstantAdapter());
        gsonBuilder.registerTypeAdapter((Type)((Object)Amount.class), (Object)new AmountAdapter());
        if (Intrinsics.areEqual((Object)Locale.getDefault(), (Object)Locale.CHINA)) {
            positiveColor = "#C00";
            negativeColor = "#0C0";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\b\"\u0004\b\u0011\u0010\nR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u000e\u0010\u001d\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/roboquant/jupyter/Chart$Companion;", "", "()V", "commit", "", "counter", "", "getCounter$roboquant_jupyter", "()I", "setCounter$roboquant_jupyter", "(I)V", "gsonBuilder", "Lcom/google/gson/GsonBuilder;", "getGsonBuilder$roboquant_jupyter", "()Lcom/google/gson/GsonBuilder;", "maxSamples", "getMaxSamples", "setMaxSamples", "negativeColor", "getNegativeColor", "()Ljava/lang/String;", "setNegativeColor", "(Ljava/lang/String;)V", "neutralColor", "getNeutralColor", "setNeutralColor", "positiveColor", "getPositiveColor", "setPositiveColor", "scriptUrl", "getScript", "roboquant-jupyter"})
    public static final class Companion {
        private Companion() {
        }

        public final int getCounter$roboquant_jupyter() {
            return counter;
        }

        public final void setCounter$roboquant_jupyter(int n) {
            counter = n;
        }

        public final int getMaxSamples() {
            return maxSamples;
        }

        public final void setMaxSamples(int n) {
            maxSamples = n;
        }

        @NotNull
        public final String getPositiveColor() {
            return positiveColor;
        }

        public final void setPositiveColor(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            positiveColor = string;
        }

        @NotNull
        public final String getNegativeColor() {
            return negativeColor;
        }

        public final void setNegativeColor(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            negativeColor = string;
        }

        @NotNull
        public final String getNeutralColor() {
            return neutralColor;
        }

        public final void setNeutralColor(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            neutralColor = string;
        }

        @NotNull
        public final GsonBuilder getGsonBuilder$roboquant_jupyter() {
            return gsonBuilder;
        }

        @NotNull
        public final String getScript() {
            return "<script type='text/javascript' src='https://cdn.jsdelivr.net/gh/neurallayer/roboquant-jupyter-js@bdd685c1b4ab63b94b82a5ed2fc664c4b6450460/echarts.min.js?version=bdd685c1b4ab63b94b82a5ed2fc664c4b6450460'></script>";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

