/*
 * Decompiled with CFR 0.152.
 */
package org.roboquant.jupyter;

import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.icepear.echarts.Option;
import org.icepear.echarts.charts.heatmap.HeatmapSeries;
import org.icepear.echarts.components.title.Title;
import org.icepear.echarts.components.tooltip.Tooltip;
import org.icepear.echarts.origin.component.title.TitleOption;
import org.icepear.echarts.origin.component.toolbox.ToolboxOption;
import org.icepear.echarts.origin.component.tooltip.TooltipOption;
import org.icepear.echarts.origin.component.visualMap.VisualMapOption;
import org.icepear.echarts.origin.util.SeriesOption;
import org.jetbrains.annotations.NotNull;
import org.roboquant.common.ExtensionsKt;
import org.roboquant.common.Observation;
import org.roboquant.common.TimeSeries;
import org.roboquant.common.TimeSeriesKt;
import org.roboquant.jupyter.Chart;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB!\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ-\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\r0\u0003H\u0002\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J-\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\r0\u0003H\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J&\u0010\u001e\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020 0\u001f0\r0\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/roboquant/jupyter/CalendarChart;", "Lorg/roboquant/jupyter/Chart;", "metricsData", "", "", "Lorg/roboquant/common/TimeSeries;", "fractionDigits", "", "zoneId", "Ljava/time/ZoneId;", "(Ljava/util/Map;ILjava/time/ZoneId;)V", "timeSeries", "(Lorg/roboquant/common/TimeSeries;ILjava/time/ZoneId;)V", "", "Lorg/roboquant/common/Observation;", "timeFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getCalendars", "", "", "data", "(Ljava/util/Map;)[Ljava/lang/Object;", "getOption", "Lorg/icepear/echarts/Option;", "getSeriesOptions", "Lorg/icepear/echarts/charts/heatmap/HeatmapSeries;", "(Ljava/util/Map;)[Lorg/icepear/echarts/charts/heatmap/HeatmapSeries;", "getTooltip", "Lorg/icepear/echarts/components/tooltip/Tooltip;", "prepData", "Lkotlin/Pair;", "Ljava/math/BigDecimal;", "roboquant-jupyter"})
@SourceDebugExtension(value={"SMAP\nCalendarChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CalendarChart.kt\norg/roboquant/jupyter/CalendarChart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,125:1\n766#2:126\n857#2,2:127\n1477#2:129\n1502#2,3:130\n1505#2,3:140\n1477#2:144\n1502#2,3:145\n1505#2,3:155\n1238#2,2:160\n1241#2:163\n1238#2,4:166\n1855#2,2:171\n1864#2,3:175\n1549#2:180\n1620#2,3:181\n1549#2:184\n1620#2,3:185\n372#3,7:133\n372#3,7:148\n453#3:158\n403#3:159\n453#3:164\n403#3:165\n215#4:143\n216#4:170\n1#5:162\n37#6,2:173\n37#6,2:178\n*S KotlinDebug\n*F\n+ 1 CalendarChart.kt\norg/roboquant/jupyter/CalendarChart\n*L\n53#1:126\n53#1:127,2\n56#1:129\n56#1:130,3\n56#1:140,3\n61#1:144\n61#1:145,3\n61#1:155,3\n61#1:160,2\n61#1:163\n62#1:166,4\n70#1:171,2\n88#1:175,3\n111#1:180\n111#1:181,3\n112#1:184\n112#1:185,3\n56#1:133,7\n61#1:148,7\n61#1:158\n61#1:159\n62#1:164\n62#1:165\n58#1:143\n58#1:170\n83#1:173,2\n95#1:178,2\n*E\n"})
public final class CalendarChart
extends Chart {
    private final int fractionDigits;
    @NotNull
    private final ZoneId zoneId;
    private final DateTimeFormatter timeFormatter;
    @NotNull
    private final List<Observation> metricsData;

    /*
     * WARNING - void declaration
     */
    public CalendarChart(@NotNull TimeSeries timeSeries, int fractionDigits, @NotNull ZoneId zoneId) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)timeSeries, (String)"timeSeries");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.fractionDigits = fractionDigits;
        this.zoneId = zoneId;
        this.timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(this.zoneId);
        Iterable iterable = (Iterable)timeSeries;
        CalendarChart calendarChart = this;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Observation it = (Observation)element$iv$iv;
            boolean bl = false;
            double d = it.getValue();
            boolean bl2 = !Double.isInfinite(d) && !Double.isNaN(d);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        calendarChart.metricsData = (List)destination$iv$iv;
    }

    public /* synthetic */ CalendarChart(TimeSeries timeSeries, int n, ZoneId zoneId, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        if ((n2 & 4) != 0) {
            ZoneId zoneId2 = ZoneId.of("UTC");
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"of(...)");
            zoneId = zoneId2;
        }
        this(timeSeries, n, zoneId);
    }

    public CalendarChart(@NotNull Map<String, TimeSeries> metricsData, int fractionDigits, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter(metricsData, (String)"metricsData");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this(TimeSeriesKt.flatten(metricsData, (boolean)true), fractionDigits, zoneId);
    }

    public /* synthetic */ CalendarChart(Map map, int n, ZoneId zoneId, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        if ((n2 & 4) != 0) {
            ZoneOffset zoneOffset = ZoneOffset.UTC;
            Intrinsics.checkNotNullExpressionValue((Object)zoneOffset, (String)"UTC");
            zoneId = zoneOffset;
        }
        this(map, n, zoneId);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, List<Pair<String, BigDecimal>>> prepData() {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.metricsData;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Observation it = (Observation)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it.getTime().atZone(this.zoneId).getYear();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map perYear = destination$iv$iv;
        Map result = new LinkedHashMap();
        Map $this$forEach$iv = perYear;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            void $this$mapValuesTo$iv$iv;
            Number number;
            Map map;
            Object k;
            void $this$mapValuesTo$iv$iv2;
            void $this$mapValues$iv;
            Object list$iv$iv;
            Object value$iv$iv$iv;
            Map $this$getOrPut$iv$iv$iv;
            Object key$iv$iv;
            void $this$groupByTo$iv$iv2;
            Map.Entry entry = element$iv;
            boolean bl = false;
            int t = ((Number)entry.getKey()).intValue();
            List u = (List)entry.getValue();
            Object $this$groupBy$iv2 = u;
            boolean $i$f$groupBy2 = false;
            Iterable $i$f$getOrPut = $this$groupBy$iv2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                Object object;
                Observation it = (Observation)element$iv$iv;
                boolean bl3 = false;
                key$iv$iv = this.timeFormatter.format(it.getTime());
                $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut2 = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv2 = destination$iv$iv2;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv2 = $this$mapValues$iv;
            destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo22 = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean bl5 = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map = $this$getOrPut$iv$iv$iv;
                boolean bl6 = false;
                list$iv$iv = (Iterable)it.getValue();
                double d = 0.0;
                Iterator iterator = list$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void entry2;
                    Object e = iterator.next();
                    Observation observation = (Observation)e;
                    double d2 = d;
                    boolean bl7 = false;
                    double d3 = entry2.getValue();
                    d = d2 + d3;
                }
                number = d;
                map.put(k, number);
            }
            Map summed = destination$iv$iv2;
            Map map2 = result;
            Integer n = t;
            Map $this$mapValues$iv2 = summed;
            boolean $i$f$mapValues2 = false;
            Map $i$f$mapValuesTo22 = $this$mapValues$iv2;
            Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                void it;
                void it$iv$iv;
                Map.Entry bl5 = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv3;
                boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = false;
                list$iv$iv = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map = map3;
                boolean bl8 = false;
                number = ExtensionsKt.round((Number)((Number)it.getValue()), (int)this.fractionDigits);
                map.put(k, number);
            }
            List list = MapsKt.toList((Map)destination$iv$iv3);
            map2.put(n, list);
        }
        return MapsKt.toSortedMap((Map)result);
    }

    private final Object[] getCalendars(Map<Integer, ? extends List<? extends Object>> data) {
        int top = 0;
        top = 100;
        List result = new ArrayList();
        Iterable $this$forEach$iv = data.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            Collection collection = result;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"top", (Object)top), TuplesKt.to((Object)"range", (Object)it), TuplesKt.to((Object)"cellSize", (Object)new Pair((Object)"auto", (Object)20)), TuplesKt.to((Object)"right", (Object)10)};
            collection.add(MapsKt.mapOf((Pair[])pairArray));
            top += 200;
        }
        this.setHeight(top);
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final HeatmapSeries[] getSeriesOptions(Map<Integer, ? extends List<? extends Object>> data) {
        List seriesOptions = new ArrayList();
        Iterable $this$forEachIndexed$iv = data.values();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void list;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list2 = (List)item$iv;
            int index = n;
            boolean bl = false;
            HeatmapSeries hp = new HeatmapSeries().setData((Object)list).setCoordinateSystem("calendar").setCalendarIndex((Number)index);
            Intrinsics.checkNotNull((Object)hp);
            seriesOptions.add(hp);
        }
        Collection $this$toTypedArray$iv = seriesOptions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new HeatmapSeries[0]);
    }

    private final Tooltip getTooltip() {
        Tooltip tooltip = new Tooltip().setPosition((Object)"top").setFormatter(this.javascriptFunction("var f = echarts.format.formatTime('yyyy-MM-dd', p.data[0]);return f + ': ' + p.data[1];"));
        Intrinsics.checkNotNullExpressionValue((Object)tooltip, (String)"setFormatter(...)");
        return tooltip;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Option getOption() {
        Double d;
        void $this$mapTo$iv$iv;
        Double d2;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Map<Integer, List<Pair<String, BigDecimal>>> data = this.prepData();
        Iterable $this$map$iv = this.metricsData;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Observation observation = (Observation)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        Iterator $i$f$map22 = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!$i$f$map22.hasNext()) {
            d2 = null;
        } else {
            double it = ((Number)$i$f$map22.next()).doubleValue();
            boolean bl = false;
            while ($i$f$map22.hasNext()) {
                double it2 = ((Number)$i$f$map22.next()).doubleValue();
                $i$a$-maxOfOrNull-CalendarChart$getOption$max$2 = false;
                it = Math.max(it, it2);
            }
            d2 = it;
        }
        Double max = d2;
        Iterable $this$map$iv2 = this.metricsData;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Observation bl = (Observation)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getValue());
        }
        Iterator iterator = ((Iterable)((List)destination$iv$iv2)).iterator();
        if (!iterator.hasNext()) {
            d = null;
        } else {
            double it = ((Number)iterator.next()).doubleValue();
            boolean bl = false;
            double d3 = it;
            while (iterator.hasNext()) {
                double it3 = ((Number)iterator.next()).doubleValue();
                $i$a$-minOfOrNull-CalendarChart$getOption$min$2 = false;
                double d4 = it3;
                d3 = Math.min(d3, d4);
            }
            d = d3;
        }
        Double min = d;
        Option option = new Option().setTitle((TitleOption)new Title().setText(this.getTitle())).setSeries((SeriesOption[])this.getSeriesOptions(data)).setCalendar(this.getCalendars(data)).setVisualMap((VisualMapOption)this.getVisualMap(min, max)).setTooltip((TooltipOption)this.getTooltip()).setToolbox((ToolboxOption)this.getBasicToolbox());
        Intrinsics.checkNotNullExpressionValue((Object)option, (String)"setToolbox(...)");
        return option;
    }
}

