/*
 * Decompiled with CFR 0.152.
 */
package org.roboquant.jupyter;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.hipparchus.stat.descriptive.rank.Percentile;
import org.icepear.echarts.Boxplot;
import org.icepear.echarts.Option;
import org.icepear.echarts.charts.boxplot.BoxplotSeries;
import org.icepear.echarts.components.coord.cartesian.CategoryAxis;
import org.icepear.echarts.components.coord.cartesian.ValueAxis;
import org.icepear.echarts.components.dataZoom.DataZoom;
import org.icepear.echarts.origin.component.dataZoom.DataZoomOption;
import org.icepear.echarts.origin.component.toolbox.ToolboxOption;
import org.icepear.echarts.origin.coord.cartesian.AxisOption;
import org.icepear.echarts.origin.util.SeriesOption;
import org.jetbrains.annotations.NotNull;
import org.roboquant.common.ExtensionsKt;
import org.roboquant.common.TimeSeries;
import org.roboquant.common.TimeSeriesKt;
import org.roboquant.jupyter.Chart;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001BM\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB?\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00160\u00150\u0014H\u0002R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/roboquant/jupyter/BoxChart;", "Lorg/roboquant/jupyter/Chart;", "metricData", "", "", "Lorg/roboquant/common/TimeSeries;", "period", "Ljava/time/temporal/ChronoUnit;", "lowPercentile", "", "midPercentile", "highPercentile", "precision", "", "(Ljava/util/Map;Ljava/time/temporal/ChronoUnit;DDDI)V", "timeSeries", "(Lorg/roboquant/common/TimeSeries;Ljava/time/temporal/ChronoUnit;DDDI)V", "getOption", "Lorg/icepear/echarts/Option;", "toSeriesData", "", "Lkotlin/Pair;", "", "roboquant-jupyter"})
@SourceDebugExtension(value={"SMAP\nBoxChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoxChart.kt\norg/roboquant/jupyter/BoxChart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,111:1\n1002#2,2:112\n1549#2:114\n1620#2,3:115\n1549#2:120\n1620#2,3:121\n37#3,2:118\n*S KotlinDebug\n*F\n+ 1 BoxChart.kt\norg/roboquant/jupyter/BoxChart\n*L\n85#1:112,2\n92#1:114\n92#1:115,3\n93#1:120\n93#1:121,3\n92#1:118,2\n*E\n"})
public final class BoxChart
extends Chart {
    @NotNull
    private final TimeSeries timeSeries;
    @NotNull
    private final ChronoUnit period;
    private final double lowPercentile;
    private final double midPercentile;
    private final double highPercentile;
    private final int precision;

    public BoxChart(@NotNull TimeSeries timeSeries, @NotNull ChronoUnit period, double lowPercentile, double midPercentile, double highPercentile, int precision) {
        Intrinsics.checkNotNullParameter((Object)timeSeries, (String)"timeSeries");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        this.timeSeries = timeSeries;
        this.period = period;
        this.lowPercentile = lowPercentile;
        this.midPercentile = midPercentile;
        this.highPercentile = highPercentile;
        this.precision = precision;
    }

    public /* synthetic */ BoxChart(TimeSeries timeSeries, ChronoUnit chronoUnit, double d, double d2, double d3, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            chronoUnit = ChronoUnit.MONTHS;
        }
        if ((n2 & 4) != 0) {
            d = 25.0;
        }
        if ((n2 & 8) != 0) {
            d2 = 50.0;
        }
        if ((n2 & 0x10) != 0) {
            d3 = 75.0;
        }
        if ((n2 & 0x20) != 0) {
            n = 8;
        }
        this(timeSeries, chronoUnit, d, d2, d3, n);
    }

    public BoxChart(@NotNull Map<String, TimeSeries> metricData, @NotNull ChronoUnit period, double lowPercentile, double midPercentile, double highPercentile, int precision) {
        Intrinsics.checkNotNullParameter(metricData, (String)"metricData");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        this(TimeSeriesKt.flatten(metricData, (boolean)true), period, lowPercentile, midPercentile, highPercentile, precision);
    }

    public /* synthetic */ BoxChart(Map map, ChronoUnit chronoUnit, double d, double d2, double d3, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            chronoUnit = ChronoUnit.MONTHS;
        }
        if ((n2 & 4) != 0) {
            d = 25.0;
        }
        if ((n2 & 8) != 0) {
            d2 = 50.0;
        }
        if ((n2 & 0x10) != 0) {
            d3 = 75.0;
        }
        if ((n2 & 0x20) != 0) {
            n = 8;
        }
        this(map, chronoUnit, d, d2, d3, n);
    }

    private final List<Pair<String, Object>> toSeriesData() {
        List result = new ArrayList();
        MathContext ctx = new MathContext(this.precision, RoundingMode.HALF_DOWN);
        for (Map.Entry d : TimeSeries.groupBy$default((TimeSeries)this.timeSeries, (ChronoUnit)this.period, null, (int)2, null).entrySet()) {
            double[] arr = ExtensionsKt.clean((double[])((TimeSeries)d.getValue()).toDoubleArray());
            if (!(!(arr.length == 0))) continue;
            Percentile p = new Percentile();
            p.setData(arr);
            Object[] objectArray = new BigDecimal[5];
            double d2 = ArraysKt.minOrThrow((double[])arr);
            objectArray[0] = new BigDecimal(String.valueOf(d2), ctx);
            d2 = p.evaluate(this.lowPercentile);
            objectArray[1] = new BigDecimal(String.valueOf(d2), ctx);
            d2 = p.evaluate(this.midPercentile);
            objectArray[2] = new BigDecimal(String.valueOf(d2), ctx);
            d2 = p.evaluate(this.highPercentile);
            objectArray[3] = new BigDecimal(String.valueOf(d2), ctx);
            d2 = ArraysKt.maxOrThrow((double[])arr);
            objectArray[4] = new BigDecimal(String.valueOf(d2), ctx);
            List entry = CollectionsKt.listOf((Object[])objectArray);
            result.add(new Pair(d.getKey(), (Object)entry));
        }
        List $this$sortBy$iv = result;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getFirst()))));
                }
            });
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Option getOption() {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List<Pair<String, Object>> data = this.toSeriesData();
        Iterable $this$map$iv = data;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getFirst());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] xData = thisCollection$iv.toArray(new String[0]);
        Iterable $this$map$iv2 = data;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getSecond());
        }
        List yData = (List)destination$iv$iv2;
        BoxplotSeries series = new BoxplotSeries().setData((Object)yData);
        Boxplot chart = (Boxplot)((Boxplot)((Boxplot)((Boxplot)((Boxplot)new Boxplot().setTitle(this.getTitle())).addSeries((SeriesOption)series)).addYAxis((AxisOption)new ValueAxis())).addXAxis((AxisOption)new CategoryAxis().setData(xData))).setTooltip("axis");
        Option option = chart.getOption();
        option.setToolbox((ToolboxOption)this.getToolbox(false));
        option.setDataZoom((DataZoomOption)new DataZoom());
        Intrinsics.checkNotNull((Object)option);
        return option;
    }
}

