/*
 * Decompiled with CFR 0.152.
 */
package org.roboquant.jupyter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.icepear.echarts.Option;
import org.icepear.echarts.Pie;
import org.icepear.echarts.Sunburst;
import org.icepear.echarts.charts.pie.PieSeries;
import org.icepear.echarts.charts.sunburst.SunburstSeries;
import org.icepear.echarts.components.tooltip.Tooltip;
import org.icepear.echarts.origin.component.toolbox.ToolboxOption;
import org.icepear.echarts.origin.util.SeriesOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.roboquant.brokers.Position;
import org.roboquant.common.Amount;
import org.roboquant.common.Asset;
import org.roboquant.common.Currency;
import org.roboquant.jupyter.Chart;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/roboquant/jupyter/AllocationChart;", "Lorg/roboquant/jupyter/Chart;", "positions", "", "Lorg/roboquant/brokers/Position;", "includeAssetClass", "", "currency", "Lorg/roboquant/common/Currency;", "(Ljava/util/Collection;ZLorg/roboquant/common/Currency;)V", "getOption", "Lorg/icepear/echarts/Option;", "renderPie", "renderSunburst", "toSeriesData", "", "Lorg/roboquant/jupyter/AllocationChart$Entry;", "Entry", "roboquant-jupyter"})
@SourceDebugExtension(value={"SMAP\nAllocationChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllocationChart.kt\norg/roboquant/jupyter/AllocationChart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,100:1\n1045#2:101\n1549#2:102\n1620#2,3:103\n1477#2:106\n1502#2,3:107\n1505#2,3:117\n1549#2:123\n1620#2,3:124\n372#3,7:110\n125#4:120\n152#4,2:121\n154#4:127\n*S KotlinDebug\n*F\n+ 1 AllocationChart.kt\norg/roboquant/jupyter/AllocationChart\n*L\n51#1:101\n61#1:102\n61#1:103,3\n78#1:106\n78#1:107,3\n78#1:117,3\n79#1:123\n79#1:124,3\n78#1:110,7\n79#1:120\n79#1:121,2\n79#1:127\n*E\n"})
public final class AllocationChart
extends Chart {
    @NotNull
    private final Collection<Position> positions;
    private final boolean includeAssetClass;
    @Nullable
    private final Currency currency;

    public AllocationChart(@NotNull Collection<Position> positions, boolean includeAssetClass, @Nullable Currency currency) {
        Intrinsics.checkNotNullParameter(positions, (String)"positions");
        this.positions = positions;
        this.includeAssetClass = includeAssetClass;
        this.currency = currency;
    }

    public /* synthetic */ AllocationChart(Collection collection, boolean bl, Currency currency, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            currency = null;
        }
        this(collection, bl, currency);
    }

    private final List<Entry> toSeriesData() {
        if (this.positions.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Currency currency = this.currency;
        if (currency == null) {
            currency = ((Position)CollectionsKt.first((Iterable)this.positions)).getAsset().getCurrency();
        }
        Currency curr = currency;
        List result = new ArrayList();
        Iterable $this$sortedBy$iv = this.positions;
        boolean $i$f$sortedBy = false;
        for (Position position : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Position it = (Position)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getAsset().getSymbol());
                it = (Position)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getAsset().getSymbol())));
            }
        })) {
            Asset asset = position.getAsset();
            BigDecimal localAmount = Amount.toBigDecimal$default((Amount)Amount.convert$default((Amount)position.getExposure(), (Currency)curr, null, (int)2, null), (int)0, (int)1, null);
            result.add(new Entry(asset.getSymbol(), localAmount, asset.getType().name()));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Option renderPie() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.toSeriesData();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Entry entry = (Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toMap());
        }
        List data = (List)destination$iv$iv;
        PieSeries series = new PieSeries().setRadius("80%").setData((Object)data);
        Pie pie = new Pie();
        String string = this.getTitle();
        if (string == null) {
            string = "Asset allocation";
        }
        Pie chart = (Pie)((Pie)((Pie)pie.setTitle(string)).addSeries((SeriesOption)series)).setTooltip(new Tooltip());
        Option option = chart.getOption();
        option.setToolbox((ToolboxOption)this.getBasicToolbox());
        Intrinsics.checkNotNull((Object)option);
        return option;
    }

    /*
     * WARNING - void declaration
     */
    private final Option renderSunburst() {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        boolean bl;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.toSeriesData();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object t = iterator.next();
            Entry it = (Entry)t;
            bl = false;
            String key$iv$iv = it.getType();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            Collection<Map<String, Object>> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void entry2;
            list$iv$iv = entry;
            Object object = destination$iv$iv;
            bl = false;
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)"name", entry2.getKey());
            $this$getOrPut$iv$iv$iv = (Iterable)entry2.getValue();
            String string = "children";
            int n = 1;
            Pair[] pairArray2 = pairArray;
            boolean $i$f$map2 = false;
            void var17_22 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                Entry entry3 = (Entry)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(it.toMap());
            }
            collection = (List)destination$iv$iv2;
            pairArray2[n] = TuplesKt.to((Object)string, (Object)collection);
            object.add(MapsKt.mapOf((Pair[])pairArray));
        }
        List data = (List)destination$iv$iv;
        SunburstSeries series = new SunburstSeries().setData((Object)data).setRadius("80%");
        Sunburst chart = (Sunburst)((Sunburst)((Sunburst)new Sunburst().setTitle("Asset Allocation")).addSeries((SeriesOption)series)).setTooltip(new Tooltip());
        Option option = chart.getOption();
        option.setToolbox((ToolboxOption)this.getBasicToolbox());
        Intrinsics.checkNotNull((Object)option);
        return option;
    }

    @Override
    @NotNull
    public Option getOption() {
        return this.includeAssetClass ? this.renderSunburst() : this.renderPie();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/roboquant/jupyter/AllocationChart$Entry;", "", "name", "", "value", "Ljava/math/BigDecimal;", "type", "(Ljava/lang/String;Ljava/math/BigDecimal;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getType", "getValue", "()Ljava/math/BigDecimal;", "toMap", "", "roboquant-jupyter"})
    private static final class Entry {
        @NotNull
        private final String name;
        @NotNull
        private final BigDecimal value;
        @NotNull
        private final String type;

        public Entry(@NotNull String name, @NotNull BigDecimal value, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.name = name;
            this.value = value;
            this.type = type;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final BigDecimal getValue() {
            return this.value;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final Map<String, Object> toMap() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)this.name), TuplesKt.to((Object)"value", (Object)this.value), TuplesKt.to((Object)"type", (Object)this.type)};
            return MapsKt.mapOf((Pair[])pairArray);
        }
    }
}

