/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.dependency;

import com.google.common.base.Strings;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.robolectric.internal.dependency.MavenJarArtifact;
import org.robolectric.util.Logger;

public class MavenArtifactFetcher {
    private final String repositoryUrl;
    private final String repositoryUserName;
    private final String repositoryPassword;
    private final File localRepositoryDir;
    private final ExecutorService executorService;
    private File stagingRepositoryDir;

    public MavenArtifactFetcher(String repositoryUrl, String repositoryUserName, String repositoryPassword, File localRepositoryDir, ExecutorService executorService) {
        this.repositoryUrl = repositoryUrl;
        this.repositoryUserName = repositoryUserName;
        this.repositoryPassword = repositoryPassword;
        this.localRepositoryDir = localRepositoryDir;
        this.executorService = executorService;
    }

    public void fetchArtifact(MavenJarArtifact artifact) {
        if (new File(this.localRepositoryDir, artifact.jarPath()).exists()) {
            Logger.info((String)String.format("Found %s in local maven repository", artifact), (Object[])new Object[0]);
            return;
        }
        this.stagingRepositoryDir = Files.createTempDir();
        this.stagingRepositoryDir.deleteOnExit();
        try {
            this.createArtifactSubdirectory(artifact, this.stagingRepositoryDir);
            Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{this.fetchToStagingRepository(artifact.pomSha1Path()), this.fetchToStagingRepository(artifact.pomPath()), this.fetchToStagingRepository(artifact.jarSha1Path()), this.fetchToStagingRepository(artifact.jarPath())}).callAsync(() -> {
                if (new File(this.localRepositoryDir, artifact.jarPath()).exists()) {
                    this.removeArtifactFiles(this.stagingRepositoryDir, artifact);
                    return Futures.immediateFuture(null);
                }
                this.createArtifactSubdirectory(artifact, this.localRepositoryDir);
                boolean pomValid = this.validateStagedFiles(artifact.pomPath(), artifact.pomSha1Path());
                if (!pomValid) {
                    String string = String.valueOf(artifact);
                    throw new AssertionError((Object)new StringBuilder(38 + String.valueOf(string).length()).append("SHA1 mismatch for POM file fetched in ").append(string).toString());
                }
                boolean jarValid = this.validateStagedFiles(artifact.jarPath(), artifact.jarSha1Path());
                if (!jarValid) {
                    String string = String.valueOf(artifact);
                    throw new AssertionError((Object)new StringBuilder(38 + String.valueOf(string).length()).append("SHA1 mismatch for JAR file fetched in ").append(string).toString());
                }
                Logger.info((String)String.format("Checksums validated, moving artifact %s to local maven directory", artifact), (Object[])new Object[0]);
                this.commitFromStaging(artifact.pomSha1Path());
                this.commitFromStaging(artifact.pomPath());
                this.commitFromStaging(artifact.jarSha1Path());
                this.commitFromStaging(artifact.jarPath());
                this.removeArtifactFiles(this.stagingRepositoryDir, artifact);
                return Futures.immediateFuture(null);
            }, (Executor)this.executorService).get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.removeArtifactFiles(this.stagingRepositoryDir, artifact);
            this.removeArtifactFiles(this.localRepositoryDir, artifact);
            String string = String.valueOf(artifact);
            Logger.error((String)new StringBuilder(31 + String.valueOf(string).length()).append("Failed to fetch maven artifact ").append(string).toString(), (Throwable)e);
            string = String.valueOf(artifact);
            throw new AssertionError(new StringBuilder(31 + String.valueOf(string).length()).append("Failed to fetch maven artifact ").append(string).toString(), e);
        }
    }

    private void removeArtifactFiles(File repositoryDir, MavenJarArtifact artifact) {
        new File(repositoryDir, artifact.jarPath()).delete();
        new File(repositoryDir, artifact.jarSha1Path()).delete();
        new File(repositoryDir, artifact.pomPath()).delete();
        new File(repositoryDir, artifact.pomSha1Path()).delete();
    }

    private boolean validateStagedFiles(String filePath, String sha1Path) throws IOException {
        File tempFile = new File(this.stagingRepositoryDir, filePath);
        File sha1File = new File(this.stagingRepositoryDir, sha1Path);
        HashCode expected = HashCode.fromString((String)new String(Files.asByteSource((File)sha1File).read(), StandardCharsets.UTF_8));
        HashCode actual = Files.asByteSource((File)tempFile).hash(Hashing.sha1());
        return expected.equals((Object)actual);
    }

    private void createArtifactSubdirectory(MavenJarArtifact artifact, File repositoryDir) throws IOException {
        File jarPath = new File(repositoryDir, artifact.jarPath());
        Files.createParentDirs((File)jarPath);
    }

    private URL getRemoteUrl(String path) {
        String url = this.repositoryUrl;
        if (!url.endsWith("/")) {
            url = String.valueOf(url).concat("/");
        }
        try {
            String string = String.valueOf(url);
            String string2 = String.valueOf(path);
            return new URI(string2.length() != 0 ? string.concat(string2) : new String(string)).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private ListenableFuture<Void> fetchToStagingRepository(String path) {
        URL remoteUrl = this.getRemoteUrl(path);
        File destination = new File(this.stagingRepositoryDir, path);
        return this.createFetchToFileTask(remoteUrl, destination);
    }

    protected ListenableFuture<Void> createFetchToFileTask(URL remoteUrl, File tempFile) {
        return Futures.submitAsync((AsyncCallable)new FetchToFileTask(remoteUrl, tempFile, this.repositoryUserName, this.repositoryPassword), (Executor)this.executorService);
    }

    private void commitFromStaging(String path) throws IOException {
        File source = new File(this.stagingRepositoryDir, path);
        File destination = new File(this.localRepositoryDir, path);
        Files.move((File)source, (File)destination);
    }

    static class FetchToFileTask
    implements AsyncCallable<Void> {
        private final URL remoteURL;
        private final File localFile;
        private String repositoryUserName;
        private String repositoryPassword;

        public FetchToFileTask(URL remoteURL, File localFile, String repositoryUserName, String repositoryPassword) {
            this.remoteURL = remoteURL;
            this.localFile = localFile;
            this.repositoryUserName = repositoryUserName;
            this.repositoryPassword = repositoryPassword;
        }

        public ListenableFuture<Void> call() throws Exception {
            String encoded;
            URLConnection connection = this.remoteURL.openConnection();
            if (!Strings.isNullOrEmpty((String)this.repositoryUserName)) {
                String string = this.repositoryUserName;
                String string2 = this.repositoryPassword;
                encoded = Base64.getEncoder().encodeToString(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(":").append(string2).toString().getBytes(StandardCharsets.UTF_8));
                String string3 = String.valueOf(encoded);
                connection.setRequestProperty("Authorization", string3.length() != 0 ? "Basic ".concat(string3) : new String("Basic "));
            }
            encoded = String.valueOf(this.remoteURL);
            Logger.info((String)new StringBuilder(13 + String.valueOf(encoded).length()).append("Transferring ").append(encoded).toString(), (Object[])new Object[0]);
            try (InputStream inputStream = connection.getInputStream();
                 FileOutputStream outputStream = new FileOutputStream(this.localFile);){
                ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            return Futures.immediateFuture(null);
        }
    }
}

