/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.dependency;

import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import org.robolectric.util.Logger;

class KeyStoreUtil {
    KeyStoreUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyStore getKeyStore() throws GeneralSecurityException, IOException {
        String defaultType = KeyStore.getDefaultType();
        String tsPath = null;
        char[] tsPassword = null;
        String trustStoreProp = KeyStoreUtil.getSystemProperty("javax.net.ssl.trustStore");
        if (!"NONE".equals(trustStoreProp)) {
            if (!Strings.isNullOrEmpty((String)trustStoreProp)) {
                if (new File(trustStoreProp).exists()) {
                    tsPath = trustStoreProp;
                }
            } else {
                String javaHome = KeyStoreUtil.getSystemProperty("java.home");
                if (!Strings.isNullOrEmpty((String)javaHome)) {
                    String jsseCacertsPath = String.valueOf(javaHome).concat("/lib/security/jssecacerts");
                    if (new File(jsseCacertsPath).exists()) {
                        defaultType = "jks";
                        tsPath = jsseCacertsPath;
                    } else {
                        String cacertsPath = String.valueOf(javaHome).concat("/lib/security/cacerts");
                        if (new File(cacertsPath).exists()) {
                            defaultType = "jks";
                            tsPath = cacertsPath;
                        }
                    }
                }
            }
        }
        KeyStore ks = KeyStoreUtil.createTrustStore(defaultType);
        String tsPasswordProp = KeyStoreUtil.getSystemProperty("javax.net.ssl.trustStorePassword");
        if (!Strings.isNullOrEmpty((String)tsPasswordProp)) {
            tsPassword = tsPasswordProp.toCharArray();
        }
        BufferedInputStream tsInput = null;
        try {
            if (Strings.isNullOrEmpty((String)tsPath)) {
                Logger.info((String)"Initializing empty trust store", (Object[])new Object[0]);
            } else {
                String string = String.valueOf(tsPath);
                Logger.info((String)(string.length() != 0 ? "Initializing with trust store at path: ".concat(string) : new String("Initializing with trust store at path: ")), (Object[])new Object[0]);
                tsInput = new BufferedInputStream(new FileInputStream(tsPath));
            }
            ks.load(tsInput, tsPassword);
        }
        finally {
            Closeables.closeQuietly(tsInput);
        }
        return ks;
    }

    private static KeyStore createTrustStore(String defaultType) throws NoSuchProviderException, KeyStoreException {
        String tsType = KeyStoreUtil.getSystemProperty("javax.net.ssl.trustStoreType");
        tsType = Strings.isNullOrEmpty((String)tsType) ? defaultType : tsType;
        String tsProv = KeyStoreUtil.getSystemProperty("javax.net.ssl.trustStoreProvider");
        return Strings.isNullOrEmpty((String)tsProv) ? KeyStore.getInstance(tsType) : KeyStore.getInstance(tsType, tsProv);
    }

    private static String getSystemProperty(String propertyName) {
        return AccessController.doPrivileged(() -> System.getProperty(propertyName));
    }
}

