/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.io.netty.channel.kqueue;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import reactivemongo.io.netty.channel.Channel;
import reactivemongo.io.netty.channel.EventLoop;
import reactivemongo.io.netty.channel.kqueue.AbstractKQueueServerChannel;
import reactivemongo.io.netty.channel.kqueue.BsdSocket;
import reactivemongo.io.netty.channel.kqueue.KQueueEventLoop;
import reactivemongo.io.netty.channel.kqueue.KQueueServerSocketChannelConfig;
import reactivemongo.io.netty.channel.kqueue.KQueueSocketChannel;
import reactivemongo.io.netty.channel.socket.ServerSocketChannel;
import reactivemongo.io.netty.channel.unix.NativeInetAddress;

public final class KQueueServerSocketChannel
extends AbstractKQueueServerChannel
implements ServerSocketChannel {
    private final KQueueServerSocketChannelConfig config = new KQueueServerSocketChannelConfig(this);

    public KQueueServerSocketChannel() {
        super(BsdSocket.newSocketStream(), false);
    }

    public KQueueServerSocketChannel(int fd) {
        this(new BsdSocket(fd));
    }

    KQueueServerSocketChannel(BsdSocket fd) {
        super(fd);
    }

    KQueueServerSocketChannel(BsdSocket fd, boolean active) {
        super(fd, active);
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof KQueueEventLoop;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        super.doBind(localAddress);
        this.socket.listen(this.config.getBacklog());
        this.active = true;
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public KQueueServerSocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected Channel newChildChannel(int fd, byte[] address, int offset, int len) throws Exception {
        return new KQueueSocketChannel((Channel)this, new BsdSocket(fd), NativeInetAddress.address(address, offset, len));
    }
}

