/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.io.netty.channel.kqueue;

import reactivemongo.io.netty.buffer.ByteBuf;
import reactivemongo.io.netty.buffer.ByteBufAllocator;
import reactivemongo.io.netty.channel.ChannelConfig;
import reactivemongo.io.netty.channel.RecvByteBufAllocator;
import reactivemongo.io.netty.channel.kqueue.KQueueChannelConfig;
import reactivemongo.io.netty.channel.unix.PreferredDirectByteBufAllocator;
import reactivemongo.io.netty.util.UncheckedBooleanSupplier;

final class KQueueRecvByteAllocatorHandle
extends RecvByteBufAllocator.DelegatingHandle
implements RecvByteBufAllocator.ExtendedHandle {
    private final PreferredDirectByteBufAllocator preferredDirectByteBufAllocator = new PreferredDirectByteBufAllocator();
    private final UncheckedBooleanSupplier defaultMaybeMoreDataSupplier = new UncheckedBooleanSupplier(){

        public boolean get() {
            return KQueueRecvByteAllocatorHandle.this.maybeMoreDataToRead();
        }
    };
    private boolean overrideGuess;
    private boolean readEOF;
    private long numberBytesPending;

    KQueueRecvByteAllocatorHandle(RecvByteBufAllocator.ExtendedHandle handle) {
        super((RecvByteBufAllocator.Handle)handle);
    }

    public int guess() {
        return this.overrideGuess ? this.guess0() : this.delegate().guess();
    }

    public void reset(ChannelConfig config) {
        this.overrideGuess = ((KQueueChannelConfig)config).getRcvAllocTransportProvidesGuess();
        this.delegate().reset(config);
    }

    public ByteBuf allocate(ByteBufAllocator alloc) {
        this.preferredDirectByteBufAllocator.updateAllocator(alloc);
        return this.overrideGuess ? this.preferredDirectByteBufAllocator.ioBuffer(this.guess0()) : this.delegate().allocate((ByteBufAllocator)this.preferredDirectByteBufAllocator);
    }

    public void lastBytesRead(int bytes) {
        this.numberBytesPending = bytes < 0 ? 0L : Math.max(0L, this.numberBytesPending - (long)bytes);
        this.delegate().lastBytesRead(bytes);
    }

    public boolean continueReading(UncheckedBooleanSupplier maybeMoreDataSupplier) {
        return ((RecvByteBufAllocator.ExtendedHandle)this.delegate()).continueReading(maybeMoreDataSupplier);
    }

    public boolean continueReading() {
        return this.continueReading(this.defaultMaybeMoreDataSupplier);
    }

    void readEOF() {
        this.readEOF = true;
    }

    boolean isReadEOF() {
        return this.readEOF;
    }

    void numberBytesPending(long numberBytesPending) {
        this.numberBytesPending = numberBytesPending;
    }

    boolean maybeMoreDataToRead() {
        return this.numberBytesPending != 0L;
    }

    private int guess0() {
        return (int)Math.min(this.numberBytesPending, Integer.MAX_VALUE);
    }
}

