/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api.bson.msb;

import java.io.Serializable;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonElement;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonSymbol;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import reactivemongo.api.bson.BSONArray;
import reactivemongo.api.bson.BSONArray$;
import reactivemongo.api.bson.BSONBinary;
import reactivemongo.api.bson.BSONBinary$;
import reactivemongo.api.bson.BSONBoolean;
import reactivemongo.api.bson.BSONBoolean$;
import reactivemongo.api.bson.BSONDateTime;
import reactivemongo.api.bson.BSONDateTime$;
import reactivemongo.api.bson.BSONDecimal;
import reactivemongo.api.bson.BSONDecimal$;
import reactivemongo.api.bson.BSONDocument;
import reactivemongo.api.bson.BSONDocument$;
import reactivemongo.api.bson.BSONDouble;
import reactivemongo.api.bson.BSONDouble$;
import reactivemongo.api.bson.BSONElement;
import reactivemongo.api.bson.BSONElement$;
import reactivemongo.api.bson.BSONInteger;
import reactivemongo.api.bson.BSONInteger$;
import reactivemongo.api.bson.BSONJavaScript;
import reactivemongo.api.bson.BSONJavaScript$;
import reactivemongo.api.bson.BSONJavaScriptWS;
import reactivemongo.api.bson.BSONJavaScriptWS$;
import reactivemongo.api.bson.BSONLong;
import reactivemongo.api.bson.BSONLong$;
import reactivemongo.api.bson.BSONObjectID;
import reactivemongo.api.bson.BSONObjectID$;
import reactivemongo.api.bson.BSONRegex;
import reactivemongo.api.bson.BSONRegex$;
import reactivemongo.api.bson.BSONString;
import reactivemongo.api.bson.BSONString$;
import reactivemongo.api.bson.BSONSymbol;
import reactivemongo.api.bson.BSONSymbol$;
import reactivemongo.api.bson.BSONTimestamp;
import reactivemongo.api.bson.BSONTimestamp$;
import reactivemongo.api.bson.BSONValue;
import reactivemongo.api.bson.Subtype;
import reactivemongo.api.bson.msb.JavaConverters$;
import reactivemongo.api.bson.msb.LowPriorityConverters;
import reactivemongo.api.bson.msb.ValueConvertersCompat;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public interface ValueConverters
extends ValueConvertersCompat,
LowPriorityConverters {
    public static void $init$(ValueConverters $this) {
        byte BinaryCode = BsonBinarySubType.BINARY.getValue();
        byte FunctionCode = BsonBinarySubType.FUNCTION.getValue();
        byte OldBinaryCode = BsonBinarySubType.OLD_BINARY.getValue();
        byte UuidLegacyCode = BsonBinarySubType.UUID_LEGACY.getValue();
        byte UuidCode = BsonBinarySubType.UUID_STANDARD.getValue();
        byte Md5Code = BsonBinarySubType.MD5.getValue();
        $this.reactivemongo$api$bson$msb$ValueConverters$_setter_$codeToBinSubtype_$eq((Function1 & Serializable)_$1 -> ValueConverters.$init$$$anonfun$1(BinaryCode, FunctionCode, OldBinaryCode, UuidLegacyCode, UuidCode, Md5Code, BoxesRunTime.unboxToByte((Object)_$1)));
    }

    public static BSONArray toArray$(ValueConverters $this, BsonArray bson) {
        return $this.toArray(bson);
    }

    default public BSONArray toArray(BsonArray bson2) {
        return BSONArray$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.iterableAsScalaIterable(bson2.getValues()).map((Function1 & Serializable)bson -> this.toValue((BsonValue)bson)));
    }

    public static BsonArray fromArray$(ValueConverters $this, BSONArray array) {
        return $this.fromArray(array);
    }

    default public BsonArray fromArray(BSONArray array) {
        return new BsonArray(JavaConverters$.MODULE$.seqAsJavaList((Seq)array.values().map((Function1 & Serializable)bson -> this.fromValue((BSONValue)bson))));
    }

    public static BSONDocument toDocument$(ValueConverters $this, BsonDocument bson) {
        return $this.toDocument(bson);
    }

    default public BSONDocument toDocument(BsonDocument bson) {
        return BSONDocument$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.iterableAsScalaIterable(bson.entrySet()).map((Function1 & Serializable)entry -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(entry.getKey());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.toValue((BsonValue)entry.getValue()));
        }));
    }

    public static BSONElement toElement$(ValueConverters $this, BsonElement bson) {
        return $this.toElement(bson);
    }

    default public BSONElement toElement(BsonElement bson) {
        return BSONElement$.MODULE$.apply(bson.getName(), this.toValue(bson.getValue()));
    }

    public static BsonDocument fromDocument$(ValueConverters $this, BSONDocument doc) {
        return $this.fromDocument(doc);
    }

    default public BsonDocument fromDocument(BSONDocument doc) {
        BsonDocument bson = new BsonDocument();
        doc.elements().foreach((Function1 & Serializable)x$1 -> {
            Option option;
            BSONElement bSONElement = x$1;
            if (bSONElement != null && !(option = BSONElement$.MODULE$.unapply((Object)bSONElement)).isEmpty()) {
                Tuple2 tuple2 = (Tuple2)option.get();
                String k = (String)tuple2._1();
                BSONValue v = (BSONValue)tuple2._2();
                return bson.append(k, this.fromValue(v));
            }
            return BoxedUnit.UNIT;
        });
        return bson;
    }

    public static BsonElement fromElement$(ValueConverters $this, BSONElement element) {
        return $this.fromElement(element);
    }

    default public BsonElement fromElement(BSONElement element) {
        return new BsonElement(element.name(), this.fromValue(element.value()));
    }

    public Function1<Object, Subtype> codeToBinSubtype();

    public void reactivemongo$api$bson$msb$ValueConverters$_setter_$codeToBinSubtype_$eq(Function1 var1);

    public static BSONBinary toBinary$(ValueConverters $this, BsonBinary bson) {
        return $this.toBinary(bson);
    }

    default public BSONBinary toBinary(BsonBinary bson) {
        return BSONBinary$.MODULE$.apply(bson.getData(), (Subtype)this.codeToBinSubtype().apply((Object)BoxesRunTime.boxToByte((byte)bson.getType())));
    }

    public static BsonBinary fromBinary$(ValueConverters $this, BSONBinary binary) {
        return $this.fromBinary(binary);
    }

    default public BsonBinary fromBinary(BSONBinary binary) {
        return new BsonBinary(this.fromBinarySubtype(binary.subtype()), binary.byteArray());
    }

    public static Subtype toBinarySubtype$(ValueConverters $this, BsonBinarySubType bson) {
        return $this.toBinarySubtype(bson);
    }

    default public Subtype toBinarySubtype(BsonBinarySubType bson) {
        Object object;
        BsonBinarySubType bsonBinarySubType = bson;
        BsonBinarySubType bsonBinarySubType2 = BsonBinarySubType.BINARY;
        BsonBinarySubType bsonBinarySubType3 = bsonBinarySubType;
        if (!(bsonBinarySubType2 != null ? !bsonBinarySubType2.equals(bsonBinarySubType3) : bsonBinarySubType3 != null)) {
            object = Subtype.GenericBinarySubtype$.MODULE$;
        } else {
            BsonBinarySubType bsonBinarySubType4 = BsonBinarySubType.FUNCTION;
            BsonBinarySubType bsonBinarySubType5 = bsonBinarySubType;
            if (!(bsonBinarySubType4 != null ? !bsonBinarySubType4.equals(bsonBinarySubType5) : bsonBinarySubType5 != null)) {
                object = Subtype.FunctionSubtype$.MODULE$;
            } else {
                BsonBinarySubType bsonBinarySubType6 = BsonBinarySubType.OLD_BINARY;
                BsonBinarySubType bsonBinarySubType7 = bsonBinarySubType;
                if (!(bsonBinarySubType6 != null ? !bsonBinarySubType6.equals(bsonBinarySubType7) : bsonBinarySubType7 != null)) {
                    object = Subtype.OldBinarySubtype$.MODULE$;
                } else {
                    BsonBinarySubType bsonBinarySubType8 = BsonBinarySubType.UUID_LEGACY;
                    BsonBinarySubType bsonBinarySubType9 = bsonBinarySubType;
                    if (!(bsonBinarySubType8 != null ? !bsonBinarySubType8.equals(bsonBinarySubType9) : bsonBinarySubType9 != null)) {
                        object = Subtype.OldUuidSubtype$.MODULE$;
                    } else {
                        BsonBinarySubType bsonBinarySubType10 = BsonBinarySubType.UUID_STANDARD;
                        BsonBinarySubType bsonBinarySubType11 = bsonBinarySubType;
                        if (!(bsonBinarySubType10 != null ? !bsonBinarySubType10.equals(bsonBinarySubType11) : bsonBinarySubType11 != null)) {
                            object = Subtype.UuidSubtype$.MODULE$;
                        } else {
                            BsonBinarySubType bsonBinarySubType12 = BsonBinarySubType.MD5;
                            BsonBinarySubType bsonBinarySubType13 = bsonBinarySubType;
                            object = !(bsonBinarySubType12 != null ? !bsonBinarySubType12.equals(bsonBinarySubType13) : bsonBinarySubType13 != null) ? Subtype.Md5Subtype$.MODULE$ : Subtype.UserDefinedSubtype$.MODULE$;
                        }
                    }
                }
            }
        }
        return (Subtype)object;
    }

    public static BsonBinarySubType fromBinarySubtype$(ValueConverters $this, Subtype subtype) {
        return $this.fromBinarySubtype(subtype);
    }

    default public BsonBinarySubType fromBinarySubtype(Subtype subtype) {
        Subtype subtype2 = subtype;
        if (subtype2 instanceof Subtype.GenericBinarySubtype) {
            return BsonBinarySubType.BINARY;
        }
        if (subtype2 instanceof Subtype.FunctionSubtype) {
            return BsonBinarySubType.FUNCTION;
        }
        if (subtype2 instanceof Subtype.OldBinarySubtype) {
            return BsonBinarySubType.OLD_BINARY;
        }
        if (subtype2 instanceof Subtype.OldUuidSubtype) {
            return BsonBinarySubType.UUID_LEGACY;
        }
        if (subtype2 instanceof Subtype.UuidSubtype) {
            return BsonBinarySubType.UUID_STANDARD;
        }
        if (subtype2 instanceof Subtype.Md5Subtype) {
            return BsonBinarySubType.MD5;
        }
        return BsonBinarySubType.USER_DEFINED;
    }

    public static BSONDouble toDouble$(ValueConverters $this, BsonDouble bson) {
        return $this.toDouble(bson);
    }

    default public BSONDouble toDouble(BsonDouble bson) {
        return BSONDouble$.MODULE$.apply(bson.getValue());
    }

    public static BsonDouble fromDouble$(ValueConverters $this, BSONDouble bSONDouble) {
        return $this.fromDouble(bSONDouble);
    }

    default public BsonDouble fromDouble(BSONDouble bSONDouble) {
        return new BsonDouble(bSONDouble.value());
    }

    public static BSONString toStr$(ValueConverters $this, BsonString bson) {
        return $this.toStr(bson);
    }

    default public BSONString toStr(BsonString bson) {
        return BSONString$.MODULE$.apply(bson.getValue());
    }

    public static BsonString fromStr$(ValueConverters $this, BSONString string) {
        return $this.fromStr(string);
    }

    default public BsonString fromStr(BSONString string) {
        return new BsonString(string.value());
    }

    public static BSONBoolean toBoolean$(ValueConverters $this, BsonBoolean bson) {
        return $this.toBoolean(bson);
    }

    default public BSONBoolean toBoolean(BsonBoolean bson) {
        return BSONBoolean$.MODULE$.apply(bson.getValue());
    }

    public static BsonBoolean fromBoolean$(ValueConverters $this, BSONBoolean bSONBoolean) {
        return $this.fromBoolean(bSONBoolean);
    }

    default public BsonBoolean fromBoolean(BSONBoolean bSONBoolean) {
        if (bSONBoolean.value()) {
            return BsonBoolean.TRUE;
        }
        return BsonBoolean.FALSE;
    }

    public static BSONInteger toInteger$(ValueConverters $this, BsonInt32 bson) {
        return $this.toInteger(bson);
    }

    default public BSONInteger toInteger(BsonInt32 bson) {
        return BSONInteger$.MODULE$.apply(bson.getValue());
    }

    public static BsonInt32 fromInteger$(ValueConverters $this, BSONInteger integer) {
        return $this.fromInteger(integer);
    }

    default public BsonInt32 fromInteger(BSONInteger integer) {
        return new BsonInt32(integer.value());
    }

    public static BSONLong toLong$(ValueConverters $this, BsonInt64 bson) {
        return $this.toLong(bson);
    }

    default public BSONLong toLong(BsonInt64 bson) {
        return BSONLong$.MODULE$.apply(bson.getValue());
    }

    public static BsonInt64 fromLong$(ValueConverters $this, BSONLong bSONLong) {
        return $this.fromLong(bSONLong);
    }

    default public BsonInt64 fromLong(BSONLong bSONLong) {
        return new BsonInt64(bSONLong.value());
    }

    public static BSONJavaScript toJavaScript$(ValueConverters $this, BsonJavaScript bson) {
        return $this.toJavaScript(bson);
    }

    default public BSONJavaScript toJavaScript(BsonJavaScript bson) {
        return BSONJavaScript$.MODULE$.apply(bson.getCode());
    }

    public static BsonJavaScript fromJavaScript$(ValueConverters $this, BSONJavaScript javaScript) {
        return $this.fromJavaScript(javaScript);
    }

    default public BsonJavaScript fromJavaScript(BSONJavaScript javaScript) {
        return new BsonJavaScript(javaScript.value());
    }

    public static BSONJavaScriptWS toJavaScriptWS$(ValueConverters $this, BsonJavaScriptWithScope bson) {
        return $this.toJavaScriptWS(bson);
    }

    default public BSONJavaScriptWS toJavaScriptWS(BsonJavaScriptWithScope bson) {
        return BSONJavaScriptWS$.MODULE$.apply(bson.getCode(), this.toDocument(bson.getScope()));
    }

    public static BsonJavaScriptWithScope fromJavaScriptWS$(ValueConverters $this, BSONJavaScriptWS js) {
        return $this.fromJavaScriptWS(js);
    }

    default public BsonJavaScriptWithScope fromJavaScriptWS(BSONJavaScriptWS js) {
        return new BsonJavaScriptWithScope(js.value(), this.fromDocument(js.scope()));
    }

    public static BSONRegex toRegex$(ValueConverters $this, BsonRegularExpression bson) {
        return $this.toRegex(bson);
    }

    default public BSONRegex toRegex(BsonRegularExpression bson) {
        return BSONRegex$.MODULE$.apply(bson.getPattern(), bson.getOptions());
    }

    public static BsonRegularExpression fromRegex$(ValueConverters $this, BSONRegex regex) {
        return $this.fromRegex(regex);
    }

    default public BsonRegularExpression fromRegex(BSONRegex regex) {
        return new BsonRegularExpression(regex.value(), regex.flags());
    }

    public static BSONSymbol toSymbol$(ValueConverters $this, BsonSymbol bson) {
        return $this.toSymbol(bson);
    }

    default public BSONSymbol toSymbol(BsonSymbol bson) {
        return BSONSymbol$.MODULE$.apply(bson.getSymbol());
    }

    public static BsonSymbol fromSymbol$(ValueConverters $this, BSONSymbol symbol) {
        return $this.fromSymbol(symbol);
    }

    default public BsonSymbol fromSymbol(BSONSymbol symbol) {
        return new BsonSymbol(symbol.value());
    }

    public static BSONObjectID toObjectID$(ValueConverters $this, BsonObjectId boid) {
        return $this.toObjectID(boid);
    }

    default public BSONObjectID toObjectID(BsonObjectId boid) {
        return this.toObjectID(boid.getValue());
    }

    public static BSONObjectID toObjectID$(ValueConverters $this, ObjectId boid) {
        return $this.toObjectID(boid);
    }

    default public BSONObjectID toObjectID(ObjectId boid) {
        Try try_ = BSONObjectID$.MODULE$.parse(boid.toByteArray());
        if (try_ instanceof Success) {
            BSONObjectID oid = (BSONObjectID)((Success)try_).value();
            return oid;
        }
        if (try_ instanceof Failure) {
            Throwable err = ((Failure)try_).exception();
            throw err;
        }
        throw new MatchError((Object)try_);
    }

    public static BsonObjectId fromObjectID$(ValueConverters $this, BSONObjectID oid) {
        return $this.fromObjectID(oid);
    }

    default public BsonObjectId fromObjectID(BSONObjectID oid) {
        return new BsonObjectId(new ObjectId(oid.byteArray()));
    }

    public static BSONDateTime toDateTime$(ValueConverters $this, BsonDateTime bson) {
        return $this.toDateTime(bson);
    }

    default public BSONDateTime toDateTime(BsonDateTime bson) {
        return BSONDateTime$.MODULE$.apply(bson.getValue());
    }

    public static BsonDateTime fromDateTime$(ValueConverters $this, BSONDateTime dateTime) {
        return $this.fromDateTime(dateTime);
    }

    default public BsonDateTime fromDateTime(BSONDateTime dateTime) {
        return new BsonDateTime(dateTime.value());
    }

    public static BSONTimestamp toTimestamp$(ValueConverters $this, BsonTimestamp bson) {
        return $this.toTimestamp(bson);
    }

    default public BSONTimestamp toTimestamp(BsonTimestamp bson) {
        return BSONTimestamp$.MODULE$.apply(bson.getValue());
    }

    public static BsonTimestamp fromTimestamp$(ValueConverters $this, BSONTimestamp timestamp) {
        return $this.fromTimestamp(timestamp);
    }

    default public BsonTimestamp fromTimestamp(BSONTimestamp timestamp) {
        return new BsonTimestamp(timestamp.value());
    }

    public static BSONDecimal toDecimal$(ValueConverters $this, BsonDecimal128 bson) {
        return $this.toDecimal(bson);
    }

    default public BSONDecimal toDecimal(BsonDecimal128 bson) {
        return this.toDecimal(bson.getValue());
    }

    public static BSONDecimal toDecimal$(ValueConverters $this, Decimal128 dec) {
        return $this.toDecimal(dec);
    }

    default public BSONDecimal toDecimal(Decimal128 dec) {
        return BSONDecimal$.MODULE$.apply(dec.getHigh(), dec.getLow());
    }

    public static BsonDecimal128 fromDecimal$(ValueConverters $this, BSONDecimal decimal) {
        return $this.fromDecimal(decimal);
    }

    default public BsonDecimal128 fromDecimal(BSONDecimal decimal) {
        return new BsonDecimal128(Decimal128.fromIEEE754BIDEncoding((long)decimal.high(), (long)decimal.low()));
    }

    private static /* synthetic */ Subtype $init$$$anonfun$1(byte BinaryCode$1, byte FunctionCode$1, byte OldBinaryCode$1, byte UuidLegacyCode$1, byte UuidCode$1, byte Md5Code$1, byte _$1) {
        byte by = _$1;
        return (Subtype)(BinaryCode$1 == by ? Subtype.GenericBinarySubtype$.MODULE$ : (FunctionCode$1 == by ? Subtype.FunctionSubtype$.MODULE$ : (OldBinaryCode$1 == by ? Subtype.OldBinarySubtype$.MODULE$ : (UuidLegacyCode$1 == by ? Subtype.OldUuidSubtype$.MODULE$ : (UuidCode$1 == by ? Subtype.UuidSubtype$.MODULE$ : (Md5Code$1 == by ? Subtype.Md5Subtype$.MODULE$ : Subtype.UserDefinedSubtype$.MODULE$))))));
    }
}

