/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.impl.config.props;

import java.beans.ConstructorProperties;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.reactivecommons.async.impl.config.IBrokerConfigProps;
import org.reactivecommons.async.impl.config.props.AsyncProps;
import org.reactivecommons.async.impl.utils.NameGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BrokerConfigProps
implements IBrokerConfigProps {
    @Value(value="${spring.application.name}")
    private String appName;
    private final AsyncProps asyncProps;
    private final AtomicReference<String> replyQueueName = new AtomicReference();

    public String getEventsQueue() {
        return this.appName + ".subsEvents";
    }

    public String getQueriesQueue() {
        return this.appName + ".query";
    }

    public String getCommandsQueue() {
        return this.appName;
    }

    public String getReplyQueue() {
        String name = this.replyQueueName.get();
        if (name == null) {
            String replyName = NameGenerator.generateNameFrom((String)this.appName);
            if (this.replyQueueName.compareAndSet(null, replyName)) {
                return replyName;
            }
            return this.replyQueueName.get();
        }
        return name;
    }

    public String getDomainEventsExchangeName() {
        return this.asyncProps.getDomain().getEvents().getExchange();
    }

    public String getDirectMessagesExchangeName() {
        return this.asyncProps.getDirect().getExchange();
    }

    @Generated
    public String getAppName() {
        return this.appName;
    }

    @Generated
    public AsyncProps getAsyncProps() {
        return this.asyncProps;
    }

    @Generated
    public AtomicReference<String> getReplyQueueName() {
        return this.replyQueueName;
    }

    @ConstructorProperties(value={"asyncProps"})
    @Generated
    public BrokerConfigProps(AsyncProps asyncProps) {
        this.asyncProps = asyncProps;
    }
}

