/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.impl.config;

import org.reactivecommons.api.domain.DomainEventBus;
import org.reactivecommons.async.impl.RabbitDomainEventBus;
import org.reactivecommons.async.impl.communications.ReactiveMessageSender;
import org.reactivecommons.async.impl.config.BrokerConfig;
import org.reactivecommons.async.impl.config.RabbitMqConfig;
import org.reactivecommons.async.impl.config.props.BrokerConfigProps;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import reactor.rabbitmq.ExchangeSpecification;

@Configuration
@Import(value={RabbitMqConfig.class})
public class EventBusConfig {
    @Bean
    public DomainEventBus domainEventBus(ReactiveMessageSender sender, BrokerConfigProps props, BrokerConfig config) {
        String exchangeName = props.getDomainEventsExchangeName();
        sender.getTopologyCreator().declare(ExchangeSpecification.exchange((String)exchangeName).durable(true).type("topic")).subscribe();
        return new RabbitDomainEventBus(sender, exchangeName, config);
    }
}

