/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.impl.config;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.reactivecommons.async.impl.RabbitDirectAsyncGateway;
import org.reactivecommons.async.impl.communications.ReactiveMessageListener;
import org.reactivecommons.async.impl.communications.ReactiveMessageSender;
import org.reactivecommons.async.impl.config.BrokerConfig;
import org.reactivecommons.async.impl.config.RabbitMqConfig;
import org.reactivecommons.async.impl.config.props.BrokerConfigProps;
import org.reactivecommons.async.impl.converters.MessageConverter;
import org.reactivecommons.async.impl.listeners.ApplicationReplyListener;
import org.reactivecommons.async.impl.reply.ReactiveReplyRouter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={RabbitMqConfig.class})
public class DirectAsyncGatewayConfig {
    private final BrokerConfigProps props;

    @Bean
    public RabbitDirectAsyncGateway rabbitDirectAsyncGateway(BrokerConfig config, ReactiveReplyRouter router, ReactiveMessageSender rSender, MessageConverter converter) throws Exception {
        return new RabbitDirectAsyncGateway(config, router, rSender, this.props.getDirectMessagesExchangeName(), converter);
    }

    @Bean
    public ApplicationReplyListener msgListener(ReactiveReplyRouter router, BrokerConfig config, ReactiveMessageListener listener) {
        ApplicationReplyListener replyListener = new ApplicationReplyListener(router, listener, this.props.getReplyQueue());
        replyListener.startListening(config.getRoutingKey());
        return replyListener;
    }

    @Bean
    public ReactiveReplyRouter router() {
        return new ReactiveReplyRouter();
    }

    @ConstructorProperties(value={"props"})
    @Generated
    public DirectAsyncGatewayConfig(BrokerConfigProps props) {
        this.props = props;
    }
}

