/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.api;

import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.reactivecommons.async.api.handlers.CommandHandler;
import org.reactivecommons.async.api.handlers.EventHandler;
import org.reactivecommons.async.api.handlers.QueryHandler;
import org.reactivecommons.async.api.handlers.registered.RegisteredCommandHandler;
import org.reactivecommons.async.api.handlers.registered.RegisteredEventListener;
import org.reactivecommons.async.api.handlers.registered.RegisteredQueryHandler;

public class HandlerRegistry {
    private final List<RegisteredQueryHandler<?, ?>> handlers = new CopyOnWriteArrayList();
    private final List<RegisteredEventListener> eventListeners = new CopyOnWriteArrayList<RegisteredEventListener>();
    private final List<RegisteredCommandHandler> commandHandlers = new CopyOnWriteArrayList<RegisteredCommandHandler>();
    private final List<RegisteredEventListener> eventNotificationListener = new CopyOnWriteArrayList<RegisteredEventListener>();

    public static HandlerRegistry register() {
        return new HandlerRegistry();
    }

    public <T> HandlerRegistry listenEvent(String eventName, EventHandler<T> fn, Class<T> eventClass) {
        this.eventListeners.add(new RegisteredEventListener<T>(eventName, fn, eventClass));
        return this;
    }

    public <T> HandlerRegistry listenEvent(String eventName, EventHandler<T> handler) {
        this.eventListeners.add(new RegisteredEventListener<T>(eventName, handler, this.inferGenericParameterType(handler)));
        return this;
    }

    public <T> HandlerRegistry listenNotificationEvent(String eventName, EventHandler<T> fn, Class<T> eventClass) {
        this.eventNotificationListener.add(new RegisteredEventListener<T>(eventName, fn, eventClass));
        return this;
    }

    public <T> HandlerRegistry handleCommand(String commandName, CommandHandler<T> fn, Class<T> commandClass) {
        this.commandHandlers.add(new RegisteredCommandHandler<T>(commandName, fn, commandClass));
        return this;
    }

    public <T> HandlerRegistry handleCommand(String commandName, CommandHandler<T> fn) {
        this.commandHandlers.add(new RegisteredCommandHandler<T>(commandName, fn, this.inferGenericParameterType(fn)));
        return this;
    }

    public <T, R> HandlerRegistry serveQuery(String resource, QueryHandler<T, R> handler) {
        return this.serveQuery(resource, handler, this.inferGenericParameterType(handler));
    }

    public <T, R> HandlerRegistry serveQuery(String resource, QueryHandler<T, R> handler, Class<R> queryClass) {
        this.handlers.add(new RegisteredQueryHandler<T, R>(resource, handler, queryClass));
        return this;
    }

    private <T, R> Class<R> inferGenericParameterType(QueryHandler<T, R> handler) {
        try {
            ParameterizedType genericSuperclass = (ParameterizedType)handler.getClass().getGenericInterfaces()[0];
            return (Class)genericSuperclass.getActualTypeArguments()[1];
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to infer generic Query class, please use serveQuery(path, handler, class) instead");
        }
    }

    private <T> Class<T> inferGenericParameterType(CommandHandler<T> handler) {
        try {
            ParameterizedType genericSuperclass = (ParameterizedType)handler.getClass().getGenericInterfaces()[0];
            return (Class)genericSuperclass.getActualTypeArguments()[0];
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to infer generic Command class, please use handleCommand(path, handler, class) instead");
        }
    }

    private <T> Class<T> inferGenericParameterType(EventHandler<T> handler) {
        try {
            ParameterizedType genericSuperclass = (ParameterizedType)handler.getClass().getGenericInterfaces()[0];
            return (Class)genericSuperclass.getActualTypeArguments()[0];
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to infer generic Query class, please use listenEvent(eventName, handler, class) instead");
        }
    }

    @Generated
    public List<RegisteredQueryHandler<?, ?>> getHandlers() {
        return this.handlers;
    }

    @Generated
    public List<RegisteredEventListener> getEventListeners() {
        return this.eventListeners;
    }

    @Generated
    public List<RegisteredCommandHandler> getCommandHandlers() {
        return this.commandHandlers;
    }

    @Generated
    public List<RegisteredEventListener> getEventNotificationListener() {
        return this.eventNotificationListener;
    }

    @Generated
    HandlerRegistry() {
    }
}

