/*
 * Decompiled with CFR 0.152.
 */
package org.stdg.dbtype;

import javax.sql.DataSource;
import org.stdg.ReferencedTableSet;
import org.stdg.ReferencedTablesFinder;
import org.stdg.SqlQuery;
import org.stdg.dbtype.BaseReferencedTablesFinder;

class PostgreSqlMariaDbReferencedTablesFinder
implements ReferencedTablesFinder {
    private static final SqlQuery REFERENCED_TABLES_QUERY = new SqlQuery("with \n    recursive parent_child_tree as\n    (\n    with parent_child as\n        (\n        select distinct\n            child.table_schema  as table_schema,\n            child.table_name    as table_name,\n            parent.table_schema as ref_table_schema,\n            parent.table_name   as ref_table_name\n        from information_schema.referential_constraints rco\n        join information_schema.table_constraints child\n             on rco.constraint_name = child.constraint_name\n             and rco.constraint_schema = child.table_schema\n        join information_schema.table_constraints parent\n             on rco.unique_constraint_name = parent.constraint_name\n             and rco.unique_constraint_schema = parent.table_schema\n        where child.table_name != parent.table_name\n        )\n    select table_name, ref_table_name, 1 as level\n      from parent_child\n     where table_name=?\n    UNION\n    select pc.table_name, pc.ref_table_name, pct.level + 1 as level\n      from parent_child_tree pct\n      join parent_child pc on (pc.table_name = pct.ref_table_name)\n    )\nselect *\nfrom parent_child_tree\norder by level desc");
    private final BaseReferencedTablesFinder referencedTablesFinder;

    PostgreSqlMariaDbReferencedTablesFinder(DataSource dataSource) {
        this.referencedTablesFinder = new BaseReferencedTablesFinder(dataSource, REFERENCED_TABLES_QUERY);
    }

    @Override
    public ReferencedTableSet findReferencedTablesOf(String tableName) {
        return this.referencedTablesFinder.findReferencedTablesOf(tableName);
    }
}

