/*
 * Decompiled with CFR 0.152.
 */
package org.stdg.dbtype;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.stdg.ColumnsMappingGroup;
import org.stdg.DatabaseMetadataFinder;
import org.stdg.NotNullColumnsFinder;
import org.stdg.PrimaryKeyColumnsFinder;
import org.stdg.ReferencedTableSet;
import org.stdg.SqlQuery;
import org.stdg.dbtype.BaseColumnsMappingsFinder;
import org.stdg.dbtype.DefaultColumnOrdersFinder;
import org.stdg.dbtype.DefaultNotNullColumnsFinder;
import org.stdg.dbtype.DefaultPrimaryKeyColumnsFinder;
import org.stdg.dbtype.PostgreSqlMariaDbReferencedTablesFinder;

class MariaDBMySQLMetadataFinder
implements DatabaseMetadataFinder {
    private static final SqlQuery MARIA_DB_MY_SQL_COLUMNS_MAPPINGS_QUERY = new SqlQuery("select\n       child_constraint.table_schema            as table_schema,\n       child_constraint.table_name              as table_name,\n       child_cons_cols.column_name              as column_name,\n       child_cons_cols.referenced_table_schema  as ref_table_schema,\n       child_cons_cols.referenced_table_name    as ref_table_name,\n       child_cons_cols.referenced_column_name   as ref_column_name\n  from information_schema.table_constraints as child_constraint\n  join information_schema.key_column_usage as child_cons_cols\n       on (child_constraint.constraint_schema = child_cons_cols.constraint_schema\n           and\n           child_constraint.constraint_name = child_cons_cols.constraint_name\n           and\n           child_constraint.table_schema = child_cons_cols.table_schema\n           and\n           child_constraint.table_name = child_cons_cols.table_name)\nwhere child_constraint.constraint_type = 'FOREIGN KEY' and child_constraint.table_name=?");
    private final DefaultColumnOrdersFinder defaultColumnOrdersFinder;
    private final NotNullColumnsFinder defaultNotNullColumnsFinder;
    private final PostgreSqlMariaDbReferencedTablesFinder postgreSqlMariaDbReferencedTablesFinder;
    private final BaseColumnsMappingsFinder mariaDbMySqlColumnsMappingsFinder;
    private final PrimaryKeyColumnsFinder primaryKeyColumnsFinder;

    MariaDBMySQLMetadataFinder(DataSource dataSource) {
        this.defaultColumnOrdersFinder = new DefaultColumnOrdersFinder(dataSource);
        this.defaultNotNullColumnsFinder = new DefaultNotNullColumnsFinder(dataSource);
        this.postgreSqlMariaDbReferencedTablesFinder = new PostgreSqlMariaDbReferencedTablesFinder(dataSource);
        this.mariaDbMySqlColumnsMappingsFinder = new BaseColumnsMappingsFinder(dataSource, MARIA_DB_MY_SQL_COLUMNS_MAPPINGS_QUERY);
        this.primaryKeyColumnsFinder = new DefaultPrimaryKeyColumnsFinder(dataSource);
    }

    @Override
    public List<String> findDatabaseColumnOrdersOf(String tableName) {
        return this.defaultColumnOrdersFinder.findDatabaseColumnOrdersOf(tableName);
    }

    @Override
    public Collection<String> findNotNullColumnsOf(String tableName) {
        return this.defaultNotNullColumnsFinder.findNotNullColumnsOf(tableName);
    }

    @Override
    public ReferencedTableSet findReferencedTablesOf(String tableName) {
        return this.postgreSqlMariaDbReferencedTablesFinder.findReferencedTablesOf(tableName);
    }

    @Override
    public ColumnsMappingGroup findColumnsMappingsOf(String tableName) {
        return this.mariaDbMySqlColumnsMappingsFinder.findColumnsMappingsOf(tableName);
    }

    @Override
    public List<String> findPrimaryColumnsOf(String tableName) {
        return Collections.emptyList();
    }
}

