/*
 * Decompiled with CFR 0.152.
 */
package org.stdg.dbtype;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.stdg.NotNullColumnsFinder;
import org.stdg.PreparedStatementBuilder;
import org.stdg.SqlQuery;

class DefaultNotNullColumnsFinder
implements NotNullColumnsFinder {
    private static final SqlQuery NOT_NULL_COLUMNS_QUERY = new SqlQuery("select table_schema as table_schema,\n       table_name   as table_name,\n       column_name  as not_null_column\nfrom information_schema.columns\nwhere is_nullable = 'NO'\n  AND table_name=?");
    private final DataSource dataSource;

    DefaultNotNullColumnsFinder(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<String> findNotNullColumnsOf(String tableName) {
        try (Connection connection = this.dataSource.getConnection();){
            List<String> list;
            block14: {
                PreparedStatement columnOrderStatement = PreparedStatementBuilder.buildFrom(NOT_NULL_COLUMNS_QUERY, connection);
                try {
                    columnOrderStatement.setString(1, tableName);
                    ResultSet queryResult = columnOrderStatement.executeQuery();
                    list = this.findNotNullColumnsFrom(queryResult);
                    if (columnOrderStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (columnOrderStatement != null) {
                        try {
                            columnOrderStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                columnOrderStatement.close();
            }
            return list;
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
            return Collections.emptyList();
        }
    }

    private List<String> findNotNullColumnsFrom(ResultSet resultSet) throws SQLException {
        ArrayList<String> notNullColumns = new ArrayList<String>();
        while (resultSet.next()) {
            String columnName = resultSet.getString(3);
            notNullColumns.add(columnName);
        }
        return notNullColumns;
    }
}

