/*
 * Decompiled with CFR 0.152.
 */
package org.stdg.dbtype;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.stdg.ColumnOrdersFinder;
import org.stdg.PreparedStatementBuilder;
import org.stdg.SqlQuery;

class DefaultColumnOrdersFinder
implements ColumnOrdersFinder {
    private static final SqlQuery COLUMN_ORDER_QUERY = new SqlQuery(" select table_schema,        table_name,        column_name,        ordinal_position as position from information_schema.columns where table_name=? order by position");
    private final DataSource dataSource;

    DefaultColumnOrdersFinder(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> findDatabaseColumnOrdersOf(String tableName) {
        try (Connection connection = this.dataSource.getConnection();){
            List<String> list;
            block14: {
                PreparedStatement columnOrderStatement = PreparedStatementBuilder.buildFrom(COLUMN_ORDER_QUERY, connection);
                try {
                    columnOrderStatement.setString(1, tableName);
                    ResultSet queryResult = columnOrderStatement.executeQuery();
                    list = this.findColumnOrderFrom(queryResult);
                    if (columnOrderStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (columnOrderStatement != null) {
                        try {
                            columnOrderStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                columnOrderStatement.close();
            }
            return list;
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
            return Collections.emptyList();
        }
    }

    private List<String> findColumnOrderFrom(ResultSet queryResult) throws SQLException {
        ArrayList<String> columnOrder = new ArrayList<String>();
        while (queryResult.next()) {
            String columnName = queryResult.getString(3);
            columnOrder.add(columnName);
        }
        return columnOrder;
    }
}

