/*
 * Decompiled with CFR 0.152.
 */
package org.stdg.dbtype;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.stdg.ColumnsMappingGroup;
import org.stdg.DatabaseMetadataFinder;
import org.stdg.ReferencedTableSet;

public class DatabaseMetadataFinderWithCache
implements DatabaseMetadataFinder {
    private final DatabaseMetadataFinder delegate;
    private final ConcurrentHashMap<String, Collection<String>> notNullColumnsByTableName = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<String>> databaseColumnOrdersByTableName = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ColumnsMappingGroup> columnsMappingsByTableName = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ReferencedTableSet> referencedTableSetByTableName = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<String>> primaryColumnsByTableName = new ConcurrentHashMap();

    public DatabaseMetadataFinderWithCache(DatabaseMetadataFinder delegate) {
        this.delegate = delegate;
    }

    public static DatabaseMetadataFinder buildFrom(DatabaseMetadataFinder databaseMetadataFinder) {
        return new DatabaseMetadataFinderWithCache(databaseMetadataFinder);
    }

    @Override
    public List<String> findDatabaseColumnOrdersOf(String tableName) {
        return this.databaseColumnOrdersByTableName.computeIfAbsent(tableName, t -> this.delegate.findDatabaseColumnOrdersOf(tableName));
    }

    @Override
    public ColumnsMappingGroup findColumnsMappingsOf(String tableName) {
        return this.columnsMappingsByTableName.computeIfAbsent(tableName, t -> this.delegate.findColumnsMappingsOf(tableName));
    }

    @Override
    public Collection<String> findNotNullColumnsOf(String tableName) {
        return this.notNullColumnsByTableName.computeIfAbsent(tableName, t -> this.delegate.findNotNullColumnsOf(tableName));
    }

    @Override
    public ReferencedTableSet findReferencedTablesOf(String tableName) {
        return this.referencedTableSetByTableName.computeIfAbsent(tableName, t -> this.delegate.findReferencedTablesOf(tableName));
    }

    @Override
    public List<String> findPrimaryColumnsOf(String tableName) {
        return this.primaryColumnsByTableName.computeIfAbsent(tableName, t -> this.delegate.findPrimaryColumnsOf(tableName));
    }
}

