/*
 * Decompiled with CFR 0.152.
 */
package org.stdg.dbtype;

import javax.sql.DataSource;
import org.stdg.DatabaseMetadataFinder;
import org.stdg.dbtype.DatabaseType;
import org.stdg.dbtype.DefaultDatabaseMetadataFinder;
import org.stdg.dbtype.H2MetadataFinder;
import org.stdg.dbtype.HsqlDbMetadataFinder;
import org.stdg.dbtype.MSSQLServerMetadataFinder;
import org.stdg.dbtype.MariaDBMySQLMetadataFinder;
import org.stdg.dbtype.OracleMetadataFinder;
import org.stdg.dbtype.PostgreSqlMetadataFinder;

public class DatabaseMetadataFinderFactory {
    private DatabaseMetadataFinderFactory() {
    }

    public static DatabaseMetadataFinder createDatabaseMetadataFinderFrom(DataSource dataSource, DatabaseType dbType) {
        if (dbType.equals((Object)DatabaseType.H2)) {
            return new H2MetadataFinder(dataSource);
        }
        if (dbType.equals((Object)DatabaseType.HSQLDB)) {
            return new HsqlDbMetadataFinder(dataSource);
        }
        if (dbType.equals((Object)DatabaseType.POSTGRE_SQL)) {
            return new PostgreSqlMetadataFinder(dataSource);
        }
        if (dbType.equals((Object)DatabaseType.MARIA_DB) || dbType.equals((Object)DatabaseType.MY_SQL)) {
            return new MariaDBMySQLMetadataFinder(dataSource);
        }
        if (dbType.equals((Object)DatabaseType.MICROSOFT_SQL_SERVER)) {
            return new MSSQLServerMetadataFinder(dataSource);
        }
        if (dbType.equals((Object)DatabaseType.ORACLE)) {
            return new OracleMetadataFinder();
        }
        return new DefaultDatabaseMetadataFinder(dataSource);
    }
}

