/*
 * Decompiled with CFR 0.152.
 */
package org.stdg.dbtype;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.stdg.PreparedStatementBuilder;
import org.stdg.ReferencedTable;
import org.stdg.ReferencedTableSet;
import org.stdg.ReferencedTablesFinder;
import org.stdg.SqlQuery;

class BaseReferencedTablesFinder
implements ReferencedTablesFinder {
    private final DataSource dataSource;
    private final SqlQuery referencedTableQuery;

    BaseReferencedTablesFinder(DataSource dataSource, SqlQuery referencedTableQuery) {
        this.dataSource = dataSource;
        this.referencedTableQuery = referencedTableQuery;
    }

    @Override
    public ReferencedTableSet findReferencedTablesOf(String tableName) {
        ArrayList<ReferencedTable> referencedTables = new ArrayList<ReferencedTable>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement referencedTablesStatement = PreparedStatementBuilder.buildFrom(this.referencedTableQuery, connection);){
            referencedTablesStatement.setString(1, tableName);
            ResultSet queryResult = referencedTablesStatement.executeQuery();
            while (queryResult.next()) {
                ReferencedTable referencedTable = this.buildReferencedTableFrom(queryResult);
                referencedTables.add(referencedTable);
            }
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
        }
        return new ReferencedTableSet(referencedTables);
    }

    private ReferencedTable buildReferencedTableFrom(ResultSet queryResult) throws SQLException {
        String resultTableName = queryResult.getString(1);
        String referencedTableName = queryResult.getString(2);
        int level = queryResult.getInt(3);
        return new ReferencedTable(resultTableName, referencedTableName, level);
    }
}

