/*
 * Decompiled with CFR 0.152.
 */
package org.stdg.dbtype;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.stdg.PreparedStatementBuilder;
import org.stdg.PrimaryKeyColumnsFinder;
import org.stdg.SqlQuery;

class BasePrimaryKeyColumnsFinder
implements PrimaryKeyColumnsFinder {
    private final DataSource dataSource;
    private final SqlQuery primaryKeyColumnsQuery;

    public BasePrimaryKeyColumnsFinder(DataSource dataSource, SqlQuery primaryKeyColumnsQuery) {
        this.dataSource = dataSource;
        this.primaryKeyColumnsQuery = primaryKeyColumnsQuery;
    }

    @Override
    public List<String> findPrimaryColumnsOf(String tableName) {
        ArrayList<String> primaryKeyColumns = new ArrayList<String>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement primaryKeyColumnsStatement = PreparedStatementBuilder.buildFrom(this.primaryKeyColumnsQuery, connection);){
            primaryKeyColumnsStatement.setString(1, tableName);
            ResultSet queryResult = primaryKeyColumnsStatement.executeQuery();
            while (queryResult.next()) {
                String column = queryResult.getString(4);
                primaryKeyColumns.add(column);
            }
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
        }
        return primaryKeyColumns;
    }
}

