/*
 * Decompiled with CFR 0.152.
 */
package org.stdg.dbtype;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.stdg.ColumnMappingPart;
import org.stdg.ColumnsMapping;
import org.stdg.ColumnsMappingGroup;
import org.stdg.ColumnsMappingsFinder;
import org.stdg.PreparedStatementBuilder;
import org.stdg.SqlQuery;

class BaseColumnsMappingsFinder
implements ColumnsMappingsFinder {
    private final DataSource dataSource;
    private final SqlQuery columnsMappingQuery;

    public BaseColumnsMappingsFinder(DataSource dataSource, SqlQuery columnsMappingQuery) {
        this.dataSource = dataSource;
        this.columnsMappingQuery = columnsMappingQuery;
    }

    @Override
    public ColumnsMappingGroup findColumnsMappingsOf(String tableName) {
        ArrayList<ColumnsMapping> columnsMappings = new ArrayList<ColumnsMapping>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement referencedTablesStatement = PreparedStatementBuilder.buildFrom(this.columnsMappingQuery, connection);){
            referencedTablesStatement.setString(1, tableName);
            ResultSet queryResult = referencedTablesStatement.executeQuery();
            while (queryResult.next()) {
                ColumnsMapping columnsMapping = this.buildColumnsMappingFrom(queryResult);
                columnsMappings.add(columnsMapping);
            }
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
        }
        return new ColumnsMappingGroup(columnsMappings);
    }

    private ColumnsMapping buildColumnsMappingFrom(ResultSet queryResult) throws SQLException {
        String firstTableSchema = queryResult.getString(1);
        String firstTableName = queryResult.getString(2);
        String firstTableColumn = queryResult.getString(3);
        ColumnMappingPart columnMappingPart1 = new ColumnMappingPart(firstTableSchema, firstTableName, firstTableColumn);
        String secondTableSchema = queryResult.getString(4);
        String secondTableName = queryResult.getString(5);
        String secondTableColumn = queryResult.getString(6);
        ColumnMappingPart columnMappingPart2 = new ColumnMappingPart(secondTableSchema, secondTableName, secondTableColumn);
        return new ColumnsMapping(columnMappingPart1, columnMappingPart2);
    }
}

