/*
 * Decompiled with CFR 0.152.
 */
package org.stdg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.stdg.DatabaseMetadataFinder;
import org.stdg.DatasetRow;
import org.stdg.DatasetRowsGenerator;
import org.stdg.InsertStatementsGenerator;
import org.stdg.SqlQuery;
import org.stdg.dbtype.DatabaseMetadataFinderFactory;
import org.stdg.dbtype.DatabaseMetadataFinderWithCache;
import org.stdg.dbtype.DatabaseType;
import org.stdg.dbtype.DatabaseUrlFinder;

public class SqlTestDataGenerator {
    private final DatasetRowsGenerator datasetRowsGenerator;

    private SqlTestDataGenerator(DatasetRowsGenerator datasetRowsGenerator) {
        this.datasetRowsGenerator = datasetRowsGenerator;
    }

    public static SqlTestDataGenerator buildFrom(DataSource dataSource) {
        String dbUrl = DatabaseUrlFinder.findDbUrlFrom(dataSource);
        DatabaseType dbType = DatabaseType.findFromDbUrl(dbUrl);
        DatabaseMetadataFinder databaseMetadataFinder = DatabaseMetadataFinderFactory.createDatabaseMetadataFinderFrom(dataSource, dbType);
        DatabaseMetadataFinder databaseMetadataFinderWithCache = DatabaseMetadataFinderWithCache.buildFrom(databaseMetadataFinder);
        return SqlTestDataGenerator.buildFrom(dataSource, databaseMetadataFinderWithCache);
    }

    public static SqlTestDataGenerator buildFrom(DataSource dataSource, DatabaseMetadataFinder databaseMetadataFinder) {
        DatasetRowsGenerator datasetRowsGenerator = new DatasetRowsGenerator(dataSource, databaseMetadataFinder);
        return new SqlTestDataGenerator(datasetRowsGenerator);
    }

    public String generateInsertScriptFor(String sqlQuery) {
        return this.generateInsertScriptFor(sqlQuery, Collections.emptyList());
    }

    public String generateInsertScriptFor(String query, List<Object> parameters) {
        List<SqlQuery> sqlQueries = Collections.singletonList(new SqlQuery(query, parameters));
        return this.generateInsertScriptFor(sqlQueries);
    }

    public String generateInsertScriptFor(List<SqlQuery> sqlQueries) {
        List<DatasetRow> datasetRows = this.datasetRowsGenerator.generateDatasetRowsFor(sqlQueries);
        return InsertStatementsGenerator.INSTANCE.generateInsertScriptFor(datasetRows);
    }

    public String generateInsertScriptFor(String ... sqlQueries) {
        List<SqlQuery> queries = Arrays.stream(sqlQueries).map(SqlQuery::new).collect(Collectors.toList());
        return this.generateInsertScriptFor(queries);
    }

    public List<String> generateInsertListFor(DatasetRow datasetRow) {
        SqlQuery sqlQuery = SqlQuery.buildFromRow(datasetRow);
        return this.generateInsertListFor(sqlQuery.toString());
    }

    public List<String> generateInsertListFor(String ... sqlQueries) {
        List<SqlQuery> sqlQueryObjects = Arrays.stream(sqlQueries).map(SqlQuery::new).collect(Collectors.toList());
        List<DatasetRow> datasetRows = this.datasetRowsGenerator.generateDatasetRowsFor(sqlQueryObjects);
        return InsertStatementsGenerator.INSTANCE.generateInsertStatementsFor(datasetRows);
    }
}

