/*
 * Decompiled with CFR 0.152.
 */
package org.stdg;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;
import org.stdg.DatasetRow;
import org.stdg.PreparedStatementBuilder;
import org.stdg.SqlQuery;

class RowFinder {
    private final DataSource dataSource;

    RowFinder(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    DatasetRow findOneRowFrom(String tableName, Collection<String> columnNamesToSearch, DatasetRow rowToSearch) {
        SqlQuery missingColumnValuesQuery = SqlQuery.buildFromRow(columnNamesToSearch, rowToSearch);
        DatasetRow missingColumnValues = DatasetRow.ofTable(tableName);
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement missingColumnStatement = PreparedStatementBuilder.buildFrom(missingColumnValuesQuery, connection);){
            ResultSet queryResult = missingColumnStatement.executeQuery();
            queryResult.next();
            for (String missingColumnName : columnNamesToSearch) {
                Object columnValue = queryResult.getObject(missingColumnName);
                missingColumnValues.addColumnValue(missingColumnName, columnValue);
            }
        }
        catch (SQLException sqlException) {
            System.err.println("Unable to execute " + missingColumnValuesQuery);
            sqlException.printStackTrace();
        }
        return missingColumnValues;
    }
}

