/*
 * Decompiled with CFR 0.152.
 */
package org.stdg;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.stdg.DatabaseMetadataFinder;
import org.stdg.DatasetRow;
import org.stdg.RowFinder;

class MissingNotNullColumnsFinder {
    private final DataSource dataSource;
    private final DatabaseMetadataFinder databaseMetadataFinder;

    MissingNotNullColumnsFinder(DataSource dataSource, DatabaseMetadataFinder databaseMetadataFinder) {
        this.dataSource = dataSource;
        this.databaseMetadataFinder = databaseMetadataFinder;
    }

    Map<String, Object> findMissingNoNullColumnsOf(DatasetRow datasetRow) {
        String tableName = datasetRow.getTableName();
        Collection<String> notNullColumns = this.databaseMetadataFinder.findNotNullColumnsOf(tableName);
        Collection missingNotNullColumns = notNullColumns.stream().filter(columnName -> !datasetRow.hasNotNullValueForColumn((String)columnName)).collect(Collectors.toList());
        if (!missingNotNullColumns.isEmpty()) {
            RowFinder rowFinder = new RowFinder(this.dataSource);
            DatasetRow datasetRowWithMissingNotNullColumns = rowFinder.findOneRowFrom(datasetRow.getTableName(), missingNotNullColumns, datasetRow);
            return datasetRowWithMissingNotNullColumns.getColumnValueByColumnName();
        }
        return Collections.emptyMap();
    }
}

