/*
 * Decompiled with CFR 0.152.
 */
package org.stdg;

import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.statement.delete.Delete;
import org.stdg.SelectTransformer;
import org.stdg.SqlQuery;

class DeleteToSelectTransformer
implements SelectTransformer {
    private Delete deleteStatement;

    DeleteToSelectTransformer(Delete delete) {
        this.deleteStatement = delete;
    }

    @Override
    public Optional<SqlQuery> toSelect(SqlQuery sqlQuery) {
        String deleteAsString = sqlQuery.getQueryAsString();
        String deleteString = this.toSelect(deleteAsString);
        SqlQuery deleteQuery = new SqlQuery(deleteString);
        return Optional.of(deleteQuery);
    }

    private String toSelect(String sqlQueryAsString) {
        String tableName = this.deleteStatement.getTable().getName();
        String whereClauseAsString = this.findWhereClauseAsString();
        return " SELECT * FROM " + tableName + whereClauseAsString;
    }

    private String findWhereClauseAsString() {
        Expression whereExpression = this.deleteStatement.getWhere();
        String whereClauseAsString = whereExpression == null ? "" : " WHERE " + whereExpression;
        return whereClauseAsString;
    }
}

