/*
 * Decompiled with CFR 0.152.
 */
package org.stdg;

import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.stdg.DatabaseMetadataFinder;
import org.stdg.DatasetRow;
import org.stdg.DatasetRowSet;
import org.stdg.DatasetRowsFinder;
import org.stdg.SqlQuery;

class DatasetRowsGenerator {
    private final DataSource dataSource;
    private final DatabaseMetadataFinder databaseMetadataFinder;
    private final DatasetRowsFinder datasetRowsFinder;

    DatasetRowsGenerator(DataSource dataSource, DatabaseMetadataFinder databaseMetadataFinder) {
        this.dataSource = dataSource;
        this.databaseMetadataFinder = databaseMetadataFinder;
        this.datasetRowsFinder = new DatasetRowsFinder(dataSource);
    }

    List<DatasetRow> generateDatasetRowsFor(List<SqlQuery> sqlQueries) {
        DatasetRowSet datasetRowSet = new DatasetRowSet(this.dataSource, this.databaseMetadataFinder);
        for (SqlQuery sqlQuery : sqlQueries) {
            Collection<DatasetRow> datasetRows = this.datasetRowsFinder.findDatasetRowsOf(sqlQuery);
            datasetRowSet.add(datasetRows);
        }
        return datasetRowSet.sort();
    }
}

