/*
 * Decompiled with CFR 0.152.
 */
package org.stdg;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.stdg.ColumnsMappingGroup;
import org.stdg.DatabaseMetadataFinder;
import org.stdg.DatasetRow;
import org.stdg.DatasetRowComparatorBuilder;
import org.stdg.MissingNotNullColumnsFinder;

class DatasetRowSet {
    private final MissingNotNullColumnsFinder missingNotNullColumnsFinder;
    private final DatabaseMetadataFinder databaseMetadataFinder;
    private final Collection<DatasetRow> datasetRows = new ArrayDeque<DatasetRow>();

    DatasetRowSet(DataSource dataSource, DatabaseMetadataFinder databaseMetadataFinder) {
        this.databaseMetadataFinder = databaseMetadataFinder;
        this.missingNotNullColumnsFinder = new MissingNotNullColumnsFinder(dataSource, databaseMetadataFinder);
    }

    void add(Collection<DatasetRow> datasetRows) {
        for (DatasetRow datasetRow : datasetRows) {
            this.add(datasetRow);
        }
    }

    private void add(DatasetRow datasetRow) {
        boolean rowIsMerged = datasetRow.mergeWithARowOf(this.datasetRows);
        if (!rowIsMerged) {
            Map<String, Object> missingNotNullColumns = this.missingNotNullColumnsFinder.findMissingNoNullColumnsOf(datasetRow);
            datasetRow.addColumnValues(missingNotNullColumns);
            this.datasetRows.add(datasetRow);
            Collection<DatasetRow> joinedRows = this.findJoinedRowsOf(datasetRow);
            for (DatasetRow joinRow : joinedRows) {
                this.add(joinRow);
            }
        }
    }

    private Collection<DatasetRow> findJoinedRowsOf(DatasetRow datasetRow) {
        String tableName = datasetRow.getTableName();
        ColumnsMappingGroup columnsMappingGroup = this.databaseMetadataFinder.findColumnsMappingsOf(tableName);
        return datasetRow.extractJoinedRowsFrom(columnsMappingGroup);
    }

    List<DatasetRow> sort() {
        this.sortColumnsFollowingDatabaseDeclaration(this.datasetRows);
        return this.sortRows();
    }

    private void sortColumnsFollowingDatabaseDeclaration(Collection<DatasetRow> allRows) {
        for (DatasetRow datasetRow : allRows) {
            String tableName = datasetRow.getTableName();
            List<String> databaseColumnOrders = this.databaseMetadataFinder.findDatabaseColumnOrdersOf(tableName);
            datasetRow.sortColumnsFollowing(databaseColumnOrders);
        }
    }

    private List<DatasetRow> sortRows() {
        ArrayList<DatasetRow> rowsAsList = new ArrayList<DatasetRow>(this.datasetRows);
        Comparator<DatasetRow> datasetRowComparator = DatasetRowComparatorBuilder.buildFrom(this.databaseMetadataFinder);
        rowsAsList.sort(datasetRowComparator);
        return rowsAsList;
    }
}

