/*
 * Decompiled with CFR 0.152.
 */
package org.stdg;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ColumnNamesComparator
implements Comparator<String> {
    private final Map<String, Integer> positionByColumnName;

    private ColumnNamesComparator(Map<String, Integer> positionByColumnName) {
        this.positionByColumnName = positionByColumnName;
    }

    public static ColumnNamesComparator from(List<String> orderedColumns) {
        Map<String, Integer> positionByColumnName = ColumnNamesComparator.buildIndexByColumnName(orderedColumns);
        return new ColumnNamesComparator(positionByColumnName);
    }

    private static Map<String, Integer> buildIndexByColumnName(List<String> orderedColumns) {
        HashMap<String, Integer> positionByColumnName = new HashMap<String, Integer>();
        for (int i = 0; i < orderedColumns.size(); ++i) {
            positionByColumnName.put(orderedColumns.get(i), i + 1);
        }
        return positionByColumnName;
    }

    @Override
    public int compare(String colName1, String colName2) {
        return this.findPositionOf(colName1) - this.findPositionOf(colName2);
    }

    private int findPositionOf(String colName1) {
        return this.positionByColumnName.get(colName1);
    }
}

