/*
 * Decompiled with CFR 0.152.
 */
package org.quickapi.mail;

import java.io.Closeable;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.quickapi.annotation.DebugLog;
import org.quickapi.core.Logger;

public class SMTPMail
implements Closeable {
    private int executorCount = 20;
    private String host;
    private String username;
    private String password;
    private ExecutorService executor;
    private Logger log = new Logger();

    public static SMTPMail defaultInstance() {
        return Instance.INSTANCE.mail;
    }

    public SMTPMail() {
        this.executor = Executors.newFixedThreadPool(this.executorCount);
        this.log.setDebugMode(true);
    }

    public SMTPMail(int executorCount, String host, String username, String password) {
        this();
        this.executorCount = executorCount;
        this.host = host;
        this.username = username;
        this.password = password;
    }

    public void setExecutor(int executorCount) {
        this.executorCount = executorCount;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDebug(boolean debug) {
        this.log.setDebugMode(debug);
    }

    public Task create(String subject, String content) {
        return new Task(subject, content);
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
    }

    public static enum Instance {
        INSTANCE(new SMTPMail());

        final SMTPMail mail;

        private Instance(SMTPMail mail) {
            this.mail = mail;
        }
    }

    public static interface Success {
        public void onSuccess(Task var1, String ... var2);
    }

    public static interface Fail {
        public void onFail(Task var1, Exception var2, String ... var3);
    }

    @DebugLog
    public class Task {
        public String content;
        public String subject;
        public String[] target;
        private Success success;
        private Fail fail;

        public Task(String subject, String content) {
            this.subject = subject;
            this.content = content;
        }

        public Task success(Success success) {
            this.success = success;
            return this;
        }

        public Task fail(Fail fail) {
            this.fail = fail;
            return this;
        }

        public void syncSend(String ... target) throws MessagingException {
            this.target = target;
            InternetAddress[] targetAddress = this.createReceiver();
            SMTPMail.this.log.d((Object)"\u540c\u6b65\u53d1\u9001\u90ae\u4ef6:", new Object[0]);
            Transport.send((Message)this.createMessage(), (Address[])targetAddress);
            SMTPMail.this.log.d((Object)"+\u90ae\u4ef6\u53d1\u9001\u6210\u529f+", new Object[0]);
        }

        public void asyncSend(String ... target) {
            this.target = target;
            SMTPMail.this.executor.submit(() -> {
                block3: {
                    InternetAddress[] targetAddress = this.createReceiver();
                    String[] receiver = (String[])Stream.of(targetAddress).map(InternetAddress::getAddress).toArray(String[]::new);
                    try {
                        SMTPMail.this.log.d((Object)"\u5f02\u6b65\u53d1\u9001\u90ae\u4ef6:", new Object[0]);
                        SMTPMail.this.log.d((Object)this, new Object[0]);
                        Transport.send((Message)this.createMessage(), (Address[])targetAddress);
                        SMTPMail.this.log.d((Object)"+\u90ae\u4ef6\u53d1\u9001\u6210\u529f+", new Object[0]);
                        if (this.success != null) {
                            SMTPMail.this.executor.execute(() -> this.success.onSuccess(this, receiver));
                        }
                    }
                    catch (MessagingException e) {
                        SMTPMail.this.log.d((Object)"-\u90ae\u4ef6\u53d1\u9001\u5931\u8d25-", new Object[0]);
                        if (this.fail == null) break block3;
                        SMTPMail.this.executor.execute(() -> this.fail.onFail(this, (Exception)((Object)e), receiver));
                    }
                }
            });
        }

        private Message createMessage() throws MessagingException {
            Properties props = new Properties();
            props.setProperty("mail.smtp.auth", "true");
            props.setProperty("mail.host", SMTPMail.this.host);
            props.setProperty("mail.transport.protocol", "smtp");
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SMTPMail.this.username, SMTPMail.this.password);
                }
            });
            MimeMessage msg = new MimeMessage(session);
            SMTPMail.this.log.d((Object)"\u8fde\u63a5\u6210\u529f,\u521b\u5efa\u90ae\u4ef6", new Object[0]);
            msg.setContent((Object)this.content, "text/plain; charset=UTF-8");
            msg.setSubject(this.subject);
            msg.setFrom((Address)new InternetAddress(SMTPMail.this.username));
            SMTPMail.this.log.d((Object)"\u90ae\u4ef6\u521b\u5efa\u6210\u529f", new Object[0]);
            return msg;
        }

        private InternetAddress[] createReceiver() {
            return (InternetAddress[])Stream.of(this.target).map(element -> {
                try {
                    return new InternetAddress(element);
                }
                catch (AddressException e) {
                    throw new RuntimeException(e);
                }
            }).filter(element -> element != null).toArray(InternetAddress[]::new);
        }
    }
}

